/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.multitable;

import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.multitable.TableServiceTask;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchiveTask
extends TableServiceTask {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveTask.class);

    ArchiveTask() {
    }

    @Override
    void run() {
        LOG.info("Run Archive with props: " + this.props);
        HoodieWriteConfig hoodieCfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withProps(this.props).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient(new HoodieSparkEngineContext(this.jsc), hoodieCfg);){
            UtilHelpers.retry(this.retry, () -> {
                client.archive();
                return 0;
            }, "Archive Failed");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TypedProperties props;
        private String basePath;
        private int retry;
        private JavaSparkContext jsc;

        public Builder withProps(TypedProperties props) {
            this.props = props;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withJsc(JavaSparkContext jsc) {
            this.jsc = jsc;
            return this;
        }

        public Builder withRetry(int retry) {
            this.retry = retry;
            return this;
        }

        public ArchiveTask build() {
            ArchiveTask archiveTask = new ArchiveTask();
            archiveTask.jsc = this.jsc;
            archiveTask.retry = this.retry;
            archiveTask.props = this.props;
            archiveTask.basePath = this.basePath;
            return archiveTask;
        }
    }
}

