/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.multitable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.multitable.ArchiveTask;
import org.apache.hudi.utilities.multitable.CleanTask;
import org.apache.hudi.utilities.multitable.ClusteringTask;
import org.apache.hudi.utilities.multitable.CompactionTask;
import org.apache.hudi.utilities.multitable.HoodieMultiTableServicesMain;
import org.apache.hudi.utilities.multitable.TableServicePipeline;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MultiTableServiceUtils.class);

    public static List<String> getTablesToBeServedFromProps(JavaSparkContext jsc, TypedProperties properties2) {
        List<String> tablePaths;
        StorageConfiguration<Configuration> conf = HadoopFSUtils.getStorageConfWithCopy(jsc.hadoopConfiguration());
        String combinedTablesString = properties2.getString("hoodie.tableservice.tablesToServe");
        boolean skipWrongPath = properties2.getBoolean("hoodie.tableservice.skipNonHudiTable", false);
        if (combinedTablesString == null) {
            return new ArrayList<String>();
        }
        String[] tablesArray = combinedTablesString.split(",");
        if (skipWrongPath) {
            tablePaths = Arrays.stream(tablesArray).filter(tablePath -> {
                if (MultiTableServiceUtils.isHoodieTable(new Path(tablePath), (Configuration)conf.unwrap())) {
                    return true;
                }
                LOG.warn("Hoodie table not found in path {}, skip", tablePath);
                return false;
            }).collect(Collectors.toList());
        } else {
            tablePaths = Arrays.asList(tablesArray);
            tablePaths.stream().filter(tablePath -> !MultiTableServiceUtils.isHoodieTable(new Path(tablePath), (Configuration)conf.unwrap())).findFirst().ifPresent(tablePath -> {
                throw new TableNotFoundException("Table not found: " + tablePath);
            });
        }
        return tablePaths;
    }

    public static List<String> findHoodieTablesUnderPath(JavaSparkContext jsc, String pathStr) {
        Path rootPath = new Path(pathStr);
        StorageConfiguration<Configuration> conf = HadoopFSUtils.getStorageConfWithCopy(jsc.hadoopConfiguration());
        if (MultiTableServiceUtils.isHoodieTable(rootPath, conf.unwrap())) {
            return Collections.singletonList(pathStr);
        }
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(jsc);
        CopyOnWriteArrayList<String> hoodieTablePaths = new CopyOnWriteArrayList<String>();
        CopyOnWriteArrayList<Path> pathsToList = new CopyOnWriteArrayList<Path>();
        pathsToList.add(rootPath);
        int listingParallelism = Math.min(1500, pathsToList.size());
        while (!pathsToList.isEmpty()) {
            List<FileStatus[]> dirToFileListing = engineContext.map(pathsToList, path -> {
                FileSystem fileSystem2 = path.getFileSystem((Configuration)conf.unwrap());
                return fileSystem2.listStatus(path);
            }, listingParallelism);
            pathsToList.clear();
            List dirs = dirToFileListing.stream().flatMap(Arrays::stream).filter(FileStatus::isDirectory).collect(Collectors.toList());
            if (dirs.isEmpty()) continue;
            List<Pair> dirResults = engineContext.map(dirs, fileStatus -> {
                if (MultiTableServiceUtils.isHoodieTable(fileStatus.getPath(), (Configuration)conf.unwrap())) {
                    return Pair.of(fileStatus, DirType.HOODIE_TABLE);
                }
                if (fileStatus.getPath().getName().equals(".hoodie")) {
                    return Pair.of(fileStatus, DirType.META_FOLDER);
                }
                return Pair.of(fileStatus, DirType.NORMAL_DIR);
            }, Math.min(1500, dirs.size()));
            ((Stream)dirResults.stream().parallel()).forEach(dirResult -> {
                FileStatus fileStatus = (FileStatus)dirResult.getLeft();
                if (dirResult.getRight() == DirType.HOODIE_TABLE) {
                    hoodieTablePaths.add(fileStatus.getPath().toString());
                } else if (dirResult.getRight() == DirType.NORMAL_DIR) {
                    pathsToList.add(fileStatus.getPath());
                }
            });
        }
        return hoodieTablePaths;
    }

    private static boolean isHoodieTable(Path path, Configuration conf) {
        try {
            FileSystem fs = path.getFileSystem(conf);
            return fs.exists(path) && fs.exists(new Path(path, ".hoodie"));
        }
        catch (Exception e) {
            throw new HoodieException("Error checking presence of partition meta file for " + path, e);
        }
    }

    public static TableServicePipeline buildTableServicePipeline(JavaSparkContext jsc, String basePath, HoodieMultiTableServicesMain.Config cfg, TypedProperties props) {
        TableServicePipeline pipeline = new TableServicePipeline();
        HoodieTableMetaClient metaClient = UtilHelpers.createMetaClient(jsc, basePath, true);
        TypedProperties propsWithTableConfig = new TypedProperties(metaClient.getTableConfig().getProps());
        propsWithTableConfig.putAll((Map<?, ?>)props);
        if (cfg.enableCompaction.booleanValue()) {
            pipeline.add(CompactionTask.newBuilder().withJsc(jsc).withBasePath(basePath).withParallelism(cfg.parallelism).withCompactionRunningMode(cfg.compactionRunningMode).withCompactionStrategyName(cfg.compactionStrategyClassName).withProps(propsWithTableConfig).withRetry(cfg.retry).withMetaclient(metaClient).build());
        }
        if (cfg.enableClustering.booleanValue()) {
            pipeline.add(ClusteringTask.newBuilder().withBasePath(basePath).withJsc(jsc).withParallelism(cfg.parallelism).withClusteringRunningMode(cfg.clusteringRunningMode).withProps(propsWithTableConfig).withRetry(cfg.retry).withMetaclient(metaClient).build());
        }
        if (cfg.enableClean.booleanValue()) {
            pipeline.add(CleanTask.newBuilder().withBasePath(basePath).withJsc(jsc).withRetry(cfg.retry).withProps(propsWithTableConfig).build());
        }
        if (cfg.enableArchive.booleanValue()) {
            pipeline.add(ArchiveTask.newBuilder().withBasePath(basePath).withJsc(jsc).withProps(propsWithTableConfig).withRetry(cfg.retry).build());
        }
        return pipeline;
    }

    static enum DirType {
        HOODIE_TABLE,
        META_FOLDER,
        NORMAL_DIR;

    }

    public static class Constants {
        public static final String TABLES_TO_BE_SERVED_PROP = "hoodie.tableservice.tablesToServe";
        public static final String TABLES_SKIP_WRONG_PATH = "hoodie.tableservice.skipNonHudiTable";
        public static final String COMMA_SEPARATOR = ",";
        private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    }
}

