/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.avro.processors.DateLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DecimalLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DurationLogicalTypeProcessor;
import org.apache.hudi.avro.processors.EnumTypeProcessor;
import org.apache.hudi.avro.processors.FixedTypeProcessor;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimestampMicroLogicalTypeProcessor;
import org.apache.hudi.avro.processors.TimestampMilliLogicalTypeProcessor;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.exception.HoodieJsonToRowConversionException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import scala.collection.JavaConverters;

public class MercifulJsonToRowConverter
extends MercifulJsonConverter {
    public MercifulJsonToRowConverter(boolean shouldSanitize, String invalidCharMask) {
        this(new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS), shouldSanitize, invalidCharMask);
    }

    public MercifulJsonToRowConverter(ObjectMapper mapper, boolean shouldSanitize, String invalidCharMask) {
        super(mapper, shouldSanitize, invalidCharMask);
    }

    public Row convertToRow(String json, Schema schema) {
        try {
            Map jsonObjectMap = (Map)this.mapper.readValue(json, Map.class);
            return this.convertJsonToRow(jsonObjectMap, schema);
        }
        catch (IOException | HoodieException e) {
            throw new HoodieJsonToRowConversionException("Failed to convert json to row", e);
        }
    }

    private Row convertJsonToRow(Map<String, Object> inputJson, Schema schema) {
        List fields2 = schema.getFields();
        ArrayList<Object> values2 = new ArrayList<Object>(Collections.nCopies(fields2.size(), null));
        for (Schema.Field f : fields2) {
            Object val = this.shouldSanitize ? MercifulJsonToRowConverter.getFieldFromJson(f, inputJson, schema.getFullName(), this.invalidCharMask) : inputJson.get(f.name());
            if (val == null) continue;
            values2.set(f.pos(), this.convertJsonField(val, f.name(), f.schema()));
        }
        return RowFactory.create((Object[])values2.toArray());
    }

    @Override
    protected JsonFieldProcessor generateDecimalLogicalTypeHandler() {
        return new DecimalToRowLogicalTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateDateLogicalTypeHandler() {
        return new DateToRowLogicalTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateDurationLogicalTypeHandler() {
        return new DurationToRowLogicalTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateBytesTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
                return Pair.of(true, value.toString().getBytes());
            }
        };
    }

    @Override
    protected JsonFieldProcessor generateFixedTypeHandler() {
        return new FixedToRowTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateEnumTypeHandler() {
        return new EnumToRowTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateRecordTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
                return Pair.of(true, MercifulJsonToRowConverter.this.convertJsonToRow((Map)value, schema));
            }
        };
    }

    @Override
    protected JsonFieldProcessor generateTimestampMilliLogicalTypeHandler() {
        return new TimestampMilliToRowLogicalTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateTimestampMicroLogicalTypeHandler() {
        return new TimestampMicroToRowLogicalTypeProcessor();
    }

    @Override
    protected JsonFieldProcessor generateArrayTypeHandler() {
        return new JsonFieldProcessor(){

            private List<Object> convertToJavaObject(Object value, String name2, Schema schema) {
                Schema elementSchema = schema.getElementType();
                ArrayList<Object> listRes = new ArrayList<Object>();
                for (Object v : (List)value) {
                    listRes.add(MercifulJsonToRowConverter.this.convertJsonField(v, name2, elementSchema));
                }
                return listRes;
            }

            @Override
            public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
                return Pair.of(true, this.convertToJavaObject(value, name2, schema).toArray());
            }
        };
    }

    @Override
    protected JsonFieldProcessor generateMapTypeHandler() {
        return new JsonFieldProcessor(){

            public Map<String, Object> convertToJavaObject(Object value, String name2, Schema schema) {
                Schema valueSchema = schema.getValueType();
                HashMap<String, Object> mapRes = new HashMap<String, Object>();
                for (Map.Entry v : ((Map)value).entrySet()) {
                    mapRes.put((String)v.getKey(), MercifulJsonToRowConverter.this.convertJsonField(v.getValue(), name2, valueSchema));
                }
                return mapRes;
            }

            @Override
            public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
                return Pair.of(true, JavaConverters.mapAsScalaMapConverter(this.convertToJavaObject(value, name2, schema)).asScala());
            }
        };
    }

    private static class TimestampMicroToRowLogicalTypeProcessor
    extends TimestampMicroLogicalTypeProcessor {
        private TimestampMicroToRowLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            Pair<Boolean, Object> result2 = this.convertCommon(new Parser.LongParser(){

                @Override
                public Pair<Boolean, Object> handleStringValue(String value) {
                    return this.convertDateTime(value, null, time -> Instant.EPOCH.until((Temporal)time, ChronoField.MICRO_OF_SECOND.getBaseUnit()));
                }
            }, value, schema);
            if (result2.getLeft().booleanValue()) {
                return Pair.of(true, new Timestamp((Long)result2.getRight() / 1000L));
            }
            return Pair.of(false, null);
        }
    }

    private static class TimestampMilliToRowLogicalTypeProcessor
    extends TimestampMilliLogicalTypeProcessor {
        private TimestampMilliToRowLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            Pair<Boolean, Object> result2 = this.convertCommon(new Parser.LongParser(){

                @Override
                public Pair<Boolean, Object> handleStringValue(String value) {
                    return this.convertDateTime(value, null, time -> Instant.EPOCH.until((Temporal)time, ChronoField.MILLI_OF_SECOND.getBaseUnit()));
                }
            }, value, schema);
            if (result2.getLeft().booleanValue()) {
                return Pair.of(true, new Timestamp((Long)result2.getRight()));
            }
            return Pair.of(false, null);
        }
    }

    private static class EnumToRowTypeProcessor
    extends EnumTypeProcessor {
        private EnumToRowTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            return Pair.of(true, this.convertToJavaObject(value, name2, schema));
        }
    }

    private static class FixedToRowTypeProcessor
    extends FixedTypeProcessor {
        private FixedToRowTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            return Pair.of(true, this.convertToJavaObject(value, name2, schema));
        }
    }

    private static class DateToRowLogicalTypeProcessor
    extends DateLogicalTypeProcessor {
        private DateToRowLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            return this.convertCommon(new Parser.DateParser(), value, schema);
        }
    }

    private static class DurationToRowLogicalTypeProcessor
    extends DurationLogicalTypeProcessor {
        private DurationToRowLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            throw new HoodieJsonToRowConversionException("Duration type is not supported in Row object");
        }
    }

    private class DecimalToRowLogicalTypeProcessor
    extends DecimalLogicalTypeProcessor {
        private DecimalToRowLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
            JsonFieldProcessor processor;
            Pair<Boolean, Object> fixedTypeResult;
            if (!DecimalToRowLogicalTypeProcessor.isValidDecimalTypeConfig(schema)) {
                return Pair.of(false, null);
            }
            if (schema.getType() == Schema.Type.FIXED && value instanceof List && (fixedTypeResult = (processor = MercifulJsonToRowConverter.this.generateFixedTypeHandler()).convert(value, name2, schema)).getLeft().booleanValue()) {
                byte[] byteArray = (byte[])fixedTypeResult.getRight();
                GenericData.Fixed fixedValue = new GenericData.Fixed(schema, byteArray);
                return Pair.of(true, new Conversions.DecimalConversion().fromFixed((GenericFixed)fixedValue, schema, schema.getLogicalType()));
            }
            Pair<Boolean, BigDecimal> parseResult = DecimalToRowLogicalTypeProcessor.parseObjectToBigDecimal(value, schema);
            return Pair.of(parseResult.getLeft(), parseResult.getRight());
        }
    }
}

