/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.utils.Utils;

public class Topic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String CLUSTER_METADATA_TOPIC_NAME = "__cluster_metadata";
    public static final TopicPartition CLUSTER_METADATA_TOPIC_PARTITION = new TopicPartition("__cluster_metadata", 0);
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = Collections.unmodifiableSet(Utils.mkSet("__consumer_offsets", "__transaction_state"));
    private static final int MAX_NAME_LENGTH = 249;

    public static void validate(String topic) {
        Topic.validate(topic, "Topic name", message -> {
            throw new InvalidTopicException((String)message);
        });
    }

    private static String detectInvalidTopic(String name2) {
        if (name2.isEmpty()) {
            return "the empty string is not allowed";
        }
        if (".".equals(name2)) {
            return "'.' is not allowed";
        }
        if ("..".equals(name2)) {
            return "'..' is not allowed";
        }
        if (name2.length() > 249) {
            return "the length of '" + name2 + "' is longer than the max allowed length " + 249;
        }
        if (!Topic.containsValidPattern(name2)) {
            return "'" + name2 + "' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'";
        }
        return null;
    }

    public static boolean isValid(String name2) {
        String reasonInvalid = Topic.detectInvalidTopic(name2);
        return reasonInvalid == null;
    }

    public static void validate(String name2, String logPrefix, Consumer<String> throwableConsumer) {
        String reasonInvalid = Topic.detectInvalidTopic(name2);
        if (reasonInvalid != null) {
            throwableConsumer.accept(logPrefix + " is invalid: " + reasonInvalid);
        }
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static String unifyCollisionChars(String topic) {
        return topic.replace('.', '_');
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return Topic.unifyCollisionChars(topicA).equals(Topic.unifyCollisionChars(topicB));
    }

    static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

