/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterPartitionRequestData
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The ID of the requesting broker"), new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker"), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The ID of the requesting broker"), new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker"), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("broker_id", Type.INT32, "The ID of the requesting broker"), new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker"), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public AlterPartitionRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterPartitionRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 56;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicData topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterPartitionRequestData)) {
            return false;
        }
        AlterPartitionRequestData other = (AlterPartitionRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + this.brokerId;
        hashCode2 = 31 * hashCode2 + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode2 = 31 * hashCode2 + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode2;
    }

    @Override
    public AlterPartitionRequestData duplicate() {
        AlterPartitionRequestData _duplicate = new AlterPartitionRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AlterPartitionRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterPartitionRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public AlterPartitionRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public AlterPartitionRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        int leaderEpoch;
        List<Integer> newIsr;
        byte leaderRecoveryState;
        int partitionEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index"), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition"), new Field("new_isr", new CompactArrayOf(Type.INT32), "The ISR for this partition"), new Field("partition_epoch", Type.INT32, "The expected epoch of the partition which is being updated. For legacy cluster this is the ZkVersion in the LeaderAndIsr request."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public PartitionData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.leaderEpoch = 0;
            this.newIsr = new ArrayList<Integer>(0);
            this.leaderRecoveryState = 0;
            this.partitionEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field newIsr was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.newIsr = newCollection;
            this.leaderRecoveryState = _version >= 1 ? _readable.readByte() : (byte)0;
            this.partitionEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeUnsignedVarint(this.newIsr.size() + 1);
            for (Integer newIsrElement : this.newIsr) {
                _writable.writeInt(newIsrElement);
            }
            if (_version >= 1) {
                _writable.writeByte(this.leaderRecoveryState);
            } else if (this.leaderRecoveryState != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderRecoveryState at version " + _version);
            }
            _writable.writeInt(this.partitionEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.newIsr.size() + 1));
            _size.addBytes(this.newIsr.size() * 4);
            if (_version >= 1) {
                _size.addBytes(1);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.newIsr == null ? other.newIsr != null : !this.newIsr.equals(other.newIsr)) {
                return false;
            }
            if (this.leaderRecoveryState != other.leaderRecoveryState) {
                return false;
            }
            if (this.partitionEpoch != other.partitionEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + this.partitionIndex;
            hashCode2 = 31 * hashCode2 + this.leaderEpoch;
            hashCode2 = 31 * hashCode2 + (this.newIsr == null ? 0 : this.newIsr.hashCode());
            hashCode2 = 31 * hashCode2 + this.leaderRecoveryState;
            hashCode2 = 31 * hashCode2 + this.partitionEpoch;
            return hashCode2;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newNewIsr = new ArrayList<Integer>(this.newIsr.size());
            for (Integer _element : this.newIsr) {
                newNewIsr.add(_element);
            }
            _duplicate.newIsr = newNewIsr;
            _duplicate.leaderRecoveryState = this.leaderRecoveryState;
            _duplicate.partitionEpoch = this.partitionEpoch;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", leaderEpoch=" + this.leaderEpoch + ", newIsr=" + MessageUtil.deepToString(this.newIsr.iterator()) + ", leaderRecoveryState=" + this.leaderRecoveryState + ", partitionEpoch=" + this.partitionEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> newIsr() {
            return this.newIsr;
        }

        public byte leaderRecoveryState() {
            return this.leaderRecoveryState;
        }

        public int partitionEpoch() {
            return this.partitionEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public PartitionData setNewIsr(List<Integer> v) {
            this.newIsr = v;
            return this;
        }

        public PartitionData setLeaderRecoveryState(byte v) {
            this.leaderRecoveryState = v;
            return this;
        }

        public PartitionData setPartitionEpoch(int v) {
            this.partitionEpoch = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index"), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition"), new Field("new_isr", new CompactArrayOf(Type.INT32), "The ISR for this partition"), new Field("leader_recovery_state", Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."), new Field("partition_epoch", Type.INT32, "The expected epoch of the partition which is being updated. For legacy cluster this is the ZkVersion in the LeaderAndIsr request."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TopicData
    implements Message {
        String topicName;
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The name of the topic to alter ISRs for"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The name of the topic to alter ISRs for"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_id", Type.UUID, "The ID of the topic to alter ISRs for"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TopicData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicData() {
            this.topicName = "";
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            if (_version <= 1) {
                int length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.topicId = _version >= 2 ? _readable.readUuid() : Uuid.ZERO_UUID;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 2) {
                _writable.writeUuid(this.topicId);
            }
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            if (_version <= 1) {
                byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_version >= 2) {
                _size.addBytes(16);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode2 = 31 * hashCode2 + this.topicId.hashCode();
            hashCode2 = 31 * hashCode2 + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode2;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicData setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

