/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.PartialDefaultRecord;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Utils;

public class DefaultRecord
implements Record {
    public static final int MAX_RECORD_OVERHEAD = 21;
    private static final int NULL_VARINT_SIZE_BYTES = ByteUtils.sizeOfVarint(-1);
    private final int sizeInBytes;
    private final byte attributes;
    private final long offset;
    private final long timestamp;
    private final int sequence;
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final Header[] headers;

    DefaultRecord(int sizeInBytes, byte attributes, long offset, long timestamp, int sequence, ByteBuffer key, ByteBuffer value, Header[] headers) {
        this.sizeInBytes = sizeInBytes;
        this.attributes = attributes;
        this.offset = offset;
        this.timestamp = timestamp;
        this.sequence = sequence;
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int sequence() {
        return this.sequence;
    }

    @Override
    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public byte attributes() {
        return this.attributes;
    }

    @Override
    public void ensureValid() {
    }

    @Override
    public int keySize() {
        return this.key == null ? -1 : this.key.remaining();
    }

    @Override
    public int valueSize() {
        return this.value == null ? -1 : this.value.remaining();
    }

    @Override
    public boolean hasKey() {
        return this.key != null;
    }

    @Override
    public ByteBuffer key() {
        return this.key == null ? null : this.key.duplicate();
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public ByteBuffer value() {
        return this.value == null ? null : this.value.duplicate();
    }

    @Override
    public Header[] headers() {
        return this.headers;
    }

    public static int writeTo(DataOutputStream out, int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value, Header[] headers) throws IOException {
        int sizeInBytes = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, key, value, headers);
        ByteUtils.writeVarint(sizeInBytes, out);
        int attributes = 0;
        out.write(attributes);
        ByteUtils.writeVarlong(timestampDelta, out);
        ByteUtils.writeVarint(offsetDelta, out);
        if (key == null) {
            ByteUtils.writeVarint(-1, out);
        } else {
            int keySize = key.remaining();
            ByteUtils.writeVarint(keySize, out);
            Utils.writeTo(out, key, keySize);
        }
        if (value == null) {
            ByteUtils.writeVarint(-1, out);
        } else {
            int valueSize = value.remaining();
            ByteUtils.writeVarint(valueSize, out);
            Utils.writeTo(out, value, valueSize);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers cannot be null");
        }
        ByteUtils.writeVarint(headers.length, out);
        for (Header header : headers) {
            String headerKey = header.key();
            if (headerKey == null) {
                throw new IllegalArgumentException("Invalid null header key found in headers");
            }
            byte[] utf8Bytes = Utils.utf8(headerKey);
            ByteUtils.writeVarint(utf8Bytes.length, out);
            out.write(utf8Bytes);
            byte[] headerValue = header.value();
            if (headerValue == null) {
                ByteUtils.writeVarint(-1, out);
                continue;
            }
            ByteUtils.writeVarint(headerValue.length, out);
            out.write(headerValue);
        }
        return ByteUtils.sizeOfVarint(sizeInBytes) + sizeInBytes;
    }

    @Override
    public boolean hasMagic(byte magic) {
        return magic >= 2;
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public boolean hasTimestampType(TimestampType timestampType) {
        return false;
    }

    public String toString() {
        return String.format("DefaultRecord(offset=%d, timestamp=%d, key=%d bytes, value=%d bytes)", this.offset, this.timestamp, this.key == null ? 0 : this.key.limit(), this.value == null ? 0 : this.value.limit());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRecord that = (DefaultRecord)o;
        return this.sizeInBytes == that.sizeInBytes && this.attributes == that.attributes && this.offset == that.offset && this.timestamp == that.timestamp && this.sequence == that.sequence && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Arrays.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result2 = this.sizeInBytes;
        result2 = 31 * result2 + this.attributes;
        result2 = 31 * result2 + Long.hashCode(this.offset);
        result2 = 31 * result2 + Long.hashCode(this.timestamp);
        result2 = 31 * result2 + this.sequence;
        result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + Arrays.hashCode(this.headers);
        return result2;
    }

    public static DefaultRecord readFrom(DataInput input, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) throws IOException {
        int sizeOfBodyInBytes = ByteUtils.readVarint(input);
        ByteBuffer recordBuffer = ByteBuffer.allocate(sizeOfBodyInBytes);
        input.readFully(recordBuffer.array(), 0, sizeOfBodyInBytes);
        int totalSizeInBytes = ByteUtils.sizeOfVarint(sizeOfBodyInBytes) + sizeOfBodyInBytes;
        return DefaultRecord.readFrom(recordBuffer, totalSizeInBytes, sizeOfBodyInBytes, baseOffset, baseTimestamp, baseSequence, logAppendTime);
    }

    public static DefaultRecord readFrom(ByteBuffer buffer, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) {
        int sizeOfBodyInBytes = ByteUtils.readVarint(buffer);
        if (buffer.remaining() < sizeOfBodyInBytes) {
            throw new InvalidRecordException("Invalid record size: expected " + sizeOfBodyInBytes + " bytes in record payload, but instead the buffer has only " + buffer.remaining() + " remaining bytes.");
        }
        int totalSizeInBytes = ByteUtils.sizeOfVarint(sizeOfBodyInBytes) + sizeOfBodyInBytes;
        return DefaultRecord.readFrom(buffer, totalSizeInBytes, sizeOfBodyInBytes, baseOffset, baseTimestamp, baseSequence, logAppendTime);
    }

    private static DefaultRecord readFrom(ByteBuffer buffer, int sizeInBytes, int sizeOfBodyInBytes, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) {
        try {
            int numHeaders;
            int recordStart = buffer.position();
            byte attributes = buffer.get();
            long timestampDelta = ByteUtils.readVarlong(buffer);
            long timestamp = baseTimestamp + timestampDelta;
            if (logAppendTime != null) {
                timestamp = logAppendTime;
            }
            int offsetDelta = ByteUtils.readVarint(buffer);
            long offset = baseOffset + (long)offsetDelta;
            int sequence = baseSequence >= 0 ? DefaultRecordBatch.incrementSequence(baseSequence, offsetDelta) : -1;
            ByteBuffer key = null;
            int keySize = ByteUtils.readVarint(buffer);
            if (keySize >= 0) {
                key = buffer.slice();
                key.limit(keySize);
                buffer.position(buffer.position() + keySize);
            }
            ByteBuffer value = null;
            int valueSize = ByteUtils.readVarint(buffer);
            if (valueSize >= 0) {
                value = buffer.slice();
                value.limit(valueSize);
                buffer.position(buffer.position() + valueSize);
            }
            if ((numHeaders = ByteUtils.readVarint(buffer)) < 0) {
                throw new InvalidRecordException("Found invalid number of record headers " + numHeaders);
            }
            if (numHeaders > buffer.remaining()) {
                throw new InvalidRecordException("Found invalid number of record headers. " + numHeaders + " is larger than the remaining size of the buffer");
            }
            Header[] headers = numHeaders == 0 ? Record.EMPTY_HEADERS : DefaultRecord.readHeaders(buffer, numHeaders);
            if (buffer.position() - recordStart != sizeOfBodyInBytes) {
                throw new InvalidRecordException("Invalid record size: expected to read " + sizeOfBodyInBytes + " bytes in record payload, but instead read " + (buffer.position() - recordStart));
            }
            return new DefaultRecord(sizeInBytes, attributes, offset, timestamp, sequence, key, value, headers);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new InvalidRecordException("Found invalid record structure", e);
        }
    }

    public static PartialDefaultRecord readPartiallyFrom(DataInput input, byte[] skipArray, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) throws IOException {
        int sizeOfBodyInBytes = ByteUtils.readVarint(input);
        int totalSizeInBytes = ByteUtils.sizeOfVarint(sizeOfBodyInBytes) + sizeOfBodyInBytes;
        return DefaultRecord.readPartiallyFrom(input, skipArray, totalSizeInBytes, sizeOfBodyInBytes, baseOffset, baseTimestamp, baseSequence, logAppendTime);
    }

    private static PartialDefaultRecord readPartiallyFrom(DataInput input, byte[] skipArray, int sizeInBytes, int sizeOfBodyInBytes, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) throws IOException {
        ByteBuffer skipBuffer = ByteBuffer.wrap(skipArray);
        skipBuffer.limit(0);
        try {
            PrimitiveRef.IntRef bytesRemaining = PrimitiveRef.ofInt(sizeOfBodyInBytes);
            byte attributes = DefaultRecord.readByte(skipBuffer, input, bytesRemaining);
            long timestampDelta = DefaultRecord.readVarLong(skipBuffer, input, bytesRemaining);
            long timestamp = baseTimestamp + timestampDelta;
            if (logAppendTime != null) {
                timestamp = logAppendTime;
            }
            int offsetDelta = DefaultRecord.readVarInt(skipBuffer, input, bytesRemaining);
            long offset = baseOffset + (long)offsetDelta;
            int sequence = baseSequence >= 0 ? DefaultRecordBatch.incrementSequence(baseSequence, offsetDelta) : -1;
            int keySize = DefaultRecord.skipLengthDelimitedField(skipBuffer, input, bytesRemaining);
            int valueSize = DefaultRecord.skipLengthDelimitedField(skipBuffer, input, bytesRemaining);
            int numHeaders = DefaultRecord.readVarInt(skipBuffer, input, bytesRemaining);
            if (numHeaders < 0) {
                throw new InvalidRecordException("Found invalid number of record headers " + numHeaders);
            }
            for (int i = 0; i < numHeaders; ++i) {
                int headerKeySize = DefaultRecord.skipLengthDelimitedField(skipBuffer, input, bytesRemaining);
                if (headerKeySize < 0) {
                    throw new InvalidRecordException("Invalid negative header key size " + headerKeySize);
                }
                DefaultRecord.skipLengthDelimitedField(skipBuffer, input, bytesRemaining);
            }
            if (bytesRemaining.value > 0 || skipBuffer.remaining() > 0) {
                throw new InvalidRecordException("Invalid record size: expected to read " + sizeOfBodyInBytes + " bytes in record payload, but there are still bytes remaining");
            }
            return new PartialDefaultRecord(sizeInBytes, attributes, offset, timestamp, sequence, keySize, valueSize);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new InvalidRecordException("Found invalid record structure", e);
        }
    }

    private static byte readByte(ByteBuffer buffer, DataInput input, PrimitiveRef.IntRef bytesRemaining) throws IOException {
        if (buffer.remaining() < 1 && bytesRemaining.value > 0) {
            DefaultRecord.readMore(buffer, input, bytesRemaining);
        }
        return buffer.get();
    }

    private static long readVarLong(ByteBuffer buffer, DataInput input, PrimitiveRef.IntRef bytesRemaining) throws IOException {
        if (buffer.remaining() < 10 && bytesRemaining.value > 0) {
            DefaultRecord.readMore(buffer, input, bytesRemaining);
        }
        return ByteUtils.readVarlong(buffer);
    }

    private static int readVarInt(ByteBuffer buffer, DataInput input, PrimitiveRef.IntRef bytesRemaining) throws IOException {
        if (buffer.remaining() < 5 && bytesRemaining.value > 0) {
            DefaultRecord.readMore(buffer, input, bytesRemaining);
        }
        return ByteUtils.readVarint(buffer);
    }

    private static int skipLengthDelimitedField(ByteBuffer buffer, DataInput input, PrimitiveRef.IntRef bytesRemaining) throws IOException {
        boolean needMore = false;
        int sizeInBytes = -1;
        int bytesToSkip = -1;
        while (true) {
            if (needMore) {
                DefaultRecord.readMore(buffer, input, bytesRemaining);
                needMore = false;
            }
            if (bytesToSkip < 0) {
                if (buffer.remaining() < 5 && bytesRemaining.value > 0) {
                    needMore = true;
                    continue;
                }
                sizeInBytes = ByteUtils.readVarint(buffer);
                if (sizeInBytes <= 0) {
                    return sizeInBytes;
                }
                bytesToSkip = sizeInBytes;
                continue;
            }
            if (bytesToSkip <= buffer.remaining()) break;
            bytesToSkip -= buffer.remaining();
            buffer.position(buffer.limit());
            needMore = true;
        }
        buffer.position(buffer.position() + bytesToSkip);
        return sizeInBytes;
    }

    private static void readMore(ByteBuffer buffer, DataInput input, PrimitiveRef.IntRef bytesRemaining) throws IOException {
        if (bytesRemaining.value > 0) {
            byte[] array = buffer.array();
            int stepsToLeftShift = buffer.position();
            int bytesToLeftShift = buffer.remaining();
            for (int i = 0; i < bytesToLeftShift; ++i) {
                array[i] = array[i + stepsToLeftShift];
            }
            int bytesRead = Math.min(bytesRemaining.value, array.length - bytesToLeftShift);
            input.readFully(array, bytesToLeftShift, bytesRead);
            buffer.rewind();
            buffer.limit(bytesToLeftShift + bytesRead);
            bytesRemaining.value -= bytesRead;
        } else {
            throw new InvalidRecordException("Invalid record size: expected to read more bytes in record payload");
        }
    }

    private static Header[] readHeaders(ByteBuffer buffer, int numHeaders) {
        Header[] headers = new Header[numHeaders];
        for (int i = 0; i < numHeaders; ++i) {
            int headerKeySize = ByteUtils.readVarint(buffer);
            if (headerKeySize < 0) {
                throw new InvalidRecordException("Invalid negative header key size " + headerKeySize);
            }
            ByteBuffer headerKeyBuffer = buffer.slice();
            headerKeyBuffer.limit(headerKeySize);
            buffer.position(buffer.position() + headerKeySize);
            ByteBuffer headerValue = null;
            int headerValueSize = ByteUtils.readVarint(buffer);
            if (headerValueSize >= 0) {
                headerValue = buffer.slice();
                headerValue.limit(headerValueSize);
                buffer.position(buffer.position() + headerValueSize);
            }
            headers[i] = new RecordHeader(headerKeyBuffer, headerValue);
        }
        return headers;
    }

    public static int sizeInBytes(int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value, Header[] headers) {
        int bodySize = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, key, value, headers);
        return bodySize + ByteUtils.sizeOfVarint(bodySize);
    }

    public static int sizeInBytes(int offsetDelta, long timestampDelta, int keySize, int valueSize, Header[] headers) {
        int bodySize = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, keySize, valueSize, headers);
        return bodySize + ByteUtils.sizeOfVarint(bodySize);
    }

    private static int sizeOfBodyInBytes(int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value, Header[] headers) {
        int keySize = key == null ? -1 : key.remaining();
        int valueSize = value == null ? -1 : value.remaining();
        return DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, keySize, valueSize, headers);
    }

    public static int sizeOfBodyInBytes(int offsetDelta, long timestampDelta, int keySize, int valueSize, Header[] headers) {
        int size = 1;
        size += ByteUtils.sizeOfVarint(offsetDelta);
        size += ByteUtils.sizeOfVarlong(timestampDelta);
        return size += DefaultRecord.sizeOf(keySize, valueSize, headers);
    }

    private static int sizeOf(int keySize, int valueSize, Header[] headers) {
        int size = 0;
        size = keySize < 0 ? (size += NULL_VARINT_SIZE_BYTES) : (size += ByteUtils.sizeOfVarint(keySize) + keySize);
        size = valueSize < 0 ? (size += NULL_VARINT_SIZE_BYTES) : (size += ByteUtils.sizeOfVarint(valueSize) + valueSize);
        if (headers == null) {
            throw new IllegalArgumentException("Headers cannot be null");
        }
        size += ByteUtils.sizeOfVarint(headers.length);
        for (Header header : headers) {
            String headerKey = header.key();
            if (headerKey == null) {
                throw new IllegalArgumentException("Invalid null header key found in headers");
            }
            int headerKeySize = Utils.utf8Length(headerKey);
            size += ByteUtils.sizeOfVarint(headerKeySize) + headerKeySize;
            byte[] headerValue = header.value();
            if (headerValue == null) {
                size += NULL_VARINT_SIZE_BYTES;
                continue;
            }
            size += ByteUtils.sizeOfVarint(headerValue.length) + headerValue.length;
        }
        return size;
    }

    static int recordSizeUpperBound(ByteBuffer key, ByteBuffer value, Header[] headers) {
        int keySize = key == null ? -1 : key.remaining();
        int valueSize = value == null ? -1 : value.remaining();
        return 21 + DefaultRecord.sizeOf(keySize, valueSize, headers);
    }
}

