/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;

public class AddOffsetsToTxnRequest
extends AbstractRequest {
    private final AddOffsetsToTxnRequestData data;

    public AddOffsetsToTxnRequest(AddOffsetsToTxnRequestData data2, short version) {
        super(ApiKeys.ADD_OFFSETS_TO_TXN, version);
        this.data = data2;
    }

    @Override
    public AddOffsetsToTxnRequestData data() {
        return this.data;
    }

    @Override
    public AddOffsetsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new AddOffsetsToTxnResponse(new AddOffsetsToTxnResponseData().setErrorCode(Errors.forException(e).code()).setThrottleTimeMs(throttleTimeMs));
    }

    public static AddOffsetsToTxnRequest parse(ByteBuffer buffer, short version) {
        return new AddOffsetsToTxnRequest(new AddOffsetsToTxnRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AddOffsetsToTxnRequest> {
        public AddOffsetsToTxnRequestData data;

        public Builder(AddOffsetsToTxnRequestData data2) {
            super(ApiKeys.ADD_OFFSETS_TO_TXN);
            this.data = data2;
        }

        @Override
        public AddOffsetsToTxnRequest build(short version) {
            return new AddOffsetsToTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

