/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public final class FetchSnapshotResponse
extends AbstractResponse {
    private final FetchSnapshotResponseData data;

    public FetchSnapshotResponse(FetchSnapshotResponseData data2) {
        super(ApiKeys.FETCH_SNAPSHOT);
        this.data = data2;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors2 = new HashMap<Errors, Integer>();
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            errors2.put(topLevelError, 1);
        }
        for (FetchSnapshotResponseData.TopicSnapshot topicResponse : this.data.topics()) {
            for (FetchSnapshotResponseData.PartitionSnapshot partitionResponse : topicResponse.partitions()) {
                errors2.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors2;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public FetchSnapshotResponseData data() {
        return this.data;
    }

    public static FetchSnapshotResponseData withTopLevelError(Errors error) {
        return new FetchSnapshotResponseData().setErrorCode(error.code());
    }

    public static FetchSnapshotResponseData singleton(TopicPartition topicPartition, UnaryOperator<FetchSnapshotResponseData.PartitionSnapshot> operator) {
        FetchSnapshotResponseData.PartitionSnapshot partitionSnapshot = (FetchSnapshotResponseData.PartitionSnapshot)operator.apply(new FetchSnapshotResponseData.PartitionSnapshot().setIndex(topicPartition.partition()));
        return new FetchSnapshotResponseData().setTopics(Collections.singletonList(new FetchSnapshotResponseData.TopicSnapshot().setName(topicPartition.topic()).setPartitions(Collections.singletonList(partitionSnapshot))));
    }

    public static Optional<FetchSnapshotResponseData.PartitionSnapshot> forTopicPartition(FetchSnapshotResponseData data2, TopicPartition topicPartition) {
        return data2.topics().stream().filter(topic -> topic.name().equals(topicPartition.topic())).flatMap(topic -> topic.partitions().stream()).filter(parition -> parition.index() == topicPartition.partition()).findAny();
    }

    public static FetchSnapshotResponse parse(ByteBuffer buffer, short version) {
        return new FetchSnapshotResponse(new FetchSnapshotResponseData(new ByteBufferAccessor(buffer), version));
    }
}

