/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class FindCoordinatorResponse
extends AbstractResponse {
    private final FindCoordinatorResponseData data;

    public FindCoordinatorResponse(FindCoordinatorResponseData data2) {
        super(ApiKeys.FIND_COORDINATOR);
        this.data = data2;
    }

    @Override
    public FindCoordinatorResponseData data() {
        return this.data;
    }

    public Node node() {
        return new Node(this.data.nodeId(), this.data.host(), this.data.port());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (!this.data.coordinators().isEmpty()) {
            HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
            for (FindCoordinatorResponseData.Coordinator coordinator : this.data.coordinators()) {
                this.updateErrorCounts(errorCounts, Errors.forCode(coordinator.errorCode()));
            }
            return errorCounts;
        }
        return this.errorCounts(this.error());
    }

    public static FindCoordinatorResponse parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorResponse(new FindCoordinatorResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public List<FindCoordinatorResponseData.Coordinator> coordinators() {
        if (!this.data.coordinators().isEmpty()) {
            return this.data.coordinators();
        }
        FindCoordinatorResponseData.Coordinator coordinator = new FindCoordinatorResponseData.Coordinator().setErrorCode(this.data.errorCode()).setErrorMessage(this.data.errorMessage()).setKey(null).setNodeId(this.data.nodeId()).setHost(this.data.host()).setPort(this.data.port());
        return Collections.singletonList(coordinator);
    }

    public static FindCoordinatorResponse prepareOldResponse(Errors error, Node node) {
        FindCoordinatorResponseData data2 = new FindCoordinatorResponseData();
        data2.setErrorCode(error.code()).setErrorMessage(error.message()).setNodeId(node.id()).setHost(node.host()).setPort(node.port());
        return new FindCoordinatorResponse(data2);
    }

    public static FindCoordinatorResponse prepareResponse(Errors error, String key, Node node) {
        FindCoordinatorResponseData data2 = new FindCoordinatorResponseData();
        data2.setCoordinators(Collections.singletonList(new FindCoordinatorResponseData.Coordinator().setErrorCode(error.code()).setErrorMessage(error.message()).setKey(key).setHost(node.host()).setPort(node.port()).setNodeId(node.id())));
        return new FindCoordinatorResponse(data2);
    }

    public static FindCoordinatorResponse prepareErrorResponse(Errors error, List<String> keys2) {
        FindCoordinatorResponseData data2 = new FindCoordinatorResponseData();
        ArrayList<FindCoordinatorResponseData.Coordinator> coordinators = new ArrayList<FindCoordinatorResponseData.Coordinator>(keys2.size());
        for (String key : keys2) {
            FindCoordinatorResponseData.Coordinator coordinator = new FindCoordinatorResponseData.Coordinator().setErrorCode(error.code()).setErrorMessage(error.message()).setKey(key).setHost(Node.noNode().host()).setPort(Node.noNode().port()).setNodeId(Node.noNode().id());
            coordinators.add(coordinator);
        }
        data2.setCoordinators(coordinators);
        return new FindCoordinatorResponse(data2);
    }
}

