/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class UpdateFeaturesResponse
extends AbstractResponse {
    private final UpdateFeaturesResponseData data;

    public UpdateFeaturesResponse(UpdateFeaturesResponseData data2) {
        super(ApiKeys.UPDATE_FEATURES);
        this.data = data2;
    }

    public ApiError topLevelError() {
        return new ApiError(Errors.forCode(this.data.errorCode()), this.data.errorMessage());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(errorCounts, Errors.forCode(this.data.errorCode()));
        for (UpdateFeaturesResponseData.UpdatableFeatureResult result2 : this.data.results()) {
            this.updateErrorCounts(errorCounts, Errors.forCode(result2.errorCode()));
        }
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public UpdateFeaturesResponseData data() {
        return this.data;
    }

    public static UpdateFeaturesResponse parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesResponse(new UpdateFeaturesResponseData(new ByteBufferAccessor(buffer), version));
    }

    public static UpdateFeaturesResponse createWithErrors(ApiError topLevelError, Map<String, ApiError> updateErrors, int throttleTimeMs) {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        for (Map.Entry<String, ApiError> updateError : updateErrors.entrySet()) {
            String feature = updateError.getKey();
            ApiError error = updateError.getValue();
            UpdateFeaturesResponseData.UpdatableFeatureResult result2 = new UpdateFeaturesResponseData.UpdatableFeatureResult();
            result2.setFeature(feature).setErrorCode(error.error().code()).setErrorMessage(error.message());
            results.add(result2);
        }
        UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(topLevelError.error().code()).setErrorMessage(topLevelError.message()).setResults(results).setThrottleTimeMs(throttleTimeMs);
        return new UpdateFeaturesResponse(responseData);
    }
}

