/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidatorFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.VerificationKeyResolverFactory;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerValidatorCallbackHandler.class);
    private static final Map<VerificationKeyResolverKey, CloseableVerificationKeyResolver> VERIFICATION_KEY_RESOLVER_CACHE = new HashMap<VerificationKeyResolverKey, CloseableVerificationKeyResolver>();
    private CloseableVerificationKeyResolver verificationKeyResolver;
    private AccessTokenValidator accessTokenValidator;
    private boolean isInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        CloseableVerificationKeyResolver verificationKeyResolver;
        Map<String, Object> moduleOptions = JaasOptionsUtils.getOptions(saslMechanism, jaasConfigEntries);
        Map<VerificationKeyResolverKey, CloseableVerificationKeyResolver> map2 = VERIFICATION_KEY_RESOLVER_CACHE;
        synchronized (map2) {
            VerificationKeyResolverKey key = new VerificationKeyResolverKey(configs, moduleOptions);
            verificationKeyResolver = VERIFICATION_KEY_RESOLVER_CACHE.computeIfAbsent(key, k -> new RefCountingVerificationKeyResolver(VerificationKeyResolverFactory.create(configs, saslMechanism, moduleOptions)));
        }
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs, saslMechanism, verificationKeyResolver);
        this.init(verificationKeyResolver, accessTokenValidator);
    }

    public void init(CloseableVerificationKeyResolver verificationKeyResolver, AccessTokenValidator accessTokenValidator) {
        this.verificationKeyResolver = verificationKeyResolver;
        this.accessTokenValidator = accessTokenValidator;
        try {
            verificationKeyResolver.init();
        }
        catch (Exception e) {
            throw new KafkaException("The OAuth validator configuration encountered an error when initializing the VerificationKeyResolver", e);
        }
        this.isInitialized = true;
    }

    @Override
    public void close() {
        if (this.verificationKeyResolver != null) {
            try {
                this.verificationKeyResolver.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.checkInitialized();
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                this.handleValidatorCallback((OAuthBearerValidatorCallback)callback);
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                this.handleExtensionsValidatorCallback((OAuthBearerExtensionsValidatorCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleValidatorCallback(OAuthBearerValidatorCallback callback) {
        this.checkInitialized();
        try {
            OAuthBearerToken token = this.accessTokenValidator.validate(callback.tokenValue());
            callback.token(token);
        }
        catch (ValidateException e) {
            log.warn(e.getMessage(), (Throwable)e);
            callback.error("invalid_token", null, null);
        }
    }

    private void handleExtensionsValidatorCallback(OAuthBearerExtensionsValidatorCallback extensionsValidatorCallback) {
        this.checkInitialized();
        extensionsValidatorCallback.inputExtensions().map().forEach((extensionName, v) -> extensionsValidatorCallback.valid((String)extensionName));
    }

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException(String.format("To use %s, first call the configure or init method", this.getClass().getSimpleName()));
        }
    }

    private static class RefCountingVerificationKeyResolver
    implements CloseableVerificationKeyResolver {
        private final CloseableVerificationKeyResolver delegate;
        private final AtomicInteger count = new AtomicInteger(0);

        public RefCountingVerificationKeyResolver(CloseableVerificationKeyResolver delegate) {
            this.delegate = delegate;
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return this.delegate.resolveKey(jws, nestingContext);
        }

        @Override
        public void init() throws IOException {
            if (this.count.incrementAndGet() == 1) {
                this.delegate.init();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.count.decrementAndGet() == 0) {
                this.delegate.close();
            }
        }
    }

    private static class VerificationKeyResolverKey {
        private final Map<String, ?> configs;
        private final Map<String, Object> moduleOptions;

        public VerificationKeyResolverKey(Map<String, ?> configs, Map<String, Object> moduleOptions) {
            this.configs = configs;
            this.moduleOptions = moduleOptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerificationKeyResolverKey that = (VerificationKeyResolverKey)o;
            return this.configs.equals(that.configs) && this.moduleOptions.equals(that.moduleOptions);
        }

        public int hashCode() {
            return Objects.hash(this.configs, this.moduleOptions);
        }
    }
}

