/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hudi.HoodieCDCFileIndex;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkHoodieTableFileIndex;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Contains$;
import org.apache.spark.sql.catalyst.expressions.EndsWith$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.IsNotNull$;
import org.apache.spark.sql.catalyst.expressions.IsNull$;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not$;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.expressions.StartsWith$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.HoodieFormatTrait;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.AlwaysFalse;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class FileFormatUtilsForFileGroupReader$
implements SparkAdapterSupport {
    public static FileFormatUtilsForFileGroupReader$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new FileFormatUtilsForFileGroupReader$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        FileFormatUtilsForFileGroupReader$ fileFormatUtilsForFileGroupReader$ = this;
        synchronized (fileFormatUtilsForFileGroupReader$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public LogicalPlan applyNewFileFormatChanges(LogicalPlan scanOperation, LogicalPlan logicalRelation, HadoopFsRelation fs) {
        StructType structType;
        ParquetFileFormat ff = (ParquetFileFormat)fs.fileFormat();
        ((HoodieFormatTrait)ff).isProjected_$eq(true);
        FileIndex fileIndex = fs.location();
        if (fileIndex instanceof HoodieCDCFileIndex) {
            HoodieCDCFileIndex hoodieCDCFileIndex = (HoodieCDCFileIndex)fileIndex;
            structType = hoodieCDCFileIndex.cdcRelation().schema();
        } else if (fileIndex instanceof SparkHoodieTableFileIndex) {
            SparkHoodieTableFileIndex sparkHoodieTableFileIndex = (SparkHoodieTableFileIndex)fileIndex;
            structType = sparkHoodieTableFileIndex.schema();
        } else {
            throw new MatchError((Object)fileIndex);
        }
        StructType tableSchema = structType;
        Seq resolvedSchema = logicalRelation.resolve(tableSchema, fs.sparkSession().sessionState().analyzer().resolver());
        LogicalPlan unfilteredPlan = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.partitionSchema().fields())).isEmpty() && this.sparkAdapter().getCatalystPlanUtils().produceSameOutput(scanOperation, logicalRelation) ? new Project(resolvedSchema, scanOperation) : scanOperation;
        return this.applyFiltersToPlan(unfilteredPlan, tableSchema, (Seq<Attribute>)resolvedSchema, ((HoodieFormatTrait)ff).getRequiredFilters());
    }

    public LogicalPlan applyFiltersToPlan(LogicalPlan plan, StructType tableSchema, Seq<Attribute> resolvedSchema, Seq<Filter> filters) {
        Seq expressionFilters = (Seq)filters.map((Function1 & Serializable & scala.Serializable)f -> (Expression)FileFormatUtilsForFileGroupReader$.filterToExpression$1(f, (Function1 & Serializable & scala.Serializable)n -> FileFormatUtilsForFileGroupReader$.toRef$2(n, tableSchema, resolvedSchema)).get(), Seq$.MODULE$.canBuildFrom());
        if (expressionFilters.nonEmpty()) {
            return new org.apache.spark.sql.catalyst.plans.logical.Filter((Expression)expressionFilters.reduceLeft((Function2)And$.MODULE$), plan);
        }
        return plan;
    }

    private static final Option zipAttributeAndValue$1(String name2, Object value, Function1 toRef$1) {
        return FileFormatUtilsForFileGroupReader$.zip$1((Option)toRef$1.apply((Object)name2), FileFormatUtilsForFileGroupReader$.toLiteral$1(value));
    }

    private static final Option translate$1(Filter filter, Function1 toRef$1) {
        Filter filter2 = filter;
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            return FileFormatUtilsForFileGroupReader$.zip$1(FileFormatUtilsForFileGroupReader$.translate$1(left, toRef$1), FileFormatUtilsForFileGroupReader$.translate$1(right, toRef$1)).map(And$.MODULE$.tupled());
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            return FileFormatUtilsForFileGroupReader$.zip$1(FileFormatUtilsForFileGroupReader$.translate$1(left, toRef$1), FileFormatUtilsForFileGroupReader$.translate$1(right, toRef$1)).map(Or$.MODULE$.tupled());
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            return FileFormatUtilsForFileGroupReader$.translate$1(child, toRef$1).map((Function1)Not$.MODULE$);
        }
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attribute = equalTo.attribute();
            Object value2 = equalTo.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value2, toRef$1).map(EqualTo$.MODULE$.tupled());
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value3 = equalNullSafe.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value3, toRef$1).map(EqualNullSafe$.MODULE$.tupled());
        }
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            return ((Option)toRef$1.apply((Object)attribute)).map((Function1)IsNull$.MODULE$);
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            return ((Option)toRef$1.apply((Object)attribute)).map((Function1)IsNotNull$.MODULE$);
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values2 = in.values();
            Seq literals = (Seq)Predef$.MODULE$.genericArrayOps((Object)values2).toSeq().flatMap((Function1 & Serializable & scala.Serializable)value -> Option$.MODULE$.option2Iterable(FileFormatUtilsForFileGroupReader$.toLiteral$1(value)), Seq$.MODULE$.canBuildFrom());
            if (literals.length() == values2.length) {
                return ((Option)toRef$1.apply((Object)attribute)).map((Function1 & Serializable & scala.Serializable)x$1 -> new org.apache.spark.sql.catalyst.expressions.In((Expression)x$1, literals));
            }
            return None$.MODULE$;
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value4 = greaterThan.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value4, toRef$1).map(GreaterThan$.MODULE$.tupled());
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value5 = greaterThanOrEqual.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value5, toRef$1).map(GreaterThanOrEqual$.MODULE$.tupled());
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value6 = lessThan.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value6, toRef$1).map(LessThan$.MODULE$.tupled());
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value7 = lessThanOrEqual.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value7, toRef$1).map(LessThanOrEqual$.MODULE$.tupled());
        }
        if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value8 = stringContains.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value8, toRef$1).map(Contains$.MODULE$.tupled());
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value9 = stringStartsWith.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value9, toRef$1).map(StartsWith$.MODULE$.tupled());
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value10 = stringEndsWith.value();
            return FileFormatUtilsForFileGroupReader$.zipAttributeAndValue$1(attribute, value10, toRef$1).map(EndsWith$.MODULE$.tupled());
        }
        if (filter2 instanceof AlwaysTrue) {
            return new Some((Object)new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$));
        }
        if (filter2 instanceof AlwaysFalse) {
            return new Some((Object)new Literal((Object)BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$));
        }
        throw new MatchError((Object)filter2);
    }

    private static final Option filterToExpression$1(Filter filter, Function1 toRef) {
        return FileFormatUtilsForFileGroupReader$.translate$1(filter, toRef);
    }

    private static final Option zip$1(Option a, Option b) {
        return ((TraversableLike)Option$.MODULE$.option2Iterable(a).zip((GenIterable)Option$.MODULE$.option2Iterable(b), Iterable$.MODULE$.canBuildFrom())).headOption();
    }

    private static final Option toLiteral$1(Object value) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply(value)).toOption();
    }

    public static final /* synthetic */ Attribute $anonfun$applyFiltersToPlan$4(Seq resolvedSchema$1, int index) {
        return (Attribute)resolvedSchema$1.apply(index);
    }

    private static final Option toRef$2(String attr, StructType tableSchema$1, Seq resolvedSchema$1) {
        return tableSchema$1.getFieldIndex(attr).map((Function1 & Serializable & scala.Serializable)index -> FileFormatUtilsForFileGroupReader$.$anonfun$applyFiltersToPlan$4(resolvedSchema$1, BoxesRunTime.unboxToInt((Object)index)));
    }

    private FileFormatUtilsForFileGroupReader$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

