/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.DeleteSavepointProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qO\u0001\rEK2,G/Z*bm\u0016\u0004x.\u001b8u!J|7-\u001a3ve\u0016T!AE\n\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u0015+\u000591m\\7nC:$'B\u0001\f\u0018\u0003\u0011AW\u000fZ5\u000b\u0005aI\u0012aA:rY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tS\u0005\u000b\t\u0003E\rj\u0011!E\u0005\u0003IE\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0012'\u0013\t9\u0013C\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3feB\u0011\u0011\u0006L\u0007\u0002U)\u00111&G\u0001\tS:$XM\u001d8bY&\u0011QF\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u0002#\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003M\u00022\u0001N\u001c:\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$!B!se\u0006L\bC\u0001\u0012;\u0013\tY\u0014C\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C/\u0005)A/\u001f9fg&\u0011A)\u0011\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003\u0015j\u00032aS*W\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002P?\u00051AH]8pizJ\u0011AN\u0005\u0003%V\nq\u0001]1dW\u0006<W-\u0003\u0002U+\n\u00191+Z9\u000b\u0005I+\u0004CA,Y\u001b\u00059\u0012BA-\u0018\u0005\r\u0011vn\u001e\u0005\u00067\"\u0001\r\u0001X\u0001\u0005CJ<7\u000f\u0005\u0002#;&\u0011a,\u0005\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003\u0005\u0004\"A\t2\n\u0005\r\f\"!\u0003)s_\u000e,G-\u001e:f\u0003a!U\r\\3uKN\u000bg/\u001a9pS:$\bK]8dK\u0012,(/\u001a\t\u0003E-\u0019\"aC4\u0011\u0005QB\u0017BA56\u0005\u0019\te.\u001f*fMR\tQ-\u0001\u0003O\u00036+U#A7\u0011\u00059\u0014hBA8q!\tiU'\u0003\u0002rk\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\tX'A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0003a\u0004B!_A\u0001K5\t!P\u0003\u0002|y\u0006Aa-\u001e8di&|gN\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001{\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class DeleteSavepointProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return DeleteSavepointProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return DeleteSavepointProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args2, this.PARAMETERS()[2]);
        ObjectRef instantTime = ObjectRef.create((Object)((String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get()));
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        if (StringUtils.isNullOrEmpty((String)instantTime.elem)) {
            instantTime.elem = completedInstants.lastInstant().get().requestedTime();
        }
        String[] instantTimes = ((String)instantTime.elem).split(",");
        SparkRDDWriteClient<?> client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, (Map<String, String>)Predef$.MODULE$.Map().empty(), tableName);
        BooleanRef result2 = BooleanRef.create((boolean)true);
        ObjectRef currentInstant = ObjectRef.create((Object)"");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instantTimes)).foreach((Function1 & Serializable & scala.Serializable)it -> {
            DeleteSavepointProcedure.$anonfun$call$1(this, metaClient, currentInstant, completedInstants, client, instantTime, result2, it);
            return BoxedUnit.UNIT;
        });
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result2.elem)})), (List)Nil$.MODULE$);
    }

    @Override
    public Procedure build() {
        return new DeleteSavepointProcedure();
    }

    public static final /* synthetic */ void $anonfun$call$1(DeleteSavepointProcedure $this, HoodieTableMetaClient metaClient$1, ObjectRef currentInstant$1, HoodieTimeline completedInstants$1, SparkRDDWriteClient client$1, ObjectRef instantTime$1, BooleanRef result$1, String it) {
        InstantGenerator instantGenerator = metaClient$1.getTimelineLayout().getInstantGenerator();
        HoodieInstant savePoint = instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", it);
        currentInstant$1.elem = it;
        if (!completedInstants$1.containsInstant(savePoint)) {
            throw new HoodieException(new StringBuilder(29).append("Commit ").append(it).append(" not found in Commits ").append(completedInstants$1).toString());
        }
        try {
            try {
                client$1.deleteSavepoint(it);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("The commit ").append((String)instantTime$1.elem).append(" has been deleted savepoint.").toString());
            }
            catch (HoodieSavepointException hoodieSavepointException) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Failed: Could not delete savepoint ").append((String)currentInstant$1.elem).append(".").toString());
                result$1.elem = false;
            }
        }
        finally {
            client$1.close();
        }
    }

    public DeleteSavepointProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(1, "instant_time", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "path", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("delete_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

