/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieCorruptBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowHoodieLogFileMetadataProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001D\u0007\u00019!)A\u0005\u0001C\u0001K!)q\u0005\u0001C!Q!)!\u0007\u0001C!g!)!\b\u0001C!w!)\u0011\u000b\u0001C!%\u001e)a+\u0004E\u0001/\u001a)A\"\u0004E\u00011\")Ae\u0002C\u00019\"9Ql\u0002b\u0001\n\u0003q\u0006BB4\bA\u0003%q\fC\u0003i\u000f\u0011\u0005\u0011N\u0001\u0012TQ><\bj\\8eS\u0016dun\u001a$jY\u0016lU\r^1eCR\f\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u001d=\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t\u0001\u0012#A\u0004d_6l\u0017M\u001c3\u000b\u0005I\u0019\u0012\u0001\u00025vI&T!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000f\"!\tqr$D\u0001\u000e\u0013\t\u0001SBA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003=\tJ!aI\u0007\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001'!\tq\u0002!\u0001\u0006qCJ\fW.\u001a;feN,\u0012!\u000b\t\u0004U5zS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y\u0001\u0014BA\u0019\u000e\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0015=,H\u000f];u)f\u0004X-F\u00015!\t)\u0004(D\u00017\u0015\t94#A\u0003usB,7/\u0003\u0002:m\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003y1\u00032!P#I\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B7\u00051AH]8pizJ\u0011\u0001L\u0005\u0003\t.\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\u0011[\u0003CA%K\u001b\u0005\u0019\u0012BA&\u0014\u0005\r\u0011vn\u001e\u0005\u0006\u001b\u0012\u0001\rAT\u0001\u0005CJ<7\u000f\u0005\u0002\u001f\u001f&\u0011\u0001+\u0004\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003M\u0003\"A\b+\n\u0005Uk!!\u0003)s_\u000e,G-\u001e:f\u0003\t\u001a\u0006n\\<I_>$\u0017.\u001a'pO\u001aKG.Z'fi\u0006$\u0017\r^1Qe>\u001cW\rZ;sKB\u0011adB\n\u0003\u000fe\u0003\"A\u000b.\n\u0005m[#AB!osJ+g\rF\u0001X\u0003\u0011q\u0015)T#\u0016\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t1\fgn\u001a\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0004TiJLgnZ\u0001\u0006\u001d\u0006kU\tI\u0001\bEVLG\u000eZ3s+\u0005Q\u0007cA6qC5\tAN\u0003\u0002n]\u0006Aa-\u001e8di&|gN\u0003\u0002pG\u0006!Q\u000f^5m\u0013\t\tHN\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowHoodieLogFileMetadataProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return ShowHoodieLogFileMetadataProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowHoodieLogFileMetadataProcedure$.MODULE$.NAME();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "log_file_path_pattern", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("instant_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("record_count", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("block_type", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("header_metadata", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("footer_metadata", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        this.checkArgs(this.parameters(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.parameters()[0]);
        String logFilePathPattern = (String)this.getArgValueOrDefault(args2, this.parameters()[1]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.parameters()[2]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieStorage storage2 = this.createMetaClient(this.jsc(), basePath).getStorage();
        List logFilePaths = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(FSUtils.getGlobStatusExcludingMetaFolder(storage2, new StoragePath(logFilePathPattern)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString()).toList();
        HashMap commitCountAndMetadata = new HashMap();
        IntRef numCorruptBlocks = IntRef.create((int)0);
        IntRef dummyInstantTimeCount = IntRef.create((int)0);
        logFilePaths.foreach((Function1 & Serializable & scala.Serializable)logFilePath -> {
            ShowHoodieLogFileMetadataProcedure.$anonfun$call$2(storage2, numCorruptBlocks, dummyInstantTimeCount, commitCountAndMetadata, logFilePath);
            return BoxedUnit.UNIT;
        });
        ArrayList rows = new ArrayList();
        ObjectMapper objectMapper = new ObjectMapper();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(commitCountAndMetadata).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ShowHoodieLogFileMetadataProcedure.$anonfun$call$4(rows, objectMapper, x0$1);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowHoodieLogFileMetadataProcedure();
    }

    public static final /* synthetic */ void $anonfun$call$2(HoodieStorage storage$1, IntRef numCorruptBlocks$1, IntRef dummyInstantTimeCount$1, HashMap commitCountAndMetadata$1, String logFilePath) {
        java.util.List<StoragePathInfo> statuses = storage$1.listDirectEntries(new StoragePath(logFilePath));
        Schema schema = TableSchemaResolver.readSchemaFromLogFile(storage$1, new StoragePath(logFilePath));
        HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(storage$1, new HoodieLogFile(statuses.get(0).getPath()), schema);
        while (reader.hasNext()) {
            Serializable serializable;
            HoodieLogBlock block = (HoodieLogBlock)reader.next();
            AtomicInteger recordCount = new AtomicInteger(0);
            String instantTime = null;
            if (block instanceof HoodieCorruptBlock) {
                try {
                    instantTime = block.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                    if (instantTime == null) {
                        throw new Exception(new StringBuilder(21).append("Invalid instant time ").append(instantTime).toString());
                    }
                }
                catch (Exception exception) {
                    ++numCorruptBlocks$1.elem;
                    instantTime = new StringBuilder(14).append("corrupt_block_").append(numCorruptBlocks$1.elem).toString();
                }
            } else {
                HoodieLogBlock hoodieLogBlock;
                instantTime = block.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                if (instantTime == null) {
                    ++dummyInstantTimeCount$1.elem;
                    instantTime = new StringBuilder(19).append("dummy_instant_time_").append(dummyInstantTimeCount$1.elem).toString();
                }
                if ((hoodieLogBlock = block) instanceof HoodieDataBlock) {
                    HoodieDataBlock hoodieDataBlock = (HoodieDataBlock)hoodieLogBlock;
                    ClosableIterator recordItr = hoodieDataBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(recordItr).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)recordCount.incrementAndGet()));
                    recordItr.close();
                } else {
                    throw new MatchError((Object)hoodieLogBlock);
                }
            }
            if (commitCountAndMetadata$1.containsKey(instantTime)) {
                java.util.List list = (java.util.List)commitCountAndMetadata$1.get(instantTime);
                serializable = BoxesRunTime.boxToBoolean((boolean)list.add(new Tuple3((Object)block.getBlockType(), (Object)new Tuple2(block.getLogBlockHeader(), block.getLogBlockFooter()), (Object)BoxesRunTime.boxToInteger((int)recordCount.get()))));
                continue;
            }
            ArrayList<Tuple3> list = new ArrayList<Tuple3>();
            list.add(new Tuple3((Object)block.getBlockType(), (Object)new Tuple2(block.getLogBlockHeader(), block.getLogBlockFooter()), (Object)BoxesRunTime.boxToInteger((int)recordCount.get())));
            serializable = commitCountAndMetadata$1.put(instantTime, list);
        }
        reader.close();
    }

    public static final /* synthetic */ void $anonfun$call$4(ArrayList rows$1, ObjectMapper objectMapper$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String instantTime = (String)tuple2._1();
            java.util.List values2 = (java.util.List)tuple2._2();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(values2).asScala()).foreach((Function1 & Serializable & scala.Serializable)tuple3 -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, tuple3._3(), ((Enum)tuple3._1()).toString(), objectMapper$1.writeValueAsString(((Tuple2)tuple3._2())._1()), objectMapper$1.writeValueAsString(((Tuple2)tuple3._2())._2())})))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

