/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Misc;

public class STGroupDir
extends STGroup {
    public String groupDirName;
    public URL root;

    public STGroupDir(String dirName) {
        this(dirName, '<', '>');
    }

    public STGroupDir(String dirName, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.groupDirName = dirName;
        File dir = new File(dirName);
        if (dir.exists() && dir.isDirectory()) {
            try {
                this.root = dir.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new STException("can't load dir " + dirName, e);
            }
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.root = cl.getResource(dirName);
            if (this.root == null) {
                cl = this.getClass().getClassLoader();
                this.root = cl.getResource(dirName);
            }
            if (this.root == null) {
                throw new IllegalArgumentException("No such directory: " + dirName);
            }
        }
    }

    public STGroupDir(String dirName, String encoding) {
        this(dirName, encoding, '<', '>');
    }

    public STGroupDir(String dirName, String encoding, char delimiterStartChar, char delimiterStopChar) {
        this(dirName, delimiterStartChar, delimiterStopChar);
        this.encoding = encoding;
    }

    public STGroupDir(URL root, String encoding, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.root = root;
        this.encoding = encoding;
    }

    protected CompiledST load(String name2) {
        String parent = Misc.getPrefix(name2);
        URL groupFileURL = null;
        try {
            groupFileURL = new URL(this.root + parent + ".stg");
        }
        catch (MalformedURLException e) {
            this.errMgr.internalError(null, "bad URL: " + this.root + parent + ".stg", e);
            return null;
        }
        InputStream is = null;
        try {
            is = groupFileURL.openStream();
        }
        catch (FileNotFoundException fnfe) {
            return this.loadTemplateFile(parent, name2 + ".st");
        }
        catch (IOException ioe) {
            this.errMgr.internalError(null, "can't load template file " + name2, ioe);
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            this.errMgr.internalError(null, "can't close template file stream " + name2, ioe);
        }
        this.loadGroupFile(parent, this.root + parent + ".stg");
        return this.rawGetTemplate(name2);
    }

    public CompiledST loadTemplateFile(String prefix, String fileName) {
        ANTLRInputStream fs;
        URL f = null;
        try {
            f = new URL(this.root + "/" + fileName);
        }
        catch (MalformedURLException me) {
            this.errMgr.runTimeError(null, null, 0, ErrorType.INVALID_TEMPLATE_NAME, me, (Object)(this.root + fileName));
            return null;
        }
        try {
            fs = new ANTLRInputStream(f.openStream(), this.encoding);
            fs.name = fileName;
        }
        catch (IOException ioe) {
            return null;
        }
        return this.loadTemplateFile(prefix, fileName, (CharStream)fs);
    }

    public String getName() {
        return this.groupDirName;
    }

    public String getFileName() {
        return this.root.getFile();
    }

    public URL getRootDirURL() {
        return this.root;
    }
}

