/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import java.util.Map;
import org.apache.hudi.com.google.protobuf.Descriptors;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaProtobufSerializer<T extends Message>
extends AbstractKafkaProtobufSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private LRUCache<Descriptors.Descriptor, ProtobufSchema> schemaCache;

    public KafkaProtobufSerializer() {
        this.schemaCache = new LRUCache(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.schemaCache = new LRUCache(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
        this.schemaCache = new LRUCache(cacheCapacity);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaProtobufSerializerConfig(configs));
    }

    @Override
    public byte[] serialize(String topic, T record) {
        if (record == null) {
            return null;
        }
        ProtobufSchema schema = this.schemaCache.get(record.getDescriptorForType());
        if (schema == null) {
            schema = ProtobufSchemaUtils.getSchema(record);
            this.schemaCache.put(record.getDescriptorForType(), schema);
        }
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, (ParsedSchema)schema), topic, this.isKey, record, schema);
    }

    @Override
    public void close() {
    }
}

