/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.OptionalDependency;
import io.javalin.http.Context;
import io.javalin.http.InternalServerErrorResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0006JG\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0004\b\u0000\u0010\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u00060\u0015j\u0002`\u00160\u0014\u0012\u0004\u0012\u0002H\u00110\u00132\u0012\u0010\u0017\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0015j\u0002`\u00160\u0014\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0005J\u0014\u0010!\u001a\u00020\u00052\n\u0010\"\u001a\u00060\u0015j\u0002`\u0016H\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010(\u001a\u00020\u00062\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0014J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0006H\u0007J\b\u0010,\u001a\u00020\u000eH\u0007J\u0006\u0010-\u001a\u00020\u0006J\u0015\u0010.\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b/J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0007J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u0005032\u0006\u00104\u001a\u00020\u0005J\u0018\u00105\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0007J\b\u00106\u001a\u00020\u000eH\u0007J\u0010\u00107\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/javalin/core/util/Util;", "", "()V", "dependencyCheckCache", "Ljava/util/HashMap;", "", "", "assertWebjarInstalled", "dependency", "Lio/javalin/core/util/OptionalDependency;", "classExists", "className", "dependencyIsPresent", "ensureDependencyPresent", "", "startupCheck", "findByClass", "T", "map", "", "Ljava/lang/Class;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exceptionClass", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "formatBuildTime", "buildTime", "getChecksumAndReset", "inputStream", "Ljava/io/ByteArrayInputStream;", "getFileUrl", "Ljava/net/URL;", "path", "getPort", "e", "getResourceUrl", "getWebjarPublicPath", "ctx", "Lio/javalin/http/Context;", "getWebjarResourceUrl", "isKotlinClass", "clazz", "logJavalinBanner", "showBanner", "logJavalinVersion", "loggingLibraryExists", "missingDependencyMessage", "missingDependencyMessage$javalin", "normalizeContextPath", "contextPath", "pathToList", "", "pathString", "prefixContextPath", "printHelpfulMessageIfLoggerIsMissing", "serviceImplementationExists", "javalin"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();
    @NotNull
    private static final HashMap<String, Boolean> dependencyCheckCache = new HashMap();

    private Util() {
    }

    @JvmStatic
    @NotNull
    public static final String normalizeContextPath(@NotNull String contextPath) {
        Intrinsics.checkNotNullParameter(contextPath, "contextPath");
        CharSequence charSequence = Intrinsics.stringPlus("/", contextPath);
        Object object = "/{2,}";
        boolean bl = false;
        object = new Regex((String)object);
        String string = "/";
        boolean bl2 = false;
        return StringsKt.removeSuffix(((Regex)object).replace(charSequence, string), (CharSequence)"/");
    }

    @JvmStatic
    @NotNull
    public static final String prefixContextPath(@NotNull String contextPath, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter(contextPath, "contextPath");
        Intrinsics.checkNotNullParameter(path, "path");
        if (Intrinsics.areEqual(path, "*")) {
            string = path;
        } else {
            CharSequence charSequence = contextPath + '/' + path;
            Object object = "/{2,}";
            boolean bl = false;
            object = new Regex((String)object);
            String string2 = "/";
            boolean bl2 = false;
            string = ((Regex)object).replace(charSequence, string2);
        }
        return string;
    }

    public final boolean classExists(@NotNull String className) {
        boolean bl;
        Intrinsics.checkNotNullParameter(className, "className");
        try {
            Class.forName(className);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean serviceImplementationExists(String className) {
        boolean bl;
        try {
            Class<?> serviceClass = Class.forName(className);
            ServiceLoader<?> loader = ServiceLoader.load(serviceClass);
            Intrinsics.checkNotNullExpressionValue(loader, "loader");
            bl = CollectionsKt.any((Iterable)loader);
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final boolean dependencyIsPresent(@NotNull OptionalDependency dependency) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        try {
            Util.ensureDependencyPresent$default(this, dependency, false, 2, null);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final void ensureDependencyPresent(@NotNull OptionalDependency dependency, boolean startupCheck) {
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        if (Intrinsics.areEqual(dependencyCheckCache.get(dependency.getTestClass()), true)) {
            return;
        }
        if (!this.classExists(dependency.getTestClass())) {
            String message = this.missingDependencyMessage$javalin(dependency);
            if (startupCheck) {
                throw new IllegalStateException(message);
            }
            JavalinLogger.warn$default(message, null, 2, null);
            throw new InternalServerErrorResponse(message, null, 2, null);
        }
        Map map2 = dependencyCheckCache;
        String string = dependency.getTestClass();
        Boolean bl = true;
        boolean bl2 = false;
        map2.put(string, bl);
    }

    public static /* synthetic */ void ensureDependencyPresent$default(Util util, OptionalDependency optionalDependency, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        util.ensureDependencyPresent(optionalDependency, bl);
    }

    @NotNull
    public final String missingDependencyMessage$javalin(@NotNull OptionalDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        return StringsKt.trimMargin$default("|\n            |-------------------------------------------------------------------\n            |Missing dependency '" + dependency.getDisplayName() + "'. Add the dependency.\n            |\n            |pom.xml:\n            |<dependency>\n            |    <groupId>" + dependency.getGroupId() + "</groupId>\n            |    <artifactId>" + dependency.getArtifactId() + "</artifactId>\n            |    <version>" + dependency.getVersion() + "</version>\n            |</dependency>\n            |\n            |build.gradle:\n            |implementation group: '" + dependency.getGroupId() + "', name: '" + dependency.getArtifactId() + "', version: '" + dependency.getVersion() + "'\n            |\n            |Find the latest version here:\n            |https://search.maven.org/search?q=" + URLEncoder.encode("g:" + dependency.getGroupId() + " AND a:" + dependency.getArtifactId(), "UTF-8") + "\n            |-------------------------------------------------------------------", null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> pathToList(@NotNull String pathString) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(pathString, "pathString");
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)pathString, stringArray, false, 0, 6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            boolean bl3 = charSequence.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    public static final void printHelpfulMessageIfLoggerIsMissing() {
        if (!INSTANCE.loggingLibraryExists()) {
            System.err.println(StringsKt.trimMargin$default("\n            |-------------------------------------------------------------------\n            |" + INSTANCE.missingDependencyMessage$javalin(OptionalDependency.SLF4JSIMPLE) + "\n            |-------------------------------------------------------------------\n            |OR\n            |-------------------------------------------------------------------\n            |" + INSTANCE.missingDependencyMessage$javalin(OptionalDependency.SLF4J_PROVIDER_API) + " and\n            |" + INSTANCE.missingDependencyMessage$javalin(OptionalDependency.SLF4J_PROVIDER_SIMPLE) + "\n            |-------------------------------------------------------------------\n            |Visit https://javalin.io/documentation#logging if you need more help", null, 1, null));
        }
    }

    public final boolean loggingLibraryExists() {
        return this.classExists(OptionalDependency.SLF4JSIMPLE.getTestClass()) || this.serviceImplementationExists(OptionalDependency.SLF4J_PROVIDER_API.getTestClass());
    }

    @JvmStatic
    public static final void logJavalinBanner(boolean showBanner) {
        if (showBanner) {
            JavalinLogger.info$default(Intrinsics.stringPlus("\n", "       __                      __ _            __ __\n      / /____ _ _   __ ____ _ / /(_)____      / // /\n __  / // __ `/| | / // __ `// // // __ \\    / // /_\n/ /_/ // /_/ / | |/ // /_/ // // // / / /   /__  __/\n\\____/ \\__,_/  |___/ \\__,_//_//_//_/ /_/      /_/\n\n          https://javalin.io/documentation\n"), null, 2, null);
        }
    }

    @JvmStatic
    public static final void logJavalinVersion() {
        try {
            Object object = new Properties();
            boolean bl = false;
            boolean bl2 = false;
            Properties it = object;
            boolean bl3 = false;
            String propertiesPath = "META-INF/maven/io.javalin/javalin/pom.properties";
            it.load(INSTANCE.getClass().getClassLoader().getResourceAsStream(propertiesPath));
            Properties properties2 = object;
            String[] stringArray = new String[2];
            Intrinsics.checkNotNull(properties2.getProperty("version"));
            Intrinsics.checkNotNull(properties2.getProperty("buildTime"));
            Object object2 = object = CollectionsKt.listOf(stringArray);
            boolean bl4 = false;
            String version = (String)object2.get(0);
            Object object3 = object;
            boolean bl5 = false;
            String buildTime = (String)object3.get(1);
            JavalinLogger.startup("You are running Javalin " + version + " (released " + INSTANCE.formatBuildTime(buildTime) + ").");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String formatBuildTime(String buildTime) {
        Object object;
        try {
            Instant[] instantArray = new Instant[]{Instant.parse(buildTime), Instant.now()};
            Object object2 = object = CollectionsKt.listOf(instantArray);
            boolean bl = false;
            Instant release = (Instant)object2.get(0);
            Object object3 = object;
            boolean bl2 = false;
            Instant now = (Instant)object3.get(1);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM d, yyyy").withLocale(Locale.US).withZone(ZoneId.of("Z"));
            object = Intrinsics.stringPlus(formatter.format(release), now.isAfter(release.plus(90L, ChronoUnit.DAYS)) ? ". Your Javalin version is " + ChronoUnit.DAYS.between(release, now) + " days old. Consider checking for a newer version." : "");
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    @NotNull
    public final String getChecksumAndReset(@NotNull ByteArrayInputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        inputStream.mark(Integer.MAX_VALUE);
        CheckedInputStream cis = new CheckedInputStream(inputStream, new Adler32());
        int n = cis.read();
        while (n > -1) {
            n = cis.read();
        }
        inputStream.reset();
        return String.valueOf(cis.getChecksum().getValue());
    }

    @JvmStatic
    @Nullable
    public static final URL getResourceUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return INSTANCE.getClass().getClassLoader().getResource(path);
    }

    @JvmStatic
    @NotNull
    public static final String getWebjarPublicPath(@NotNull Context ctx, @NotNull OptionalDependency dependency) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        return ctx.contextPath() + "/webjars/" + dependency.getArtifactId() + '/' + dependency.getVersion();
    }

    @JvmStatic
    @Nullable
    public static final Object assertWebjarInstalled(@NotNull OptionalDependency dependency) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        try {
            object = Util.getWebjarResourceUrl(dependency);
        }
        catch (Exception e) {
            JavalinLogger.warn$default(INSTANCE.missingDependencyMessage$javalin(dependency), null, 2, null);
            object = Unit.INSTANCE;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final URL getWebjarResourceUrl(@NotNull OptionalDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, "dependency");
        String webjarBaseUrl = "META-INF/resources/webjars";
        return Util.getResourceUrl(webjarBaseUrl + '/' + dependency.getArtifactId() + '/' + dependency.getVersion());
    }

    @Nullable
    public final URL getFileUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return new File(path).exists() ? new File(path).toURI().toURL() : null;
    }

    public final boolean isKotlinClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        try {
            Annotation[] annotationArray = clazz.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "clazz.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                if (!StringsKt.contains$default((CharSequence)JvmClassMappingKt.getAnnotationClass(annotation).toString(), "kotlin.Metadata", false, 2, null)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getPort(@NotNull Exception e) {
        String string;
        block2: {
            void var1_1;
            Intrinsics.checkNotNullParameter(e, "e");
            String string2 = e.getMessage();
            Intrinsics.checkNotNull(string2);
            String $this$takeLastWhile$iv = string2;
            boolean $i$f$takeLastWhile = false;
            int n = StringsKt.getLastIndex($this$takeLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$takeLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it != ':')) {
                    String string3 = $this$takeLastWhile$iv;
                    void var6_7 = index$iv + true;
                    boolean bl3 = false;
                    String string4 = string3.substring((int)var6_7);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
                    break block2;
                }
                --index$iv;
            }
            string = var1_1;
        }
        return string;
    }

    @Nullable
    public final <T> T findByClass(@NotNull Map<Class<? extends Exception>, ? extends T> map2, @NotNull Class<? extends Exception> exceptionClass) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(exceptionClass, "exceptionClass");
        Map<Class<Exception>, T> map3 = map2;
        boolean bl = false;
        T t = map3.get(exceptionClass);
        if (t == null) {
            boolean bl2 = false;
            for (Class<? extends Exception> superclass = exceptionClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                Map<Class<Exception>, T> map4 = map2;
                Class<? extends Exception> clazz = superclass;
                boolean bl3 = false;
                if (!map4.containsKey(clazz)) continue;
                map4 = map2;
                clazz = superclass;
                bl3 = false;
                return map4.get(clazz);
            }
            return null;
        }
        return t;
    }
}

