/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.function.Function;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class DataSourceWriteOptions$ {
    public static final DataSourceWriteOptions$ MODULE$ = new DataSourceWriteOptions$();
    private static final String BULK_INSERT_OPERATION_OPT_VAL = WriteOperationType.BULK_INSERT.value();
    private static final String INSERT_OPERATION_OPT_VAL = WriteOperationType.INSERT.value();
    private static final String UPSERT_OPERATION_OPT_VAL = WriteOperationType.UPSERT.value();
    private static final String DELETE_OPERATION_OPT_VAL = WriteOperationType.DELETE.value();
    private static final String DELETE_PARTITION_OPERATION_OPT_VAL = WriteOperationType.DELETE_PARTITION.value();
    private static final String BOOTSTRAP_OPERATION_OPT_VAL = WriteOperationType.BOOTSTRAP.value();
    private static final String INSERT_OVERWRITE_OPERATION_OPT_VAL = WriteOperationType.INSERT_OVERWRITE.value();
    private static final String INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL = WriteOperationType.INSERT_OVERWRITE_TABLE.value();
    private static final ConfigProperty<String> OPERATION = ConfigProperty.key("hoodie.datasource.write.operation").defaultValue(MODULE$.UPSERT_OPERATION_OPT_VAL()).withValidValues(WriteOperationType.INSERT.value(), WriteOperationType.INSERT_PREPPED.value(), WriteOperationType.UPSERT.value(), WriteOperationType.UPSERT_PREPPED.value(), WriteOperationType.BULK_INSERT.value(), WriteOperationType.BULK_INSERT_PREPPED.value(), WriteOperationType.DELETE.value(), WriteOperationType.DELETE_PREPPED.value(), WriteOperationType.BOOTSTRAP.value(), WriteOperationType.INSERT_OVERWRITE.value(), WriteOperationType.CLUSTER.value(), WriteOperationType.DELETE_PARTITION.value(), WriteOperationType.INSERT_OVERWRITE_TABLE.value(), WriteOperationType.COMPACT.value(), WriteOperationType.ALTER_SCHEMA.value()).withDocumentation("Whether to do upsert, insert or bulk_insert for the write operation. Use bulk_insert to load new data into a table, and there on use upsert/insert. bulk insert uses a disk based write path to scale to load large inputs without need to cache it.");
    private static final String COW_TABLE_TYPE_OPT_VAL = HoodieTableType.COPY_ON_WRITE.name();
    private static final String MOR_TABLE_TYPE_OPT_VAL = HoodieTableType.MERGE_ON_READ.name();
    private static final ConfigProperty<String> TABLE_TYPE = ConfigProperty.key("hoodie.datasource.write.table.type").defaultValue(MODULE$.COW_TABLE_TYPE_OPT_VAL()).withValidValues(MODULE$.COW_TABLE_TYPE_OPT_VAL(), MODULE$.MOR_TABLE_TYPE_OPT_VAL()).withAlternatives("hoodie.datasource.write.storage.type").withDocumentation("The table type for the underlying data, for this write. This can\u2019t change between writes.");
    private static final String SPARK_SQL_WRITES_PREPPED_KEY = "_hoodie.spark.sql.writes.prepped";
    private static final ConfigProperty<String> TABLE_NAME = ConfigProperty.key("hoodie.datasource.write.table.name").noDefaultValue().markAdvanced().withDocumentation("Table name for the datasource write. Also used to register the table into meta stores.");
    private static final ConfigProperty<String> PRECOMBINE_FIELD = HoodieWriteConfig.PRECOMBINE_FIELD_NAME;
    private static final ConfigProperty<String> PAYLOAD_CLASS_NAME = HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME;
    private static final ConfigProperty<String> RECORD_MERGE_IMPL_CLASSES = HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES;
    private static final ConfigProperty<String> RECORD_MERGE_STRATEGY_ID = HoodieWriteConfig.RECORD_MERGE_STRATEGY_ID;
    private static final ConfigProperty<String> RECORD_MERGE_MODE = HoodieWriteConfig.RECORD_MERGE_MODE;
    private static final ConfigProperty<String> RECORDKEY_FIELD = KeyGeneratorOptions.RECORDKEY_FIELD_NAME;
    private static final ConfigProperty<String> SECONDARYKEY_COLUMN_NAME = KeyGeneratorOptions.SECONDARYKEY_COLUMN_NAME;
    private static final ConfigProperty<String> PARTITIONPATH_FIELD = KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME;
    private static final ConfigProperty<String> HIVE_STYLE_PARTITIONING = KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE;
    private static final Function<HoodieConfig, Option<String>> keyGeneratorInferFunc = JFunction$.MODULE$.toJavaFunction((Function1 & Serializable)config -> Option.of(DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(config.getProps())));
    private static final ConfigProperty<String> KEYGENERATOR_CLASS_NAME = ConfigProperty.key("hoodie.datasource.write.keygenerator.class").defaultValue(SimpleKeyGenerator.class.getName()).withInferFunction(MODULE$.keyGeneratorInferFunc()).markAdvanced().withDocumentation("Key generator class, that implements `org.apache.hudi.keygen.KeyGenerator`");
    private static final ConfigProperty<String> KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED = KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED;
    private static final ConfigProperty<String> ENABLE_ROW_WRITER = ConfigProperty.key("hoodie.datasource.write.row.writer.enable").defaultValue("true").withInferFunction(JFunction$.MODULE$.toJavaFunction((Function1 & Serializable)config -> {
        Option<Object> option;
        String string = config.getString(MODULE$.OPERATION());
        String string2 = WriteOperationType.BULK_INSERT.value();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (!config.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS) && config.getBooleanOrDefault(HoodieWriteConfig.COMBINE_BEFORE_INSERT)) {
                option = Option.of("false");
                return option;
            }
        }
        option = Option.empty();
        return option;
    })).markAdvanced().withDocumentation("When set to true, will perform write operations directly using the spark native `Row` representation, avoiding any additional conversion costs.");
    @Deprecated
    private static final ConfigProperty<String> SQL_ENABLE_BULK_INSERT = ConfigProperty.key("hoodie.sql.bulk.insert.enable").defaultValue("false").markAdvanced().deprecatedAfter("0.14.0").withDocumentation("When set to true, the sql insert statement will use bulk insert. This config is deprecated as of 0.14.0. Please use hoodie.spark.sql.insert.into.operation instead.");
    @Deprecated
    private static final ConfigProperty<String> SQL_INSERT_MODE = ConfigProperty.key("hoodie.sql.insert.mode").defaultValue("upsert").markAdvanced().deprecatedAfter("0.14.0").withDocumentation("Insert mode when insert data to pk-table. The optional modes are: upsert, strict and non-strict.For upsert mode, insert statement do the upsert operation for the pk-table which will update the duplicate record.For strict mode, insert statement will keep the primary key uniqueness constraint which do not allow duplicate record.While for non-strict mode, hudi just do the insert operation for the pk-table. This config is deprecated as of 0.14.0. Please use hoodie.spark.sql.insert.into.operation and hoodie.datasource.insert.dup.policy as you see fit.");
    private static final ConfigProperty<String> COMMIT_METADATA_KEYPREFIX = ConfigProperty.key("hoodie.datasource.write.commitmeta.key.prefix").defaultValue("_").markAdvanced().withDocumentation("Option keys beginning with this prefix, are automatically added to the commit/deltacommit metadata. This is useful to store checkpointing information, in a consistent way with the hudi timeline");
    @Deprecated
    private static final ConfigProperty<String> INSERT_DROP_DUPS = ConfigProperty.key("hoodie.datasource.write.insert.drop.duplicates").defaultValue("false").markAdvanced().withDocumentation("If set to true, records from the incoming dataframe will not overwrite existing records with the same key during the write operation. <br /> **Note** Just for Insert operation in Spark SQL writing since 0.14.0, users can switch to the config `hoodie.datasource.insert.dup.policy` instead for a simplified duplicate handling experience. The new config will be incorporated into all other writing flows and this config will be fully deprecated in future releases.");
    private static final ConfigProperty<String> PARTITIONS_TO_DELETE = ConfigProperty.key("hoodie.datasource.write.partitions.to.delete").noDefaultValue().markAdvanced().withDocumentation("Comma separated list of partitions to delete. Allows use of wildcard *");
    private static final ConfigProperty<String> STREAMING_RETRY_CNT = ConfigProperty.key("hoodie.datasource.write.streaming.retry.count").defaultValue("3").markAdvanced().withDocumentation("Config to indicate how many times streaming job should retry for a failed micro batch.");
    private static final ConfigProperty<String> STREAMING_RETRY_INTERVAL_MS = ConfigProperty.key("hoodie.datasource.write.streaming.retry.interval.ms").defaultValue("2000").markAdvanced().withDocumentation(" Config to indicate how long (by millisecond) before a retry should issued for failed microbatch");
    private static final ConfigProperty<String> STREAMING_IGNORE_FAILED_BATCH = ConfigProperty.key("hoodie.datasource.write.streaming.ignore.failed.batch").defaultValue("false").markAdvanced().withDocumentation("Config to indicate whether to ignore any non exception error (e.g. writestatus error) within a streaming microbatch. Turning this on, could hide the write status errors while the spark checkpoint moves ahead.So, would recommend users to use this with caution.");
    private static final ConfigProperty<String> STREAMING_CHECKPOINT_IDENTIFIER = ConfigProperty.key("hoodie.datasource.write.streaming.checkpoint.identifier").defaultValue("default_single_writer").markAdvanced().sinceVersion("0.13.0").withDocumentation("A stream identifier used for HUDI to fetch the right checkpoint(`batch id` to be more specific) corresponding this writer. Please note that keep the identifier an unique value for different writer if under multi-writer scenario. If the value is not set, will only keep the checkpoint info in the memory. This could introduce the potential issue that the job is restart(`batch id` is lost) while spark checkpoint write fails, causing spark will retry and rewrite the data.");
    private static final ConfigProperty<String> STREAMING_DISABLE_COMPACTION = ConfigProperty.key("hoodie.datasource.write.streaming.disable.compaction").defaultValue("false").markAdvanced().sinceVersion("0.14.0").withDocumentation("By default for MOR table, async compaction is enabled with spark streaming sink. By setting this config to true, we can disable it and the expectation is that, users will schedule and execute compaction in a different process/job altogether. Some users may wish to run it separately to manage resources across table services and regular ingestion pipeline and so this could be preferred on such cases.");
    private static final ConfigProperty<String> META_SYNC_CLIENT_TOOL_CLASS_NAME = ConfigProperty.key("hoodie.meta.sync.client.tool.class").defaultValue(HiveSyncTool.class.getName()).markAdvanced().withDocumentation("Sync tool class name used to sync to metastore. Defaults to Hive.");
    @Deprecated
    private static final ConfigProperty<Boolean> RECONCILE_SCHEMA = HoodieCommonConfig.RECONCILE_SCHEMA;
    private static final ConfigProperty<String> SET_NULL_FOR_MISSING_COLUMNS = HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS;
    private static final ConfigProperty<String> SPARK_SQL_INSERT_INTO_OPERATION = ConfigProperty.key("hoodie.spark.sql.insert.into.operation").defaultValue(WriteOperationType.INSERT.value()).withValidValues(WriteOperationType.BULK_INSERT.value(), WriteOperationType.INSERT.value(), WriteOperationType.UPSERT.value()).markAdvanced().sinceVersion("0.14.0").withDocumentation("Sql write operation to use with INSERT_INTO spark sql command. This comes with 3 possible values, bulk_insert, insert and upsert. bulk_insert is generally meant for initial loads and is known to be performant compared to insert. But bulk_insert may not do small file management. If you prefer hudi to automatically manage small files, then you can go with \"insert\". There is no precombine (if there are duplicates within the same batch being ingested, same dups will be ingested) with bulk_insert and insert and there is no index look up as well. If you may use INSERT_INTO for mutable dataset, then you may have to set this config value to \"upsert\". With upsert, you will get both precombine and updates to existing records on storage is also honored. If not, you may see duplicates. ");
    private static final ConfigProperty<Object> ENABLE_MERGE_INTO_PARTIAL_UPDATES = ConfigProperty.key("hoodie.spark.sql.merge.into.partial.updates").defaultValue(BoxesRunTime.boxToBoolean((boolean)true)).markAdvanced().sinceVersion("1.0.0").withDocumentation("Whether to write partial updates to the data blocks containing updates in MOR tables with Spark SQL MERGE INTO statement. The data blocks containing partial updates have a schema with a subset of fields compared to the full schema of the table.");
    private static final String NONE_INSERT_DUP_POLICY = "none";
    private static final String DROP_INSERT_DUP_POLICY = "drop";
    private static final String FAIL_INSERT_DUP_POLICY = "fail";
    private static final ConfigProperty<String> INSERT_DUP_POLICY = ConfigProperty.key("hoodie.datasource.insert.dup.policy").defaultValue(MODULE$.NONE_INSERT_DUP_POLICY()).withValidValues(MODULE$.NONE_INSERT_DUP_POLICY(), MODULE$.DROP_INSERT_DUP_POLICY(), MODULE$.FAIL_INSERT_DUP_POLICY()).markAdvanced().sinceVersion("0.14.0").withDocumentation("**Note** This is only applicable to Spark SQL writing.<br />When operation type is set to \"insert\", users can optionally enforce a dedup policy. This policy will be employed  when records being ingested already exists in storage. Default policy is none and no action will be taken. Another option is to choose  \"drop\", on which matching records from incoming will be dropped and the rest will be ingested. Third option is \"fail\" which will fail the write operation when same records are re-ingested. In other words, a given record as deduced by the key generation policy can be ingested only once to the target table of interest.");
    @Deprecated
    private static final ConfigProperty<String> HIVE_SYNC_ENABLED = HiveSyncConfigHolder.HIVE_SYNC_ENABLED;
    @Deprecated
    private static final ConfigProperty<String> META_SYNC_ENABLED = HoodieSyncConfig.META_SYNC_ENABLED;
    @Deprecated
    private static final ConfigProperty<String> HIVE_DATABASE = HoodieSyncConfig.META_SYNC_DATABASE_NAME;
    @Deprecated
    private static final ConfigProperty<String> HIVE_TABLE = HoodieSyncConfig.META_SYNC_TABLE_NAME;
    @Deprecated
    private static final ConfigProperty<String> HIVE_BASE_FILE_FORMAT = HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT;
    @Deprecated
    private static final ConfigProperty<String> HIVE_USER = HiveSyncConfigHolder.HIVE_USER;
    @Deprecated
    private static final ConfigProperty<String> HIVE_PASS = HiveSyncConfigHolder.HIVE_PASS;
    @Deprecated
    private static final ConfigProperty<String> HIVE_URL = HiveSyncConfigHolder.HIVE_URL;
    @Deprecated
    private static final ConfigProperty<String> METASTORE_URIS = HiveSyncConfigHolder.METASTORE_URIS;
    @Deprecated
    private static final ConfigProperty<String> HIVE_PARTITION_FIELDS = HoodieSyncConfig.META_SYNC_PARTITION_FIELDS;
    @Deprecated
    private static final ConfigProperty<String> HIVE_PARTITION_EXTRACTOR_CLASS = HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS;
    @Deprecated
    private static final ConfigProperty<String> HIVE_USE_PRE_APACHE_INPUT_FORMAT = HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT;
    @Deprecated
    private static final ConfigProperty<String> HIVE_USE_JDBC = HiveSyncConfigHolder.HIVE_USE_JDBC;
    @Deprecated
    private static final ConfigProperty<String> HIVE_AUTO_CREATE_DATABASE = HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE;
    @Deprecated
    private static final ConfigProperty<String> HIVE_IGNORE_EXCEPTIONS = HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS;
    @Deprecated
    private static final ConfigProperty<String> HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE = HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE;
    @Deprecated
    private static final ConfigProperty<String> HIVE_SUPPORT_TIMESTAMP_TYPE = HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE;
    @Deprecated
    private static final ConfigProperty<String> HIVE_CONDITIONAL_SYNC = HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC;
    @Deprecated
    private static final ConfigProperty<String> HIVE_TABLE_PROPERTIES = HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES;
    @Deprecated
    private static final ConfigProperty<String> HIVE_TABLE_SERDE_PROPERTIES = HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES;
    @Deprecated
    private static final ConfigProperty<String> HIVE_SYNC_AS_DATA_SOURCE_TABLE = HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE;
    @Deprecated
    private static final ConfigProperty<Boolean> HIVE_CREATE_MANAGED_TABLE = HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE;
    @Deprecated
    private static final ConfigProperty<Integer> HIVE_BATCH_SYNC_PARTITION_NUM = HiveSyncConfigHolder.HIVE_BATCH_SYNC_PARTITION_NUM;
    @Deprecated
    private static final ConfigProperty<String> HIVE_SYNC_MODE = HiveSyncConfigHolder.HIVE_SYNC_MODE;
    @Deprecated
    private static final ConfigProperty<Boolean> HIVE_SYNC_BUCKET_SYNC = HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC;
    @Deprecated
    private static final ConfigProperty<String> HIVE_SYNC_COMMENT = HiveSyncConfigHolder.HIVE_SYNC_COMMENT;
    private static final ConfigProperty<String> ASYNC_COMPACT_ENABLE = ConfigProperty.key("hoodie.datasource.compaction.async.enable").defaultValue("true").markAdvanced().withDocumentation("Controls whether async compaction should be turned on for MOR table writing.");
    private static final ConfigProperty<String> INLINE_CLUSTERING_ENABLE = HoodieClusteringConfig.INLINE_CLUSTERING;
    private static final ConfigProperty<String> ASYNC_CLUSTERING_ENABLE = HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE;
    private static final ConfigProperty<String> KAFKA_AVRO_VALUE_DESERIALIZER_CLASS = ConfigProperty.key("hoodie.streamer.source.kafka.value.deserializer.class").defaultValue("io.confluent.kafka.serializers.KafkaAvroDeserializer").withAlternatives("hoodie.deltastreamer.source.kafka.value.deserializer.class").markAdvanced().sinceVersion("0.9.0").withDocumentation("This class is used by kafka client to deserialize the records");
    private static final ConfigProperty<Boolean> DROP_PARTITION_COLUMNS = HoodieTableConfig.DROP_PARTITION_COLUMNS;
    private static final ConfigProperty<String> SPARK_SQL_OPTIMIZED_WRITES = ConfigProperty.key("hoodie.spark.sql.optimized.writes.enable").defaultValue("true").markAdvanced().sinceVersion("0.14.0").withDocumentation("Controls whether spark sql prepped update, delete, and merge are enabled.");
    private static final ConfigProperty<String> OVERWRITE_MODE = ConfigProperty.key("hoodie.datasource.overwrite.mode").noDefaultValue().withValidValues("STATIC", "DYNAMIC").markAdvanced().sinceVersion("0.14.0").withDocumentation("Controls whether overwrite use dynamic or static mode, if not configured, respect spark.sql.sources.partitionOverwriteMode");
    @Deprecated
    private static final String HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY = HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key();
    @Deprecated
    private static final String HIVE_USE_JDBC_OPT_KEY = HiveSyncConfigHolder.HIVE_USE_JDBC.key();
    @Deprecated
    private static final String HIVE_AUTO_CREATE_DATABASE_OPT_KEY = HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key();
    @Deprecated
    private static final String HIVE_IGNORE_EXCEPTIONS_OPT_KEY = HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS.key();
    @Deprecated
    private static final String STREAMING_IGNORE_FAILED_BATCH_OPT_KEY = MODULE$.STREAMING_IGNORE_FAILED_BATCH().key();
    @Deprecated
    private static final String DEFAULT_STREAMING_IGNORE_FAILED_BATCH_OPT_VAL = MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue();
    @Deprecated
    private static final String META_SYNC_CLIENT_TOOL_CLASS = MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME().key();
    @Deprecated
    private static final String DEFAULT_META_SYNC_CLIENT_TOOL_CLASS = MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME().defaultValue();
    @Deprecated
    private static final String HIVE_SYNC_ENABLED_OPT_KEY = HiveSyncConfigHolder.HIVE_SYNC_ENABLED.key();
    @Deprecated
    private static final String META_SYNC_ENABLED_OPT_KEY = HoodieSyncConfig.META_SYNC_ENABLED.key();
    @Deprecated
    private static final String HIVE_DATABASE_OPT_KEY = HoodieSyncConfig.META_SYNC_DATABASE_NAME.key();
    @Deprecated
    private static final String HIVE_TABLE_OPT_KEY = HoodieSyncConfig.META_SYNC_TABLE_NAME.key();
    @Deprecated
    private static final String HIVE_BASE_FILE_FORMAT_OPT_KEY = HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key();
    @Deprecated
    private static final String HIVE_USER_OPT_KEY = HiveSyncConfigHolder.HIVE_USER.key();
    @Deprecated
    private static final String HIVE_PASS_OPT_KEY = HiveSyncConfigHolder.HIVE_PASS.key();
    @Deprecated
    private static final String HIVE_URL_OPT_KEY = HiveSyncConfigHolder.HIVE_URL.key();
    @Deprecated
    private static final String HIVE_PARTITION_FIELDS_OPT_KEY = HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key();
    @Deprecated
    private static final String HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY = HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key();
    @Deprecated
    private static final String DEFAULT_KEYGENERATOR_CLASS_OPT_VAL = MODULE$.KEYGENERATOR_CLASS_NAME().defaultValue();
    @Deprecated
    private static final String KEYGENERATOR_CLASS_OPT_KEY = HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key();
    @Deprecated
    private static final String ENABLE_ROW_WRITER_OPT_KEY = MODULE$.ENABLE_ROW_WRITER().key();
    @Deprecated
    private static final String DEFAULT_ENABLE_ROW_WRITER_OPT_VAL = MODULE$.ENABLE_ROW_WRITER().defaultValue();
    @Deprecated
    private static final String HIVE_STYLE_PARTITIONING_OPT_KEY = KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key();
    @Deprecated
    private static final String DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL = MODULE$.HIVE_STYLE_PARTITIONING().defaultValue();
    private static final ConfigProperty<String> URL_ENCODE_PARTITIONING = KeyGeneratorOptions.URL_ENCODE_PARTITIONING;
    @Deprecated
    private static final String URL_ENCODE_PARTITIONING_OPT_KEY = KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key();
    @Deprecated
    private static final String DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL = MODULE$.URL_ENCODE_PARTITIONING().defaultValue();
    @Deprecated
    private static final String COMMIT_METADATA_KEYPREFIX_OPT_KEY = MODULE$.COMMIT_METADATA_KEYPREFIX().key();
    @Deprecated
    private static final String DEFAULT_COMMIT_METADATA_KEYPREFIX_OPT_VAL = MODULE$.COMMIT_METADATA_KEYPREFIX().defaultValue();
    @Deprecated
    private static final String INSERT_DROP_DUPS_OPT_KEY = MODULE$.INSERT_DROP_DUPS().key();
    @Deprecated
    private static final String DEFAULT_INSERT_DROP_DUPS_OPT_VAL = MODULE$.INSERT_DROP_DUPS().defaultValue();
    @Deprecated
    private static final String STREAMING_RETRY_CNT_OPT_KEY = MODULE$.STREAMING_RETRY_CNT().key();
    @Deprecated
    private static final String DEFAULT_STREAMING_RETRY_CNT_OPT_VAL = MODULE$.STREAMING_RETRY_CNT().defaultValue();
    @Deprecated
    private static final String STREAMING_RETRY_INTERVAL_MS_OPT_KEY = MODULE$.STREAMING_RETRY_INTERVAL_MS().key();
    @Deprecated
    private static final String DEFAULT_STREAMING_RETRY_INTERVAL_MS_OPT_VAL = MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue();
    @Deprecated
    private static final String RECORDKEY_FIELD_OPT_KEY = KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key();
    @Deprecated
    private static final String PARTITIONPATH_FIELD_OPT_KEY = KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key();
    @Deprecated
    private static final Null$ DEFAULT_PARTITIONPATH_FIELD_OPT_VAL = null;
    @Deprecated
    private static final String TABLE_NAME_OPT_KEY = MODULE$.TABLE_NAME().key();
    @Deprecated
    private static final String PRECOMBINE_FIELD_OPT_KEY = HoodieWriteConfig.PRECOMBINE_FIELD_NAME.key();
    @Deprecated
    private static final String DEFAULT_PRECOMBINE_FIELD_OPT_VAL = MODULE$.PRECOMBINE_FIELD().defaultValue();
    @Deprecated
    private static final String PAYLOAD_CLASS_OPT_KEY = HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key();
    @Deprecated
    private static final String TABLE_TYPE_OPT_KEY = MODULE$.TABLE_TYPE().key();
    @Deprecated
    private static final String DEFAULT_TABLE_TYPE_OPT_VAL = MODULE$.TABLE_TYPE().defaultValue();
    @Deprecated
    private static final String STORAGE_TYPE_OPT_KEY = "hoodie.datasource.write.storage.type";
    @Deprecated
    private static final String COW_STORAGE_TYPE_OPT_VAL = HoodieTableType.COPY_ON_WRITE.name();
    @Deprecated
    private static final String MOR_STORAGE_TYPE_OPT_VAL = HoodieTableType.MERGE_ON_READ.name();
    @Deprecated
    private static final String DEFAULT_STORAGE_TYPE_OPT_VAL = MODULE$.COW_STORAGE_TYPE_OPT_VAL();
    @Deprecated
    private static final String OPERATION_OPT_KEY = MODULE$.OPERATION().key();
    @Deprecated
    private static final String DEFAULT_OPERATION_OPT_VAL = MODULE$.OPERATION().defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_SYNC_ENABLED_OPT_VAL = HiveSyncConfigHolder.HIVE_SYNC_ENABLED.defaultValue();
    @Deprecated
    private static final String DEFAULT_META_SYNC_ENABLED_OPT_VAL = HoodieSyncConfig.META_SYNC_ENABLED.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_DATABASE_OPT_VAL = HoodieSyncConfig.META_SYNC_DATABASE_NAME.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_TABLE_OPT_VAL = HoodieSyncConfig.META_SYNC_TABLE_NAME.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_BASE_FILE_FORMAT_OPT_VAL = HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_USER_OPT_VAL = HiveSyncConfigHolder.HIVE_USER.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_PASS_OPT_VAL = HiveSyncConfigHolder.HIVE_PASS.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_URL_OPT_VAL = HiveSyncConfigHolder.HIVE_URL.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_PARTITION_FIELDS_OPT_VAL = HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_PARTITION_EXTRACTOR_CLASS_OPT_VAL = HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.defaultValue();
    @Deprecated
    private static final String DEFAULT_USE_PRE_APACHE_INPUT_FORMAT_OPT_VAL = "false";
    @Deprecated
    private static final String DEFAULT_HIVE_USE_JDBC_OPT_VAL = HiveSyncConfigHolder.HIVE_USE_JDBC.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_AUTO_CREATE_DATABASE_OPT_KEY = HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.defaultValue();
    @Deprecated
    private static final String DEFAULT_HIVE_IGNORE_EXCEPTIONS_OPT_KEY = HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS.defaultValue();
    @Deprecated
    private static final String HIVE_SKIP_RO_SUFFIX = HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE.key();
    @Deprecated
    private static final String DEFAULT_HIVE_SKIP_RO_SUFFIX_VAL = HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE.defaultValue();
    @Deprecated
    private static final String HIVE_SUPPORT_TIMESTAMP = HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE.key();
    @Deprecated
    private static final String DEFAULT_HIVE_SUPPORT_TIMESTAMP = HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE.defaultValue();
    @Deprecated
    private static final String ASYNC_COMPACT_ENABLE_OPT_KEY = MODULE$.ASYNC_COMPACT_ENABLE().key();
    @Deprecated
    private static final String DEFAULT_ASYNC_COMPACT_ENABLE_OPT_VAL = MODULE$.ASYNC_COMPACT_ENABLE().defaultValue();
    @Deprecated
    private static final String KAFKA_AVRO_VALUE_DESERIALIZER = MODULE$.KAFKA_AVRO_VALUE_DESERIALIZER_CLASS().key();
    @Deprecated
    private static final String SCHEMA_PROVIDER_CLASS_PROP = "hoodie.streamer.schemaprovider.class";

    public String BULK_INSERT_OPERATION_OPT_VAL() {
        return BULK_INSERT_OPERATION_OPT_VAL;
    }

    public String INSERT_OPERATION_OPT_VAL() {
        return INSERT_OPERATION_OPT_VAL;
    }

    public String UPSERT_OPERATION_OPT_VAL() {
        return UPSERT_OPERATION_OPT_VAL;
    }

    public String DELETE_OPERATION_OPT_VAL() {
        return DELETE_OPERATION_OPT_VAL;
    }

    public String DELETE_PARTITION_OPERATION_OPT_VAL() {
        return DELETE_PARTITION_OPERATION_OPT_VAL;
    }

    public String BOOTSTRAP_OPERATION_OPT_VAL() {
        return BOOTSTRAP_OPERATION_OPT_VAL;
    }

    public String INSERT_OVERWRITE_OPERATION_OPT_VAL() {
        return INSERT_OVERWRITE_OPERATION_OPT_VAL;
    }

    public String INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL() {
        return INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL;
    }

    public ConfigProperty<String> OPERATION() {
        return OPERATION;
    }

    public String COW_TABLE_TYPE_OPT_VAL() {
        return COW_TABLE_TYPE_OPT_VAL;
    }

    public String MOR_TABLE_TYPE_OPT_VAL() {
        return MOR_TABLE_TYPE_OPT_VAL;
    }

    public ConfigProperty<String> TABLE_TYPE() {
        return TABLE_TYPE;
    }

    public String SPARK_SQL_WRITES_PREPPED_KEY() {
        return SPARK_SQL_WRITES_PREPPED_KEY;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> mayBeDerivePartitionPath(Map<String, String> optParams) {
        void var2_2;
        block2: {
            String string;
            String keyGeneratorClass;
            Seq partitionColumns;
            Map translatedOptParams;
            block3: {
                translatedOptParams = optParams;
                if (!optParams.contains((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()) || optParams.contains((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key())) break block2;
                partitionColumns = (Seq)optParams.get((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()).map((Function1 & Serializable)str -> DataSourceUtils$.MODULE$.decodePartitioningColumns(str)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
                keyGeneratorClass = (String)optParams.getOrElse((Object)this.KEYGENERATOR_CLASS_NAME().key(), (Function0 & Serializable)() -> MODULE$.KEYGENERATOR_CLASS_NAME().defaultValue());
                string = keyGeneratorClass;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string))) break block3;
                String string2 = string;
                String string3 = CustomKeyGenerator.class.getName();
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                String partitionPathField = ((IterableOnceOps)partitionColumns.map((Function1 & Serializable)e -> e.contains(":") ? e : new StringBuilder(7).append((String)e).append(":SIMPLE").toString())).mkString(",");
                translatedOptParams = (Map)optParams.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARTITIONPATH_FIELD().key()), (Object)partitionPathField)})));
                break block2;
            }
            if (!string.isEmpty() && keyGeneratorClass.equals(NonpartitionedKeyGenerator.class.getName())) break block2;
            String partitionPathField = partitionColumns.mkString(",");
            translatedOptParams = (Map)optParams.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARTITIONPATH_FIELD().key()), (Object)partitionPathField)})));
        }
        return var2_2;
    }

    public ConfigProperty<String> TABLE_NAME() {
        return TABLE_NAME;
    }

    public ConfigProperty<String> PRECOMBINE_FIELD() {
        return PRECOMBINE_FIELD;
    }

    public ConfigProperty<String> PAYLOAD_CLASS_NAME() {
        return PAYLOAD_CLASS_NAME;
    }

    public ConfigProperty<String> RECORD_MERGE_IMPL_CLASSES() {
        return RECORD_MERGE_IMPL_CLASSES;
    }

    public ConfigProperty<String> RECORD_MERGE_STRATEGY_ID() {
        return RECORD_MERGE_STRATEGY_ID;
    }

    public ConfigProperty<String> RECORD_MERGE_MODE() {
        return RECORD_MERGE_MODE;
    }

    public ConfigProperty<String> RECORDKEY_FIELD() {
        return RECORDKEY_FIELD;
    }

    public ConfigProperty<String> SECONDARYKEY_COLUMN_NAME() {
        return SECONDARYKEY_COLUMN_NAME;
    }

    public ConfigProperty<String> PARTITIONPATH_FIELD() {
        return PARTITIONPATH_FIELD;
    }

    public ConfigProperty<String> HIVE_STYLE_PARTITIONING() {
        return HIVE_STYLE_PARTITIONING;
    }

    public Function<HoodieConfig, Option<String>> keyGeneratorInferFunc() {
        return keyGeneratorInferFunc;
    }

    public ConfigProperty<String> KEYGENERATOR_CLASS_NAME() {
        return KEYGENERATOR_CLASS_NAME;
    }

    public ConfigProperty<String> KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED() {
        return KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED;
    }

    public ConfigProperty<String> ENABLE_ROW_WRITER() {
        return ENABLE_ROW_WRITER;
    }

    public ConfigProperty<String> SQL_ENABLE_BULK_INSERT() {
        return SQL_ENABLE_BULK_INSERT;
    }

    public ConfigProperty<String> SQL_INSERT_MODE() {
        return SQL_INSERT_MODE;
    }

    public ConfigProperty<String> COMMIT_METADATA_KEYPREFIX() {
        return COMMIT_METADATA_KEYPREFIX;
    }

    public ConfigProperty<String> INSERT_DROP_DUPS() {
        return INSERT_DROP_DUPS;
    }

    public ConfigProperty<String> PARTITIONS_TO_DELETE() {
        return PARTITIONS_TO_DELETE;
    }

    public ConfigProperty<String> STREAMING_RETRY_CNT() {
        return STREAMING_RETRY_CNT;
    }

    public ConfigProperty<String> STREAMING_RETRY_INTERVAL_MS() {
        return STREAMING_RETRY_INTERVAL_MS;
    }

    public ConfigProperty<String> STREAMING_IGNORE_FAILED_BATCH() {
        return STREAMING_IGNORE_FAILED_BATCH;
    }

    public ConfigProperty<String> STREAMING_CHECKPOINT_IDENTIFIER() {
        return STREAMING_CHECKPOINT_IDENTIFIER;
    }

    public ConfigProperty<String> STREAMING_DISABLE_COMPACTION() {
        return STREAMING_DISABLE_COMPACTION;
    }

    public ConfigProperty<String> META_SYNC_CLIENT_TOOL_CLASS_NAME() {
        return META_SYNC_CLIENT_TOOL_CLASS_NAME;
    }

    public ConfigProperty<Boolean> RECONCILE_SCHEMA() {
        return RECONCILE_SCHEMA;
    }

    public ConfigProperty<String> SET_NULL_FOR_MISSING_COLUMNS() {
        return SET_NULL_FOR_MISSING_COLUMNS;
    }

    public ConfigProperty<String> SPARK_SQL_INSERT_INTO_OPERATION() {
        return SPARK_SQL_INSERT_INTO_OPERATION;
    }

    public ConfigProperty<Object> ENABLE_MERGE_INTO_PARTIAL_UPDATES() {
        return ENABLE_MERGE_INTO_PARTIAL_UPDATES;
    }

    public String NONE_INSERT_DUP_POLICY() {
        return NONE_INSERT_DUP_POLICY;
    }

    public String DROP_INSERT_DUP_POLICY() {
        return DROP_INSERT_DUP_POLICY;
    }

    public String FAIL_INSERT_DUP_POLICY() {
        return FAIL_INSERT_DUP_POLICY;
    }

    public ConfigProperty<String> INSERT_DUP_POLICY() {
        return INSERT_DUP_POLICY;
    }

    public ConfigProperty<String> HIVE_SYNC_ENABLED() {
        return HIVE_SYNC_ENABLED;
    }

    public ConfigProperty<String> META_SYNC_ENABLED() {
        return META_SYNC_ENABLED;
    }

    public ConfigProperty<String> HIVE_DATABASE() {
        return HIVE_DATABASE;
    }

    public ConfigProperty<String> HIVE_TABLE() {
        return HIVE_TABLE;
    }

    public ConfigProperty<String> HIVE_BASE_FILE_FORMAT() {
        return HIVE_BASE_FILE_FORMAT;
    }

    public ConfigProperty<String> HIVE_USER() {
        return HIVE_USER;
    }

    public ConfigProperty<String> HIVE_PASS() {
        return HIVE_PASS;
    }

    public ConfigProperty<String> HIVE_URL() {
        return HIVE_URL;
    }

    public ConfigProperty<String> METASTORE_URIS() {
        return METASTORE_URIS;
    }

    public ConfigProperty<String> HIVE_PARTITION_FIELDS() {
        return HIVE_PARTITION_FIELDS;
    }

    public ConfigProperty<String> HIVE_PARTITION_EXTRACTOR_CLASS() {
        return HIVE_PARTITION_EXTRACTOR_CLASS;
    }

    public ConfigProperty<String> HIVE_USE_PRE_APACHE_INPUT_FORMAT() {
        return HIVE_USE_PRE_APACHE_INPUT_FORMAT;
    }

    public ConfigProperty<String> HIVE_USE_JDBC() {
        return HIVE_USE_JDBC;
    }

    public ConfigProperty<String> HIVE_AUTO_CREATE_DATABASE() {
        return HIVE_AUTO_CREATE_DATABASE;
    }

    public ConfigProperty<String> HIVE_IGNORE_EXCEPTIONS() {
        return HIVE_IGNORE_EXCEPTIONS;
    }

    public ConfigProperty<String> HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE() {
        return HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE;
    }

    public ConfigProperty<String> HIVE_SUPPORT_TIMESTAMP_TYPE() {
        return HIVE_SUPPORT_TIMESTAMP_TYPE;
    }

    public ConfigProperty<String> HIVE_CONDITIONAL_SYNC() {
        return HIVE_CONDITIONAL_SYNC;
    }

    public ConfigProperty<String> HIVE_TABLE_PROPERTIES() {
        return HIVE_TABLE_PROPERTIES;
    }

    public ConfigProperty<String> HIVE_TABLE_SERDE_PROPERTIES() {
        return HIVE_TABLE_SERDE_PROPERTIES;
    }

    public ConfigProperty<String> HIVE_SYNC_AS_DATA_SOURCE_TABLE() {
        return HIVE_SYNC_AS_DATA_SOURCE_TABLE;
    }

    public ConfigProperty<Boolean> HIVE_CREATE_MANAGED_TABLE() {
        return HIVE_CREATE_MANAGED_TABLE;
    }

    public ConfigProperty<Integer> HIVE_BATCH_SYNC_PARTITION_NUM() {
        return HIVE_BATCH_SYNC_PARTITION_NUM;
    }

    public ConfigProperty<String> HIVE_SYNC_MODE() {
        return HIVE_SYNC_MODE;
    }

    public ConfigProperty<Boolean> HIVE_SYNC_BUCKET_SYNC() {
        return HIVE_SYNC_BUCKET_SYNC;
    }

    public ConfigProperty<String> HIVE_SYNC_COMMENT() {
        return HIVE_SYNC_COMMENT;
    }

    public ConfigProperty<String> ASYNC_COMPACT_ENABLE() {
        return ASYNC_COMPACT_ENABLE;
    }

    public ConfigProperty<String> INLINE_CLUSTERING_ENABLE() {
        return INLINE_CLUSTERING_ENABLE;
    }

    public ConfigProperty<String> ASYNC_CLUSTERING_ENABLE() {
        return ASYNC_CLUSTERING_ENABLE;
    }

    public ConfigProperty<String> KAFKA_AVRO_VALUE_DESERIALIZER_CLASS() {
        return KAFKA_AVRO_VALUE_DESERIALIZER_CLASS;
    }

    public ConfigProperty<Boolean> DROP_PARTITION_COLUMNS() {
        return DROP_PARTITION_COLUMNS;
    }

    public ConfigProperty<String> SPARK_SQL_OPTIMIZED_WRITES() {
        return SPARK_SQL_OPTIMIZED_WRITES;
    }

    public ConfigProperty<String> OVERWRITE_MODE() {
        return OVERWRITE_MODE;
    }

    public String HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY() {
        return HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY;
    }

    public String HIVE_USE_JDBC_OPT_KEY() {
        return HIVE_USE_JDBC_OPT_KEY;
    }

    public String HIVE_AUTO_CREATE_DATABASE_OPT_KEY() {
        return HIVE_AUTO_CREATE_DATABASE_OPT_KEY;
    }

    public String HIVE_IGNORE_EXCEPTIONS_OPT_KEY() {
        return HIVE_IGNORE_EXCEPTIONS_OPT_KEY;
    }

    public String STREAMING_IGNORE_FAILED_BATCH_OPT_KEY() {
        return STREAMING_IGNORE_FAILED_BATCH_OPT_KEY;
    }

    public String DEFAULT_STREAMING_IGNORE_FAILED_BATCH_OPT_VAL() {
        return DEFAULT_STREAMING_IGNORE_FAILED_BATCH_OPT_VAL;
    }

    public String META_SYNC_CLIENT_TOOL_CLASS() {
        return META_SYNC_CLIENT_TOOL_CLASS;
    }

    public String DEFAULT_META_SYNC_CLIENT_TOOL_CLASS() {
        return DEFAULT_META_SYNC_CLIENT_TOOL_CLASS;
    }

    public String HIVE_SYNC_ENABLED_OPT_KEY() {
        return HIVE_SYNC_ENABLED_OPT_KEY;
    }

    public String META_SYNC_ENABLED_OPT_KEY() {
        return META_SYNC_ENABLED_OPT_KEY;
    }

    public String HIVE_DATABASE_OPT_KEY() {
        return HIVE_DATABASE_OPT_KEY;
    }

    public String HIVE_TABLE_OPT_KEY() {
        return HIVE_TABLE_OPT_KEY;
    }

    public String HIVE_BASE_FILE_FORMAT_OPT_KEY() {
        return HIVE_BASE_FILE_FORMAT_OPT_KEY;
    }

    public String HIVE_USER_OPT_KEY() {
        return HIVE_USER_OPT_KEY;
    }

    public String HIVE_PASS_OPT_KEY() {
        return HIVE_PASS_OPT_KEY;
    }

    public String HIVE_URL_OPT_KEY() {
        return HIVE_URL_OPT_KEY;
    }

    public String HIVE_PARTITION_FIELDS_OPT_KEY() {
        return HIVE_PARTITION_FIELDS_OPT_KEY;
    }

    public String HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY() {
        return HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY;
    }

    public String DEFAULT_KEYGENERATOR_CLASS_OPT_VAL() {
        return DEFAULT_KEYGENERATOR_CLASS_OPT_VAL;
    }

    public String KEYGENERATOR_CLASS_OPT_KEY() {
        return KEYGENERATOR_CLASS_OPT_KEY;
    }

    public String ENABLE_ROW_WRITER_OPT_KEY() {
        return ENABLE_ROW_WRITER_OPT_KEY;
    }

    public String DEFAULT_ENABLE_ROW_WRITER_OPT_VAL() {
        return DEFAULT_ENABLE_ROW_WRITER_OPT_VAL;
    }

    public String HIVE_STYLE_PARTITIONING_OPT_KEY() {
        return HIVE_STYLE_PARTITIONING_OPT_KEY;
    }

    public String DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL() {
        return DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL;
    }

    public ConfigProperty<String> URL_ENCODE_PARTITIONING() {
        return URL_ENCODE_PARTITIONING;
    }

    public String URL_ENCODE_PARTITIONING_OPT_KEY() {
        return URL_ENCODE_PARTITIONING_OPT_KEY;
    }

    public String DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL() {
        return DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL;
    }

    public String COMMIT_METADATA_KEYPREFIX_OPT_KEY() {
        return COMMIT_METADATA_KEYPREFIX_OPT_KEY;
    }

    public String DEFAULT_COMMIT_METADATA_KEYPREFIX_OPT_VAL() {
        return DEFAULT_COMMIT_METADATA_KEYPREFIX_OPT_VAL;
    }

    public String INSERT_DROP_DUPS_OPT_KEY() {
        return INSERT_DROP_DUPS_OPT_KEY;
    }

    public String DEFAULT_INSERT_DROP_DUPS_OPT_VAL() {
        return DEFAULT_INSERT_DROP_DUPS_OPT_VAL;
    }

    public String STREAMING_RETRY_CNT_OPT_KEY() {
        return STREAMING_RETRY_CNT_OPT_KEY;
    }

    public String DEFAULT_STREAMING_RETRY_CNT_OPT_VAL() {
        return DEFAULT_STREAMING_RETRY_CNT_OPT_VAL;
    }

    public String STREAMING_RETRY_INTERVAL_MS_OPT_KEY() {
        return STREAMING_RETRY_INTERVAL_MS_OPT_KEY;
    }

    public String DEFAULT_STREAMING_RETRY_INTERVAL_MS_OPT_VAL() {
        return DEFAULT_STREAMING_RETRY_INTERVAL_MS_OPT_VAL;
    }

    public String RECORDKEY_FIELD_OPT_KEY() {
        return RECORDKEY_FIELD_OPT_KEY;
    }

    public String PARTITIONPATH_FIELD_OPT_KEY() {
        return PARTITIONPATH_FIELD_OPT_KEY;
    }

    public Null$ DEFAULT_PARTITIONPATH_FIELD_OPT_VAL() {
        return DEFAULT_PARTITIONPATH_FIELD_OPT_VAL;
    }

    public String TABLE_NAME_OPT_KEY() {
        return TABLE_NAME_OPT_KEY;
    }

    public String PRECOMBINE_FIELD_OPT_KEY() {
        return PRECOMBINE_FIELD_OPT_KEY;
    }

    public String DEFAULT_PRECOMBINE_FIELD_OPT_VAL() {
        return DEFAULT_PRECOMBINE_FIELD_OPT_VAL;
    }

    public String PAYLOAD_CLASS_OPT_KEY() {
        return PAYLOAD_CLASS_OPT_KEY;
    }

    public String TABLE_TYPE_OPT_KEY() {
        return TABLE_TYPE_OPT_KEY;
    }

    public String DEFAULT_TABLE_TYPE_OPT_VAL() {
        return DEFAULT_TABLE_TYPE_OPT_VAL;
    }

    public String STORAGE_TYPE_OPT_KEY() {
        return STORAGE_TYPE_OPT_KEY;
    }

    public String COW_STORAGE_TYPE_OPT_VAL() {
        return COW_STORAGE_TYPE_OPT_VAL;
    }

    public String MOR_STORAGE_TYPE_OPT_VAL() {
        return MOR_STORAGE_TYPE_OPT_VAL;
    }

    public String DEFAULT_STORAGE_TYPE_OPT_VAL() {
        return DEFAULT_STORAGE_TYPE_OPT_VAL;
    }

    public String OPERATION_OPT_KEY() {
        return OPERATION_OPT_KEY;
    }

    public String DEFAULT_OPERATION_OPT_VAL() {
        return DEFAULT_OPERATION_OPT_VAL;
    }

    public String DEFAULT_HIVE_SYNC_ENABLED_OPT_VAL() {
        return DEFAULT_HIVE_SYNC_ENABLED_OPT_VAL;
    }

    public String DEFAULT_META_SYNC_ENABLED_OPT_VAL() {
        return DEFAULT_META_SYNC_ENABLED_OPT_VAL;
    }

    public String DEFAULT_HIVE_DATABASE_OPT_VAL() {
        return DEFAULT_HIVE_DATABASE_OPT_VAL;
    }

    public String DEFAULT_HIVE_TABLE_OPT_VAL() {
        return DEFAULT_HIVE_TABLE_OPT_VAL;
    }

    public String DEFAULT_HIVE_BASE_FILE_FORMAT_OPT_VAL() {
        return DEFAULT_HIVE_BASE_FILE_FORMAT_OPT_VAL;
    }

    public String DEFAULT_HIVE_USER_OPT_VAL() {
        return DEFAULT_HIVE_USER_OPT_VAL;
    }

    public String DEFAULT_HIVE_PASS_OPT_VAL() {
        return DEFAULT_HIVE_PASS_OPT_VAL;
    }

    public String DEFAULT_HIVE_URL_OPT_VAL() {
        return DEFAULT_HIVE_URL_OPT_VAL;
    }

    public String DEFAULT_HIVE_PARTITION_FIELDS_OPT_VAL() {
        return DEFAULT_HIVE_PARTITION_FIELDS_OPT_VAL;
    }

    public String DEFAULT_HIVE_PARTITION_EXTRACTOR_CLASS_OPT_VAL() {
        return DEFAULT_HIVE_PARTITION_EXTRACTOR_CLASS_OPT_VAL;
    }

    public String DEFAULT_USE_PRE_APACHE_INPUT_FORMAT_OPT_VAL() {
        return DEFAULT_USE_PRE_APACHE_INPUT_FORMAT_OPT_VAL;
    }

    public String DEFAULT_HIVE_USE_JDBC_OPT_VAL() {
        return DEFAULT_HIVE_USE_JDBC_OPT_VAL;
    }

    public String DEFAULT_HIVE_AUTO_CREATE_DATABASE_OPT_KEY() {
        return DEFAULT_HIVE_AUTO_CREATE_DATABASE_OPT_KEY;
    }

    public String DEFAULT_HIVE_IGNORE_EXCEPTIONS_OPT_KEY() {
        return DEFAULT_HIVE_IGNORE_EXCEPTIONS_OPT_KEY;
    }

    public String HIVE_SKIP_RO_SUFFIX() {
        return HIVE_SKIP_RO_SUFFIX;
    }

    public String DEFAULT_HIVE_SKIP_RO_SUFFIX_VAL() {
        return DEFAULT_HIVE_SKIP_RO_SUFFIX_VAL;
    }

    public String HIVE_SUPPORT_TIMESTAMP() {
        return HIVE_SUPPORT_TIMESTAMP;
    }

    public String DEFAULT_HIVE_SUPPORT_TIMESTAMP() {
        return DEFAULT_HIVE_SUPPORT_TIMESTAMP;
    }

    public String ASYNC_COMPACT_ENABLE_OPT_KEY() {
        return ASYNC_COMPACT_ENABLE_OPT_KEY;
    }

    public String DEFAULT_ASYNC_COMPACT_ENABLE_OPT_VAL() {
        return DEFAULT_ASYNC_COMPACT_ENABLE_OPT_VAL;
    }

    public String KAFKA_AVRO_VALUE_DESERIALIZER() {
        return KAFKA_AVRO_VALUE_DESERIALIZER;
    }

    public String SCHEMA_PROVIDER_CLASS_PROP() {
        return SCHEMA_PROVIDER_CLASS_PROP;
    }

    private DataSourceWriteOptions$() {
    }
}

