/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieSparkIOFactory;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.spark.SerializableWritable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieBaseRelation$
implements SparkAdapterSupport {
    public static final HoodieBaseRelation$ MODULE$ = new HoodieBaseRelation$();
    private static scala.collection.immutable.Set<String> org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    private static SparkAdapter sparkAdapter;
    private static volatile byte bitmap$0;

    static {
        SparkAdapterSupport.$init$(MODULE$);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : sparkAdapter;
    }

    private scala.collection.immutable.Set<String> metaFieldNames$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                org$apache$hudi$HoodieBaseRelation$$metaFieldNames = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    }

    public scala.collection.immutable.Set<String> org$apache$hudi$HoodieBaseRelation$$metaFieldNames() {
        return (byte)(bitmap$0 & 1) == 0 ? this.metaFieldNames$lzycompute() : org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    }

    public Schema convertToAvroSchema(StructType structSchema, String tableName) {
        Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String recordName = (String)tuple2._1();
        String namespace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)recordName, (Object)namespace);
        Tuple2 tuple23 = tuple22;
        String recordName2 = (String)tuple23._1();
        String namespace2 = (String)tuple23._2();
        Schema avroSchema = this.sparkAdapter().getAvroSchemaConverters().toAvroType((DataType)structSchema, false, recordName2, namespace2);
        return AvroConversionUtils$.MODULE$.getAvroSchemaWithDefaults(avroSchema, (DataType)structSchema);
    }

    public Path getPartitionPath(FileStatus fileStatus) {
        return fileStatus.getPath().getParent();
    }

    public HoodieBaseRelation.BaseFileReader projectReader(HoodieBaseRelation.BaseFileReader reader, StructType requiredSchema) {
        HoodieBaseRelation.BaseFileReader baseFileReader;
        ValidationUtils.checkState(Predef$.MODULE$.wrapRefArray((Object[])reader.schema().fields()).toSet().intersect((Set)Predef$.MODULE$.wrapRefArray((Object[])requiredSchema.fields()).toSet()).size() == requiredSchema.size());
        StructType structType = reader.schema();
        StructType structType2 = requiredSchema;
        if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
            baseFileReader = reader;
        } else {
            Function1 & Serializable read = (Function1 & Serializable)x$16 -> reader.apply((PartitionedFile)x$16);
            Function1 & Serializable projectedRead = (Function1 & Serializable)file -> {
                UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(reader.schema(), requiredSchema);
                return ((Iterator)read.apply(file)).map((Function1)unsafeProjection);
            };
            baseFileReader = new HoodieBaseRelation.BaseFileReader((Function1<PartitionedFile, Iterator<InternalRow>>)projectedRead, requiredSchema);
        }
        return baseFileReader;
    }

    public Tuple3<Schema, StructType, InternalSchema> projectSchema(Either<Schema, InternalSchema> tableSchema, String[] requiredColumns) {
        Tuple3 tuple3;
        Either<Schema, InternalSchema> either = tableSchema;
        if (either instanceof Right) {
            Right right = (Right)either;
            InternalSchema internalSchema = (InternalSchema)right.value();
            ValidationUtils.checkState(!internalSchema.isEmptySchema());
            InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema(internalSchema, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])requiredColumns).toList()).asJava());
            Schema requiredAvroSchema = AvroInternalSchemaConverter.convert(prunedInternalSchema, "schema");
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Schema avroSchema = (Schema)left.value();
            Map fieldMap = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            List requiredFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)col -> {
                Schema.Field f = (Schema.Field)fieldMap.apply(col);
                return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
            }, ClassTag$.MODULE$.apply(Schema.Field.class))).toList();
            Schema requiredAvroSchema = Schema.createRecord((String)avroSchema.getName(), (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)avroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)InternalSchema.getEmptyInternalSchema());
        } else {
            throw new MatchError(either);
        }
        return tuple3;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> org$apache$hudi$HoodieBaseRelation$$createHFileReader(SparkSession spark, HoodieTableSchema dataSchema, HoodieTableSchema requiredDataSchema, scala.collection.immutable.Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast hadoopConfBroadcast = spark.sparkContext().broadcast((Object)new SerializableWritable((Writable)hadoopConf), ClassTag$.MODULE$.apply(SerializableWritable.class));
        return (Function1 & Serializable)partitionedFile -> {
            Configuration hadoopConf = (Configuration)((SerializableWritable)hadoopConfBroadcast.value()).value();
            StoragePath filePath = MODULE$.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile((PartitionedFile)partitionedFile);
            HoodieConfig hoodieConfig = new HoodieConfig();
            hoodieConfig.setValue(HoodieReaderConfig.USE_NATIVE_HFILE_READER, (String)options.getOrElse((Object)HoodieReaderConfig.USE_NATIVE_HFILE_READER.key(), (Function0 & Serializable)() -> HoodieReaderConfig.USE_NATIVE_HFILE_READER.defaultValue().toString()));
            HoodieFileReader reader = new HoodieSparkIOFactory(new HoodieHadoopStorage(filePath, HadoopFSUtils.getStorageConf(hadoopConf))).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(hoodieConfig, filePath, HoodieFileFormat.HFILE);
            StructType requiredRowSchema = requiredDataSchema.structTypeSchema();
            Schema requiredAvroSchema = new Schema.Parser().parse(requiredDataSchema.avroSchemaStr());
            Function1<GenericRecord, Option<InternalRow>> avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(requiredAvroSchema, requiredRowSchema);
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(reader.getRecordIterator(requiredAvroSchema)).asScala()).map((Function1 & Serializable)record -> (InternalRow)((Option)avroToRowConverter.apply((Object)((GenericRecord)record.getData()))).get());
        };
    }

    public boolean isSchemaEvolutionEnabledOnRead(Map<String, String> optParams, SparkSession sparkSession) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)optParams.getOrElse((Object)DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), (Function0 & Serializable)() -> DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue().toString()))) || ProvidesHoodieConfig$.MODULE$.isSchemaEvolutionEnabled(sparkSession);
    }

    private HoodieBaseRelation$() {
    }
}

