/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StorageSchemes;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class HoodieCLIUtils$
implements Logging {
    public static final HoodieCLIUtils$ MODULE$ = new HoodieCLIUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkRDDWriteClient<?> createHoodieWriteClient(SparkSession sparkSession, String basePath, scala.collection.immutable.Map<String, String> conf, Option<String> tableName) {
        scala.collection.immutable.Map<String, String> map2;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf())).build();
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String schemaStr = schemaUtil.getTableAvroSchema(false).toString();
        Option<String> option = tableName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            map2 = HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs(this.getHoodieCatalogTable(sparkSession, value).catalogProperties());
        } else if (None$.MODULE$.equals(option)) {
            map2 = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<String, String> catalogProps = map2;
        scala.collection.immutable.Map<String, String> finalParameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)((IterableOnceOps)((IterableOps)((IterableOps)catalogProps.$plus$plus((IterableOnce)((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$plus$plus(HoodieSqlCommonUtils$.MODULE$.filterHoodieConfigs((scala.collection.immutable.Map<String, String>)sparkSession.sqlContext().getAllConfs()))).$plus$plus(conf)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        return DataSourceUtils.createHoodieClient(jsc, schemaStr, basePath, metaClient.getTableConfig().getTableName(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(finalParameters).asJava());
    }

    public String extractPartitions(Seq<HoodieClusteringGroup> clusteringGroups) {
        ObjectRef partitionPaths = ObjectRef.create((Object)((Seq)package$.MODULE$.Seq().empty()));
        clusteringGroups.foreach((Function1 & Serializable)g -> {
            HoodieCLIUtils$.$anonfun$extractPartitions$1(partitionPaths, g);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)((Seq)partitionPaths.elem).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public HoodieCatalogTable getHoodieCatalogTable(SparkSession sparkSession, String table) {
        SeqOps seqOps;
        HoodieCatalogTable hoodieCatalogTable;
        SeqOps seqOps2;
        IndexedSeq seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(table), '.'));
        IndexedSeq indexedSeq = seq;
        if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
            String tableName = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName));
        } else if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            String database = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String tableName = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName, (Option)new Some((Object)database)));
        } else {
            throw new SparkException(new StringBuilder(23).append("Unsupported identifier ").append(table).toString());
        }
        return hoodieCatalogTable;
    }

    public Tuple2<String, Option<String>> getTableIdentifier(String table) {
        SeqOps seqOps;
        Tuple2 tuple2;
        SeqOps seqOps2;
        String[] arrayStr = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(table), '.');
        Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])arrayStr));
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
            String tableName = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            tuple2 = new Tuple2((Object)tableName, (Object)None$.MODULE$);
        } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            String database = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String tableName = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            tuple2 = new Tuple2((Object)tableName, (Object)new Some((Object)database));
        } else {
            throw new SparkException(new StringBuilder(23).append("Unsupported identifier ").append(table).toString());
        }
        return tuple2;
    }

    public scala.collection.immutable.Map<String, String> extractOptions(String s) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(StringUtils.split(s, ",")).asScala()).map((Function1 & Serializable)split -> StringUtils.split(split, "="))).map((Function1 & Serializable)pair -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pair.get(0)), pair.get(1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, String> getLockOptions(String tablePath, String schema, TypedProperties lockConfig) {
        scala.collection.immutable.Map map2;
        List<String> customSupportedFSs = lockConfig.getStringList(HoodieCommonConfig.HOODIE_FS_ATOMIC_CREATION_SUPPORT.key(), ",", new ArrayList<String>());
        if (schema == null || customSupportedFSs.contains(schema) || StorageSchemes.isAtomicCreationSupported(schema)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Auto config filesystem lock provider for metadata table");
            TypedProperties props = FileSystemBasedLockProvider.getLockConfig(tablePath);
            map2 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(props.stringPropertyNames()).asScala()).map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)props.getString((String)key)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            map2 = Predef$.MODULE$.Map().empty();
        }
        return map2;
    }

    public static final /* synthetic */ void $anonfun$extractPartitions$1(ObjectRef partitionPaths$1, HoodieClusteringGroup g) {
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(g.getSlices()).asScala()).foreach((Function1 & Serializable)slice -> {
            partitionPaths$1.elem = (Seq)((Seq)partitionPaths$1.elem).$colon$plus((Object)slice.getPartitionPath());
            return BoxedUnit.UNIT;
        });
    }

    private HoodieCLIUtils$() {
    }
}

