/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieSchemaUtils$ {
    public static final HoodieSchemaUtils$ MODULE$ = new HoodieSchemaUtils$();
    private static final Logger log = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger log() {
        return log;
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        None$ none$;
        block5: {
            if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                none$ = None$.MODULE$;
            } else {
                try {
                    TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                    Option<InternalSchema> internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                    if (internalSchemaOpt.isPresent()) {
                        none$ = new Some((Object)internalSchemaOpt.get());
                        break block5;
                    }
                    none$ = None$.MODULE$;
                }
                catch (Exception exception) {
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        Schema schema;
        scala.Option<Schema> option = latestTableSchemaOpt;
        if (None$.MODULE$.equals(option)) {
            schema = AvroInternalSchemaConverter.fixNullOrdering(sourceSchema);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Schema latestTableSchemaWithMetaFields = (Schema)some.value();
            Schema latestTableSchema = AvroInternalSchemaConverter.fixNullOrdering(HoodieAvroUtils.removeMetadataFields(latestTableSchemaWithMetaFields));
            boolean shouldCanonicalizeSchema = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().key(), (Function0 & Serializable)() -> HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().defaultValue().toString())));
            boolean shouldReconcileSchema = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().defaultValue().toString())));
            Schema canonicalizedSourceSchema = shouldCanonicalizeSchema ? this.canonicalizeSchema(sourceSchema, latestTableSchema, opts, !shouldReconcileSchema) : AvroInternalSchemaConverter.fixNullOrdering(sourceSchema);
            schema = shouldReconcileSchema ? this.deduceWriterSchemaWithReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, internalSchemaOpt, opts) : this.deduceWriterSchemaWithoutReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, opts);
        } else {
            throw new MatchError(option);
        }
        return schema;
    }

    private Schema deduceWriterSchemaWithoutReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, Map<String, String> opts) {
        Schema schema;
        boolean mergeIntoWrites = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().key(), (Function0 & Serializable)() -> HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().defaultValue().toString())));
        boolean shouldValidateSchemasCompatibility = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable)() -> HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue())));
        boolean allowAutoEvolutionColumnDrop = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), (Function0 & Serializable)() -> HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue())));
        boolean setNullForMissingColumns = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().defaultValue())));
        if (!(mergeIntoWrites || shouldValidateSchemasCompatibility || allowAutoEvolutionColumnDrop)) {
            Schema reconciledSchema = setNullForMissingColumns ? AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, latestTableSchema, setNullForMissingColumns) : canonicalizedSourceSchema;
            AvroSchemaUtils.checkValidEvolution(reconciledSchema, latestTableSchema);
            schema = reconciledSchema;
        } else {
            if (shouldValidateSchemasCompatibility) {
                AvroSchemaUtils.checkSchemaCompatible(latestTableSchema, canonicalizedSourceSchema, true, allowAutoEvolutionColumnDrop, Collections.emptySet());
            }
            schema = canonicalizedSourceSchema;
        }
        return schema;
    }

    private Schema deduceWriterSchemaWithReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        Schema schema;
        scala.Option<InternalSchema> option = internalSchemaOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            InternalSchema internalSchema = (InternalSchema)some.value();
            boolean setNullForMissingColumns = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS.key(), (Function0 & Serializable)() -> HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS.defaultValue())));
            InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, internalSchema, setNullForMissingColumns);
            Schema evolvedSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, latestTableSchema.getFullName());
            boolean shouldRemoveMetaDataFromInternalSchema = ((SeqOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sourceSchema.getFields()).asScala()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSchemaUtils$.$anonfun$deduceWriterSchemaWithReconcile$2(f)))).isEmpty();
            schema = shouldRemoveMetaDataFromInternalSchema ? HoodieAvroUtils.removeMetadataFields(evolvedSchema) : evolvedSchema;
        } else if (None$.MODULE$.equals(option)) {
            Tuple2<Schema, Object> tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema reconciledSchema = (Schema)tuple2._1();
            boolean isCompatible = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
            Tuple2 tuple23 = tuple22;
            Schema reconciledSchema2 = (Schema)tuple23._1();
            boolean isCompatible2 = tuple23._2$mcZ$sp();
            boolean shouldValidateSchemasCompatibility = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable)() -> HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue())));
            if (shouldValidateSchemasCompatibility && !isCompatible2) {
                this.log().error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(194).append("Failed to reconcile incoming batch schema with the table's one.\n               |Incoming schema ").append(sourceSchema.toString(true)).append("\n               |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n               |Table's schema ").append(latestTableSchema.toString(true)).append("\n               |").toString())));
                throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
            }
            schema = reconciledSchema2;
        } else {
            throw new MatchError(option);
        }
        return schema;
    }

    public Schema deduceWriterSchema(Schema sourceSchema, Option<Schema> latestTableSchemaOpt, Option<InternalSchema> internalSchemaOpt, TypedProperties props) {
        return this.deduceWriterSchema(sourceSchema, HoodieConversionUtils$.MODULE$.toScalaOption(latestTableSchemaOpt), HoodieConversionUtils$.MODULE$.toScalaOption(internalSchemaOpt), HoodieConversionUtils$.MODULE$.fromProperties(props));
    }

    private Schema canonicalizeSchema(Schema sourceSchema, Schema latestTableSchema, Map<String, String> opts, boolean shouldReorderColumns) {
        return AvroSchemaEvolutionUtils.reconcileSchemaRequirements(sourceSchema, latestTableSchema, shouldReorderColumns);
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        return AvroSchemaUtils.isCompatibleProjectionOf(tableSchema, newSchema) ? new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(newSchema, tableSchema))) : new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema)));
    }

    public void checkPartitionSchemaOrder(StructType tableSchema, Seq<String> partitionFields) {
        Seq tableSchemaPartitionFields;
        String[] tableSchemaFields = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchemaFields)) && partitionFields.nonEmpty()) {
            throw new IllegalArgumentException("It is not allowed to specify partition columns when the table schema is not defined.");
        }
        Seq seq = tableSchemaPartitionFields = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchemaFields), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionFields.contains(elem)))));
        Seq<String> seq2 = partitionFields;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            throw new IllegalArgumentException(new StringBuilder(0).append("Partition schema fields order does not match the table schema fields order,").append(new StringBuilder(40).append(" tableSchemaFields: ").append(tableSchemaPartitionFields).append(", partitionFields: ").append(partitionFields).append(".").toString()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$deduceWriterSchemaWithReconcile$2(Schema.Field f) {
        return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    private HoodieSchemaUtils$() {
    }
}

