/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieStreamingSink$;
import org.apache.hudi.async.AsyncClusteringService;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.SparkStreamingAsyncClusteringService;
import org.apache.hudi.async.SparkStreamingAsyncCompactService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001B\u001d;\u0001\u0005C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"AQ\u000f\u0001B\u0001B\u0003%a\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003{\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;A\u0001\"!\u000b\u0001A\u0003&\u00111\u0003\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kA\u0001\"a\u0011\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u000b\u0002!\u0019!C\u0005\u0003\u000fB\u0001\"a\u0014\u0001A\u0003%\u0011\u0011\n\u0005\n\u0003#\u0002\u0001\u0019!C\u0005\u0003'B\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0011\u00055\u0004\u0001)Q\u0005\u0003+B\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005e\u0004\u0001)A\u0005\u0003gB\u0011\"a\u001f\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005u\u0004\u0001)A\u0005\u0003'A\u0011\"a \u0001\u0005\u0004%I!!!\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0007C\u0011\"a#\u0001\u0005\u0004%I!!!\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u0007C\u0011\"a$\u0001\u0001\u0004%I!!!\t\u0013\u0005E\u0005\u00011A\u0005\n\u0005M\u0005\u0002CAL\u0001\u0001\u0006K!a!\t\u0013\u0005e\u0005\u00011A\u0005\n\u0005\u0005\u0005\"CAN\u0001\u0001\u0007I\u0011BAO\u0011!\t\t\u000b\u0001Q!\n\u0005\r\u0005\"CAR\u0001\t\u0007I\u0011BAS\u0011!\ti\u000b\u0001Q\u0001\n\u0005\u001d\u0006bCAX\u0001\u0001\u0007\t\u0019!C\u0005\u0003cC1\"a0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B\"Y\u0011Q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BAZ\u0011-\t9\r\u0001a\u0001\u0002\u0004%I!!3\t\u0017\u0005E\u0007\u00011AA\u0002\u0013%\u00111\u001b\u0005\f\u0003/\u0004\u0001\u0019!A!B\u0013\tY\rC\u0005\u0002Z\u0002\u0001\r\u0011\"\u0003\u0002\\\"I!Q\u0001\u0001A\u0002\u0013%!q\u0001\u0005\t\u0003k\u0004\u0001\u0015)\u0003\u0002^\"I!Q\u0003\u0001A\u0002\u0013%!q\u0003\u0005\n\u0005C\u0001\u0001\u0019!C\u0005\u0005GA\u0001Ba\n\u0001A\u0003&!\u0011\u0004\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011\t\u0006\u0001C!\u0005'BqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003\u0010\u0002!\tB!%\t\u000f\t}\u0005\u0001\"\u0005\u0003\"\"9!q\u0016\u0001\u0005\n\tE\u0006b\u0002B\\\u0001\u0011%!\u0011X\u0004\b\u0005\u0007T\u0004\u0012\u0001Bc\r\u0019I$\b#\u0001\u0003H\"1q\u0010\u000eC\u0001\u00053D\u0011Ba75\u0005\u0004%\tA!8\t\u0011\t\rH\u0007)A\u0005\u0005?D\u0011B!:5\u0003\u0003%IAa:\u0003'!{w\u000eZ5f'R\u0014X-Y7j]\u001e\u001c\u0016N\\6\u000b\u0005mb\u0014\u0001\u00025vI&T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011\u0003\u0002\u0001C\u0015Z\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004PE*,7\r\u001e\t\u0003\u0017Rk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005=\u0003\u0016!C3yK\u000e,H/[8o\u0015\t\t&+A\u0002tc2T!a\u0015\u001f\u0002\u000bM\u0004\u0018M]6\n\u0005Uc%\u0001B*j].\u0004\"aV1\u000f\u0005asfBA-]\u001b\u0005Q&BA.A\u0003\u0019a$o\\8u}%\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`A\u00069\u0001/Y2lC\u001e,'\"A/\n\u0005\t\u001c'\u0001D*fe&\fG.\u001b>bE2,'BA0a\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003M\u001el\u0011\u0001U\u0005\u0003QB\u0013!bU)M\u0007>tG/\u001a=u\u0003\u001dy\u0007\u000f^5p]N\u0004Ba[8se:\u0011A.\u001c\t\u00033\u0002L!A\u001c1\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018OA\u0002NCBT!A\u001c1\u0011\u0005-\u001c\u0018B\u0001;r\u0005\u0019\u0019FO]5oO\u0006\u0001\u0002/\u0019:uSRLwN\\\"pYVlgn\u001d\t\u0004/^\u0014\u0018B\u0001=d\u0005\r\u0019V-]\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007CA>~\u001b\u0005a(BA'Q\u0013\tqHP\u0001\u0006PkR\u0004X\u000f^'pI\u0016\fa\u0001P5oSRtDCCA\u0002\u0003\u000f\tI!a\u0003\u0002\u000eA\u0019\u0011Q\u0001\u0001\u000e\u0003iBQ\u0001Z\u0003A\u0002\u0015DQ![\u0003A\u0002)DQ!^\u0003A\u0002YDQ!_\u0003A\u0002i\fa\u0003\\1uKN$8i\\7nSR$X\r\u001a\"bi\u000eD\u0017\nZ\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u00185\t\u0001-C\u0002\u0002\u001a\u0001\u0014A\u0001T8oO\u0006QB.\u0019;fgR\u001cu.\\7jiR,GMQ1uG\"LEm\u0018\u0013fcR!\u0011qDA\u0013!\u0011\t)\"!\t\n\u0007\u0005\r\u0002M\u0001\u0003V]&$\b\"CA\u0014\u000f\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\u0018Y\u0006$Xm\u001d;D_6l\u0017\u000e\u001e;fI\n\u000bGo\u00195JI\u0002B3\u0001CA\u0017!\u0011\t)\"a\f\n\u0007\u0005E\u0002M\u0001\u0005w_2\fG/\u001b7f\u0003\rawnZ\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{q\u0014!B:mMRR\u0017\u0002BA!\u0003w\u0011a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0016\u0005\u0005%\u0003#BA\u000b\u0003\u0017\u0012\u0018bAA'A\n1q\n\u001d;j_:\f!\u0002^1cY\u0016\u0004\u0016\r\u001e5!\u0003)iW\r^1DY&,g\u000e^\u000b\u0003\u0003+\u0002b!!\u0006\u0002L\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0004\u0003CR\u0014AB2p[6|g.\u0003\u0003\u0002f\u0005m#!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e^\u0001\u000f[\u0016$\u0018m\u00117jK:$x\fJ3r)\u0011\ty\"a\u001b\t\u0013\u0005\u001db\"!AA\u0002\u0005U\u0013aC7fi\u0006\u001cE.[3oi\u0002\n\u0001B]3uef\u001ce\u000e^\u000b\u0003\u0003g\u0002B!!\u0006\u0002v%\u0019\u0011q\u000f1\u0003\u0007%sG/A\u0005sKR\u0014\u0018p\u00118uA\u0005y!/\u001a;ss&sG/\u001a:wC2l5/\u0001\tsKR\u0014\u00180\u00138uKJ4\u0018\r\\'tA\u0005\t\u0012n\u001a8pe\u00164\u0015-\u001b7fI\n\u000bGo\u00195\u0016\u0005\u0005\r\u0005\u0003BA\u000b\u0003\u000bK1!a\"a\u0005\u001d\u0011un\u001c7fC:\f!#[4o_J,g)Y5mK\u0012\u0014\u0015\r^2iA\u0005\tB-[:bE2,7i\\7qC\u000e$\u0018n\u001c8\u0002%\u0011L7/\u00192mK\u000e{W\u000e]1di&|g\u000eI\u0001*SN\f5/\u001f8d\u0007>l\u0007/Y2u_J\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=\u0002[%\u001c\u0018i]=oG\u000e{W\u000e]1di>\u00148+\u001a:wS\u000e,7\u000b[;uI><h.\u00112o_Jl\u0017\r\u001c7z?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005U\u0005\"CA\u00143\u0005\u0005\t\u0019AAB\u0003)J7/Q:z]\u000e\u001cu.\u001c9bGR|'oU3sm&\u001cWm\u00155vi\u0012|wO\\!c]>\u0014X.\u00197ms\u0002\n!&[:Bgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u00170\u0001\u0018jg\u0006\u001b\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=`I\u0015\fH\u0003BA\u0010\u0003?C\u0011\"a\n\u001d\u0003\u0003\u0005\r!a!\u0002W%\u001c\u0018i]=oG\u000ecWo\u001d;fe&twmU3sm&\u001cWm\u00155vi\u0012|wO\\!c]>\u0014X.\u00197ms\u0002\nA!\\8eKV\u0011\u0011q\u0015\t\u0004M\u0006%\u0016bAAV!\nA1+\u0019<f\u001b>$W-A\u0003n_\u0012,\u0007%A\u000bbgft7mQ8na\u0006\u001cGo\u001c:TKJ4\u0018nY3\u0016\u0005\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e&(A\u0003bgft7-\u0003\u0003\u0002>\u0006]&aE!ts:\u001c7i\\7qC\u000e$8+\u001a:wS\u000e,\u0017!G1ts:\u001c7i\\7qC\u000e$xN]*feZL7-Z0%KF$B!a\b\u0002D\"I\u0011qE\u0011\u0002\u0002\u0003\u0007\u00111W\u0001\u0017CNLhnY\"p[B\f7\r^8s'\u0016\u0014h/[2fA\u00051\u0012m]=oG\u000ecWo\u001d;fe&twmU3sm&\u001cW-\u0006\u0002\u0002LB!\u0011QWAg\u0013\u0011\ty-a.\u0003-\u0005\u001b\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016\f!$Y:z]\u000e\u001cE.^:uKJLgnZ*feZL7-Z0%KF$B!a\b\u0002V\"I\u0011q\u0005\u0013\u0002\u0002\u0003\u0007\u00111Z\u0001\u0018CNLhnY\"mkN$XM]5oON+'O^5dK\u0002\n1b\u001e:ji\u0016\u001cE.[3oiV\u0011\u0011Q\u001c\t\u0007\u0003+\tY%a81\t\u0005\u0005\u0018\u0011\u001f\t\u0007\u0003G\fI/!<\u000e\u0005\u0005\u0015(bAAtu\u000511\r\\5f]RLA!a;\u0002f\n\u00192\u000b]1sWJ#Ei\u0016:ji\u0016\u001cE.[3oiB!\u0011q^Ay\u0019\u0001!1\"a=)\u0003\u0003\u0005\tQ!\u0001\u0002x\n\u0019q\fJ\u0019\u0002\u0019]\u0014\u0018\u000e^3DY&,g\u000e\u001e\u0011\u0012\t\u0005e\u0018q \t\u0005\u0003+\tY0C\u0002\u0002~\u0002\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0016\t\u0005\u0011b\u0001B\u0002A\n\u0019\u0011I\\=\u0002\u001f]\u0014\u0018\u000e^3DY&,g\u000e^0%KF$B!a\b\u0003\n!I\u0011qE\u0014\u0002\u0002\u0003\u0007!1\u0002\t\u0007\u0003+\tYE!\u00041\t\t=!1\u0003\t\u0007\u0003G\fIO!\u0005\u0011\t\u0005=(1\u0003\u0003\r\u0003g\u0014I!!A\u0001\u0002\u000b\u0005\u0011q_\u0001\u0012Q>|G-[3UC\ndWmQ8oM&<WC\u0001B\r!\u0019\t)\"a\u0013\u0003\u001cA!\u0011\u0011\fB\u000f\u0013\u0011\u0011y\"a\u0017\u0003#!{w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw-A\u000bi_>$\u0017.\u001a+bE2,7i\u001c8gS\u001e|F%Z9\u0015\t\u0005}!Q\u0005\u0005\n\u0003OQ\u0013\u0011!a\u0001\u00053\t!\u0003[8pI&,G+\u00192mK\u000e{gNZ5hA\u0005A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002 \t5\"\u0011\u0007\u0005\b\u0005_a\u0003\u0019AA\n\u0003\u001d\u0011\u0017\r^2i\u0013\u0012DqAa\r-\u0001\u0004\u0011)$\u0001\u0003eCR\f\u0007\u0003\u0002B\u001c\u0005\u0017rAA!\u000f\u0003J9!!1\bB$\u001d\u0011\u0011iD!\u0012\u000f\t\t}\"1\t\b\u00043\n\u0005\u0013\"A \n\u0005ur\u0014BA*=\u0013\t\t&+\u0003\u0002`!&!!Q\nB(\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002`!\u0006AAo\\*ue&tw\rF\u0001s\u0003\u0015\u0011X\r\u001e:z+\u0011\u0011IFa\u001b\u0015\r\tm#\u0011\u0010B?)\u0011\u0011iFa\u001c\u0011\r\t}#Q\rB5\u001b\t\u0011\tGC\u0002\u0003d\u0001\fA!\u001e;jY&!!q\rB1\u0005\r!&/\u001f\t\u0005\u0003_\u0014Y\u0007B\u0004\u0003n9\u0012\r!a>\u0003\u0003QC\u0001B!\u001d/\t\u0003\u0007!1O\u0001\u0003M:\u0004b!!\u0006\u0003v\tu\u0013b\u0001B<A\nAAHY=oC6,g\bC\u0004\u0003|9\u0002\r!a\u001d\u0002\u00039DqAa /\u0001\u0004\t\u0019\"\u0001\u0007xC&$\u0018J\\'jY2L7\u000fK\u0002/\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013\u0003\u0017AC1o]>$\u0018\r^5p]&!!Q\u0012BD\u0005\u001d!\u0018-\u001b7sK\u000e\fQ\u0003\u001e:jO\u001e,'/Q:z]\u000e\u001cu.\u001c9bGR|'\u000f\u0006\u0003\u0002 \tM\u0005bBAt_\u0001\u0007!Q\u0013\u0019\u0005\u0005/\u0013Y\n\u0005\u0004\u0002d\u0006%(\u0011\u0014\t\u0005\u0003_\u0014Y\n\u0002\u0007\u0003\u001e\nM\u0015\u0011!A\u0001\u0006\u0003\t9PA\u0002`II\na\u0003\u001e:jO\u001e,'/Q:z]\u000e\u001cE.^:uKJLgn\u001a\u000b\u0005\u0003?\u0011\u0019\u000bC\u0004\u0002hB\u0002\rA!*1\t\t\u001d&1\u0016\t\u0007\u0003G\fIO!+\u0011\t\u0005=(1\u0016\u0003\r\u0005[\u0013\u0019+!A\u0001\u0002\u000b\u0005\u0011q\u001f\u0002\u0004?\u0012\u001a\u0014!\u0002:fg\u0016$H\u0003BA\u0010\u0005gCqA!.2\u0001\u0004\t\u0019)A\u0003g_J\u001cW-\u0001\u0007dC:\u001c6.\u001b9CCR\u001c\u0007\u000e\u0006\u0004\u0002\u0004\nm&q\u0018\u0005\b\u0005{\u0013\u0004\u0019AA\n\u0003=IgnY8nS:<')\u0019;dQ&#\u0007B\u0002Bae\u0001\u0007!/A\u0007pa\u0016\u0014\u0018\r^5p]RK\b/Z\u0001\u0014\u0011>|G-[3TiJ,\u0017-\\5oONKgn\u001b\t\u0004\u0003\u000b!4#\u0002\u001b\u0003J\n=\u0007\u0003BA\u000b\u0005\u0017L1A!4a\u0005\u0019\te.\u001f*fMB!!\u0011\u001bBl\u001b\t\u0011\u0019NC\u0002\u0003V\u001a\u000b!![8\n\u0007\t\u0014\u0019\u000e\u0006\u0002\u0003F\u0006\u00192+\u0013(L?\u000eCUiQ&Q\u001f&sEkX&F3V\u0011!q\u001c\t\u0004\u0007\n\u0005\u0018B\u0001;E\u0003Q\u0019\u0016JT&`\u0007\"+5i\u0013)P\u0013:#vlS#ZA\u0005aqO]5uKJ+\u0007\u000f\\1dKR\t!\t")
public class HoodieStreamingSink
implements Sink,
Serializable {
    private final SQLContext sqlContext;
    public final Map<String, String> org$apache$hudi$HoodieStreamingSink$$options;
    private volatile long latestCommittedBatchId;
    private final Logger org$apache$hudi$HoodieStreamingSink$$log;
    private final scala.Option<String> tablePath;
    private scala.Option<HoodieTableMetaClient> metaClient;
    private final int retryCnt;
    private final long retryIntervalMs;
    private final boolean ignoreFailedBatch;
    private final boolean disableCompaction;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    private final SaveMode mode;
    private AsyncCompactService asyncCompactorService;
    private AsyncClusteringService asyncClusteringService;
    private scala.Option<SparkRDDWriteClient<?>> writeClient;
    private scala.Option<HoodieTableConfig> hoodieTableConfig;

    public static String SINK_CHECKPOINT_KEY() {
        return HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY();
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    private long latestCommittedBatchId() {
        return this.latestCommittedBatchId;
    }

    private void latestCommittedBatchId_$eq(long x$1) {
        this.latestCommittedBatchId = x$1;
    }

    public Logger org$apache$hudi$HoodieStreamingSink$$log() {
        return this.org$apache$hudi$HoodieStreamingSink$$log;
    }

    private scala.Option<String> tablePath() {
        return this.tablePath;
    }

    private scala.Option<HoodieTableMetaClient> metaClient() {
        return this.metaClient;
    }

    private void metaClient_$eq(scala.Option<HoodieTableMetaClient> x$1) {
        this.metaClient = x$1;
    }

    private int retryCnt() {
        return this.retryCnt;
    }

    private long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    private boolean ignoreFailedBatch() {
        return this.ignoreFailedBatch;
    }

    private boolean disableCompaction() {
        return this.disableCompaction;
    }

    private boolean isAsyncCompactorServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = x$1;
    }

    private boolean isAsyncClusteringServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private AsyncCompactService asyncCompactorService() {
        return this.asyncCompactorService;
    }

    private void asyncCompactorService_$eq(AsyncCompactService x$1) {
        this.asyncCompactorService = x$1;
    }

    private AsyncClusteringService asyncClusteringService() {
        return this.asyncClusteringService;
    }

    private void asyncClusteringService_$eq(AsyncClusteringService x$1) {
        this.asyncClusteringService = x$1;
    }

    private scala.Option<SparkRDDWriteClient<?>> writeClient() {
        return this.writeClient;
    }

    private void writeClient_$eq(scala.Option<SparkRDDWriteClient<?>> x$1) {
        this.writeClient = x$1;
    }

    private scala.Option<HoodieTableConfig> hoodieTableConfig() {
        return this.hoodieTableConfig;
    }

    private void hoodieTableConfig_$eq(scala.Option<HoodieTableConfig> x$1) {
        this.hoodieTableConfig = x$1;
    }

    public synchronized void addBatch(long batchId, Dataset<Row> data2) {
        Try try_;
        if (this.isAsyncCompactorServiceShutdownAbnormally()) {
            throw new IllegalStateException("Async Compactor shutdown unexpectedly");
        }
        if (this.isAsyncClusteringServiceShutdownAbnormally()) {
            this.org$apache$hudi$HoodieStreamingSink$$log().error("Async clustering service shutdown unexpectedly");
            throw new IllegalStateException("Async clustering service shutdown unexpectedly");
        }
        String queryId = this.sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
        ValidationUtils.checkArgument(queryId != null, "queryId is null");
        if (this.metaClient().isDefined() && this.canSkipBatch(batchId, (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()))) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(43).append("Skipping already completed batch ").append(batchId).append(" in query ").append(queryId).toString());
            return;
        }
        ObjectRef updatedOptions = ObjectRef.create((Object)((Map)this.org$apache$hudi$HoodieStreamingSink$$options.updated((Object)HoodieWriteConfig.MARKERS_TYPE.key(), (Object)MarkerType.DIRECT.name())));
        updatedOptions.elem = (Map)((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"true");
        updatedOptions.elem = (Map)((Map)updatedOptions.elem).updated((Object)HoodieSparkSqlWriter$.MODULE$.SPARK_STREAMING_BATCH_ID(), (Object)Long.toString(batchId));
        if (!this.org$apache$hudi$HoodieStreamingSink$$options.contains((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key())) {
            updatedOptions.elem = (Map)((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key(), (Object)" false");
        }
        if ((try_ = this.retry(this.retryCnt(), this.retryIntervalMs(), (Function0 & Serializable)() -> {
            Failure failure;
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write($this.sqlContext, this.mode(), (Map<String, String>)((Map)updatedOptions$1.elem), data2, (scala.Option<HoodieSparkSqlWriter.StreamingWriteParams>)new Some((Object)new HoodieSparkSqlWriter.StreamingWriteParams(this.hoodieTableConfig(), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)(this.disableCompaction() ? None$.MODULE$ : new Some((Function1 & Serializable)client -> {
                this.triggerAsyncCompactor(client);
                return BoxedUnit.UNIT;
            })), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)new Some((Function1 & Serializable)client -> {
                this.triggerAsyncClustering(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)new Some((Object)new BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>(this, batchId){
                private final /* synthetic */ HoodieStreamingSink $outer;
                private final long batchId$1;

                public BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata> andThen(BiConsumer<? super HoodieTableMetaClient, ? super HoodieCommitMetadata> x$1) {
                    return BiConsumer.super.andThen(x$1);
                }

                public void accept(HoodieTableMetaClient metaClient, HoodieCommitMetadata newCommitMetadata) {
                    String identifier = (String)this.$outer.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
                    newCommitMetadata.addMetadata(HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString(identifier, String.valueOf(this.batchId$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchId$1 = batchId$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1()}, serializedLambda);
                }
            }))), this.writeClient()));
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Tuple6 tuple6 = (Tuple6)success.value();
                if (tuple6 != null) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                    Option commitOps = (Option)tuple6._2();
                    Option compactionInstantOps = (Option)tuple6._3();
                    Option clusteringInstant = (Option)tuple6._4();
                    SparkRDDWriteClient client = (SparkRDDWriteClient)tuple6._5();
                    HoodieTableConfig tableConfig = (HoodieTableConfig)tuple6._6();
                    if (bl2) {
                        boolean bl3 = commitOps.isPresent();
                        String string = true == bl3 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : " with no new commits";
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(0).append(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString()).append((Object)string).toString());
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(86).append("Current value of latestCommittedBatchId: ").append(this.latestCommittedBatchId()).append(". Setting latestCommittedBatchId to batchId ").append(batchId).append(".").toString());
                        this.latestCommittedBatchId_$eq(batchId);
                        this.writeClient_$eq((scala.Option<SparkRDDWriteClient<?>>)new Some((Object)client));
                        this.hoodieTableConfig_$eq((scala.Option<HoodieTableConfig>)new Some((Object)tableConfig));
                        if (client != null) {
                            this.metaClient_$eq((scala.Option<HoodieTableMetaClient>)new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy($this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build()));
                        }
                        if (compactionInstantOps.isPresent()) {
                            this.asyncCompactorService().enqueuePendingAsyncServiceInstant((String)compactionInstantOps.get());
                        }
                        if (!clusteringInstant.isPresent()) return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                        this.asyncClusteringService().enqueuePendingAsyncServiceInstant((String)clusteringInstant.get());
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                    }
                }
            }
            if (try_ instanceof Failure) {
                Failure failure2;
                Failure failure3 = (Failure)try_;
                Throwable e = failure3.exception();
                data2.sparkSession().sparkContext().getPersistentRDDs().foreach((Function1 & Serializable)x0$1 -> {
                    RDD rDD;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        RDD rdd = (RDD)tuple2._2();
                        try {
                            rDD = rdd.unpersist(rdd.unpersist$default$1());
                        }
                        catch (Exception t) {
                            this.org$apache$hudi$HoodieStreamingSink$$log().warn("Got excepting trying to unpersist rdd", (Throwable)t);
                            rDD = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    RDD rDD2 = rDD;
                    return rDD2;
                });
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following exception: ").toString(), e);
                if (this.ignoreFailedBatch()) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(0).append("Ignore the exception and move on streaming as per ").append(new StringBuilder(14).append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString()).toString());
                    failure2 = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                    return failure2;
                } else {
                    if (this.retryCnt() > 1) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                    }
                    failure2 = new Failure(e);
                }
                return failure2;
            }
            if (!bl) throw new MatchError((Object)try_);
            Tuple6 tuple6 = (Tuple6)success.value();
            if (tuple6 == null) throw new MatchError((Object)try_);
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            Option commitOps = (Option)tuple6._2();
            if (false != bl4) throw new MatchError((Object)try_);
            boolean bl5 = commitOps.isPresent();
            String string = true == bl5 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : "";
            this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(0).append(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()).append((Object)string).toString());
            if (this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(0).append("Ignore the errors and move on streaming as per ").append(new StringBuilder(14).append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString()).toString());
                failure = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                return failure;
            } else {
                if (this.retryCnt() > 1) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                }
                failure = new Failure((Throwable)new HoodieCorruptedDataException(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()));
            }
            return failure;
        })) instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (!this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(0).append(new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following expections,").toString()).append("aborting streaming app to avoid data loss: ").toString(), e);
                this.org$apache$hudi$HoodieStreamingSink$$reset(true);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Success) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public String toString() {
        return new StringBuilder(21).append("HoodieStreamingSink[").append(this.org$apache$hudi$HoodieStreamingSink$$options.apply((Object)"path")).append("]").toString();
    }

    private <T> Try<T> retry(int n, long waitInMillis, Function0<Try<T>> fn) {
        Success success;
        block2: {
            Try try_;
            while (true) {
                if ((try_ = (Try)fn.apply()) instanceof Success) {
                    Success success2;
                    success = success2 = (Success)try_;
                    break block2;
                }
                if (n <= 1) break;
                Thread.sleep(waitInMillis);
                waitInMillis *= 2L;
                --n;
            }
            this.org$apache$hudi$HoodieStreamingSink$$reset(false);
            success = try_;
        }
        return success;
    }

    public void triggerAsyncCompactor(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncCompactorService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering Async compaction !!");
            this.asyncCompactorService_$eq(new SparkStreamingAsyncCompactService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncCompactorService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(36).append("Async Compactor shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info("Done resetting write client.");
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy(this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = CompactionUtils.getPendingCompactionInstantTimes(metaClient);
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncCompactor$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void triggerAsyncClustering(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncClusteringService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering async clustering!");
            this.asyncClusteringService_$eq(new SparkStreamingAsyncClusteringService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncClusteringService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(45).append("Async clustering service shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy(this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = ClusteringUtils.getPendingClusteringInstantTimes(metaClient);
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncClustering$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void org$apache$hudi$HoodieStreamingSink$$reset(boolean force) {
        block2: {
            if (this.asyncCompactorService() != null) {
                this.asyncCompactorService().shutdown(force);
                this.asyncCompactorService_$eq(null);
            }
            if (this.asyncClusteringService() != null) {
                this.asyncClusteringService().shutdown(force);
                this.asyncClusteringService_$eq(null);
            }
            if (!this.writeClient().isDefined()) break block2;
            ((BaseHoodieWriteClient)this.writeClient().get()).close();
            this.writeClient_$eq(Option$.MODULE$.empty());
        }
    }

    private boolean canSkipBatch(long incomingBatchId, String operationType) {
        boolean bl;
        if (!DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL().equals(operationType)) {
            String identifier = (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
            Option<String> lastCheckpoint = CommitUtils.getValidCheckpointForCurrentWriter(((HoodieTableMetaClient)this.metaClient().get()).getActiveTimeline().getWriteTimeline(), HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), identifier);
            if (lastCheckpoint.isPresent()) {
                this.latestCommittedBatchId_$eq(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(lastCheckpoint.get())));
            }
            bl = this.latestCommittedBatchId() >= incomingBatchId;
        } else {
            bl = false;
        }
        return bl;
    }

    private final /* synthetic */ scala.Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy(this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath((String)this.tablePath().get()).build());
        }
        catch (TableNotFoundException tableNotFoundException) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn("Ignore TableNotFoundException as it is first microbatch.");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncCompactor$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncCompactorService().enqueuePendingAsyncServiceInstant(h.requestedTime());
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncClustering$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncClusteringService().enqueuePendingAsyncServiceInstant(h.requestedTime());
    }

    public HoodieStreamingSink(SQLContext sqlContext, Map<String, String> options, Seq<String> partitionColumns, OutputMode outputMode) {
        this.sqlContext = sqlContext;
        this.org$apache$hudi$HoodieStreamingSink$$options = options;
        Sink.$init$((Sink)this);
        this.latestCommittedBatchId = -1L;
        this.org$apache$hudi$HoodieStreamingSink$$log = LoggerFactory.getLogger(HoodieStreamingSink.class);
        this.tablePath = options.get((Object)"path");
        if (this.tablePath().isEmpty() || this.tablePath().get() == null) {
            throw new HoodieException("'path'  must be specified.");
        }
        this.metaClient = this.liftedTree1$1();
        this.retryCnt = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().defaultValue())));
        this.retryIntervalMs = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue())));
        this.ignoreFailedBatch = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue())));
        this.disableCompaction = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().defaultValue())));
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = false;
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = false;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        this.mode = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) ? SaveMode.Append : SaveMode.Overwrite;
        this.writeClient = Option$.MODULE$.empty();
        this.hoodieTableConfig = Option$.MODULE$.empty();
    }
}

