/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.SparkAdapter;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;

public final class LogFileIterator$
implements SparkAdapterSupport {
    public static final LogFileIterator$ MODULE$ = new LogFileIterator$();
    private static SparkAdapter sparkAdapter;
    private static volatile boolean bitmap$0;

    static {
        SparkAdapterSupport.$init$(MODULE$);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        LogFileIterator$ logFileIterator$ = this;
        synchronized (logFileIterator$) {
            if (!bitmap$0) {
                sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                bitmap$0 = true;
            }
        }
        return sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !bitmap$0 ? this.sparkAdapter$lzycompute() : sparkAdapter;
    }

    public Map<String, HoodieRecord<?>> scanLog(List<HoodieLogFile> logFiles, StoragePath partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        Map map2;
        String tablePath = tableState.tablePath();
        HoodieStorage storage2 = HoodieStorageUtils.getStorage(tablePath, HadoopFSUtils.getStorageConf(hadoopConf));
        if (HoodieTableMetadata.isMetadataTable(tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(tableState.metadataConfig().getProps()).withSpillableMapDir(hadoopConf.get(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath())).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable(tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(HadoopFSUtils.getStorageConf(hadoopConf)), storage2, metadataConfig, dataTableBasePath);
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath(new StoragePath(tablePath), partitionPath);
            HoodieMetadataLogRecordReader logRecordReader = metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption(new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan))), HoodieConversionUtils$.MODULE$.toJavaOption(new Some(tableState.latestCommitTimestamp().get()))).getLeft();
            java.util.List recordList = (java.util.List)this.closing(logRecordReader, (Function0 & Serializable)() -> logRecordReader.getRecords());
            map2 = (Map)HashMap$.MODULE$.apply(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(recordList).asScala()).map((Function1 & Serializable)r -> new Tuple2((Object)r.getRecordKey(), r))).toSeq());
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withStorage(storage2).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1 & Serializable)logFile -> logFile.getPath().toString())).asJava())).withReaderSchema(logSchema).withLatestInstantTime((String)tableState.latestCommitTimestamp().get()).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE.key(), 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath())).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath(new StoragePath(tableState.tablePath()), ((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            logRecordScannerBuilder.withRecordMerger(HoodieRecordUtils.createRecordMerger(tableState.tablePath(), EngineType.SPARK, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergeImplClasses()).asJava(), tableState.recordMergeStrategyId()));
            HoodieMergedLogRecordScanner scanner = logRecordScannerBuilder.build();
            map2 = (Map)this.closing(scanner, (Function0 & Serializable)() -> (HashMap)HashMap$.MODULE$.apply(((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(scanner.getRecords()).asScala()).toSeq()));
        }
        return map2;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public <T> T closing(Closeable c, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        finally {
            c.close();
        }
        return (T)object;
    }

    public StoragePath getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((StoragePath)split.dataFile().map((Function1 & Serializable)baseFile -> MODULE$.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile((PartitionedFile)baseFile)).getOrElse((Function0 & Serializable)() -> ((HoodieLogFile)split.logFiles().head()).getPath())).getParent();
    }

    private LogFileIterator$() {
    }
}

