/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkFilterHelper$ {
    public static final SparkFilterHelper$ MODULE$ = new SparkFilterHelper$();

    public Expression convertFilters(scala.collection.immutable.Seq<Filter> filters) {
        return (Expression)((IterableOnceOps)filters.flatMap((Function1 & Serializable)filter -> MODULE$.convertFilter((Filter)filter))).reduceLeftOption((Function2 & Serializable)(x$1, x$2) -> Predicates.and(x$1, x$2)).getOrElse((Function0 & Serializable)() -> Predicates.alwaysTrue());
    }

    public Option<Expression> convertFilter(Filter filter) {
        Some some;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            some = new Some((Object)Predicates.eq(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            some = new Some((Object)Predicates.eq(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            some = new Some((Object)Predicates.lt(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            some = new Some((Object)Predicates.lteq(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            some = new Some((Object)Predicates.gt(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            some = new Some((Object)Predicates.gteq(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values2 = in.values();
            some = new Some((Object)Predicates.in(new NameReference(attribute), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)values2), (Function1 & Serializable)x$1 -> MODULE$.toLiteral(x$1), ClassTag$.MODULE$.apply(Expression.class))).toList()).asJava()));
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            some = this.convertFilter(left).flatMap((Function1 & Serializable)convertedLeft -> MODULE$.convertFilter(right).map((Function1 & Serializable)convertedRight -> Predicates.and(convertedLeft, convertedRight)));
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            some = this.convertFilter(left).flatMap((Function1 & Serializable)convertedLeft -> MODULE$.convertFilter(right).map((Function1 & Serializable)convertedRight -> Predicates.or(convertedLeft, convertedRight)));
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            some = new Some((Object)Predicates.startsWith(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            some = new Some((Object)Predicates.contains(new NameReference(attribute), this.toLiteral(value)));
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            some = this.convertFilter(child).map((Function1 & Serializable)x$1 -> Predicates.not(x$1));
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            some = new Some((Object)Predicates.isNull(new NameReference(attribute)));
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            some = new Some((Object)Predicates.isNotNull(new NameReference(attribute)));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public Literal<?> toLiteral(Object value) {
        Literal<Number> literal;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            literal = new Literal<Long>(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp)), Types.TimestampType.get());
        } else if (object instanceof Date) {
            Date date = (Date)object;
            literal = new Literal<Integer>(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)), Types.DateType.get());
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            literal = new Literal<Long>(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), Types.TimestampType.get());
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            literal = new Literal<Integer>(BoxesRunTime.boxToInteger((int)Math.toIntExact(localDate.toEpochDay())), Types.TimestampType.get());
        } else {
            literal = Literal.from(value);
        }
        return literal;
    }

    public Type convertDataType(DataType sparkType) {
        Type type2;
        DataType dataType = sparkType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields2 = structType.fields();
            List convertedFields = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields2))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField field = (StructField)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                Types.Field field2 = Types.Field.get(idx, field.nullable(), field.name(), MODULE$.convertDataType(field.dataType()), (String)field.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                return field2;
            }, ClassTag$.MODULE$.apply(Types.Field.class))).toList()).asJava();
            type2 = Types.RecordType.get(convertedFields);
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            type2 = Types.BooleanType.get();
        } else {
            boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType));
            if (bl) {
                type2 = Types.IntType.get();
            } else if (LongType$.MODULE$.equals(dataType)) {
                type2 = Types.LongType.get();
            } else if (FloatType$.MODULE$.equals(dataType)) {
                type2 = Types.FloatType.get();
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                type2 = Types.DoubleType.get();
            } else {
                boolean bl2 = StringType$.MODULE$.equals(dataType) ? true : (dataType instanceof CharType ? true : dataType instanceof VarcharType);
                if (bl2) {
                    type2 = Types.StringType.get();
                } else if (DateType$.MODULE$.equals(dataType)) {
                    type2 = Types.DateType.get();
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    type2 = Types.TimestampType.get();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    type2 = Types.DecimalType.get(decimalType.precision(), decimalType.scale());
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(50).append("Cannot convert spark type ").append(sparkType).append(" to the relate HUDI type").toString());
                }
            }
        }
        return type2;
    }

    private SparkFilterHelper$() {
    }
}

