/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimeLogicalTypeProcessor;
import org.apache.hudi.common.util.collection.Pair;

public class TimestampMilliLogicalTypeProcessor
extends TimeLogicalTypeProcessor {
    public TimestampMilliLogicalTypeProcessor() {
        super(AvroLogicalTypeEnum.TIMESTAMP_MILLIS);
    }

    @Override
    public Pair<Boolean, Object> convert(Object value, String name2, Schema schema) {
        return this.convertCommon(new Parser.LongParser(){

            @Override
            public Pair<Boolean, Object> handleStringValue(String value) {
                return TimestampMilliLogicalTypeProcessor.this.convertDateTime(value, null, time -> Instant.EPOCH.until((Temporal)time, ChronoField.MILLI_OF_SECOND.getBaseUnit()));
            }
        }, value, schema);
    }
}

