/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.client.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.org.apache.http.client.config.RequestConfig;
import org.apache.hudi.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.hudi.org.apache.http.client.methods.HttpPost;
import org.apache.hudi.org.apache.http.entity.ContentType;
import org.apache.hudi.org.apache.http.entity.StringEntity;
import org.apache.hudi.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hudi.org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieWriteCommitHttpCallbackClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteCommitHttpCallbackClient.class);
    public static final String HEADER_KEY_API_KEY = "HUDI-CALLBACK-KEY";
    static final String HEADERS_DELIMITER = ";";
    static final String HEADERS_KV_DELIMITER = ":";
    private final String apiKey;
    private final String url;
    private final CloseableHttpClient client;
    private HoodieWriteConfig writeConfig;
    private final Map<String, String> customHeaders;

    public HoodieWriteCommitHttpCallbackClient(HoodieWriteConfig config) {
        this.writeConfig = config;
        this.apiKey = this.getApiKey();
        this.url = this.getUrl();
        this.client = this.getClient();
        this.customHeaders = this.parseCustomHeaders();
    }

    public HoodieWriteCommitHttpCallbackClient(String apiKey, String url2, CloseableHttpClient client, Map<String, String> customHeaders) {
        this.apiKey = apiKey;
        this.url = url2;
        this.client = client;
        this.customHeaders = customHeaders != null ? customHeaders : new HashMap();
    }

    public void send(String callbackMsg) {
        HttpPost request = new HttpPost(this.url);
        request.setHeader(HEADER_KEY_API_KEY, this.apiKey);
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        this.customHeaders.forEach(request::setHeader);
        request.setEntity(new StringEntity(callbackMsg, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.client.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                LOG.warn("Failed to send callback message. Response was {}", (Object)response);
            } else {
                LOG.info("Sent Callback data with {} custom headers to {} successfully !", (Object)this.customHeaders.size(), (Object)this.url);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to send callback.", (Throwable)e);
        }
    }

    private String getApiKey() {
        return this.writeConfig.getString(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_API_KEY_VALUE);
    }

    private String getUrl() {
        return this.writeConfig.getString(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_URL);
    }

    private CloseableHttpClient getClient() {
        int timeoutSeconds = this.getHttpTimeoutSeconds() * 1000;
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutSeconds).setConnectionRequestTimeout(timeoutSeconds).setSocketTimeout(timeoutSeconds).build()).build();
    }

    private Integer getHttpTimeoutSeconds() {
        return this.writeConfig.getInt(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_TIMEOUT_IN_SECONDS);
    }

    private Map<String, String> parseCustomHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String headersString = this.writeConfig.getString(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_CUSTOM_HEADERS);
        if (!StringUtils.isNullOrEmpty(headersString)) {
            StringTokenizer tokenizer = new StringTokenizer(headersString, HEADERS_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (StringUtils.isNullOrEmpty(token)) continue;
                String[] keyValue = token.split(HEADERS_KV_DELIMITER);
                if (keyValue.length == 2) {
                    String trimKey = keyValue[0].trim();
                    String trimValue = keyValue[1].trim();
                    if (trimKey.length() <= 0 || trimValue.length() <= 0) continue;
                    headers.put(trimKey, trimValue);
                    continue;
                }
                LOG.warn("Unable to parse some custom headers. Supported format is: Header_name1:Header value1;Header_name2:Header value2");
            }
        }
        return headers;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @VisibleForTesting
    String getCustomHeaders() {
        return this.customHeaders.toString();
    }
}

