/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieUnMergedLogRecordScanner;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.functional.HoodieExpressionIndex;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.spark.api.java.function.FlatMapGroupsFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import scala.Function1;
import scala.collection.immutable.List;

public class SparkMetadataWriterUtils {
    public static Column[] getExpressionIndexColumns() {
        return new Column[]{functions.col((String)"_hoodie_expression_index_partition"), functions.col((String)"_hoodie_expression_index_relative_file_path"), functions.col((String)"_hoodie_expression_index_file_size")};
    }

    public static String[] getExpressionIndexColumnNames() {
        return new String[]{"_hoodie_expression_index_partition", "_hoodie_expression_index_relative_file_path", "_hoodie_expression_index_file_size"};
    }

    @NotNull
    public static java.util.List<Row> getRowsWithExpressionIndexMetadata(java.util.List<Row> rowsForFilePath, String partition, String filePath, long fileSize) {
        return rowsForFilePath.stream().map(row -> {
            List<Object> indexMetadata = JavaScalaConverters.convertJavaListToScalaList(Arrays.asList(partition, filePath, fileSize));
            Row expressionIndexRow = Row.fromSeq(indexMetadata);
            ArrayList<Row> rows = new ArrayList<Row>(2);
            rows.add((Row)row);
            rows.add(expressionIndexRow);
            List rowSeq = JavaScalaConverters.convertJavaListToScalaList(rows);
            return Row.merge(rowSeq);
        }).collect(Collectors.toList());
    }

    public static HoodieData<HoodieRecord> getExpressionIndexRecordsUsingColumnStats(Dataset<Row> dataset, HoodieExpressionIndex<Column, Column> expressionIndex, String columnToIndex) {
        Dataset columnRangeMetadataDataset = dataset.select(columnToIndex, SparkMetadataWriterUtils.getExpressionIndexColumnNames()).groupBy(SparkMetadataWriterUtils.getExpressionIndexColumns()).agg(functions.count((Column)functions.when((Column)functions.col((String)columnToIndex).isNull(), (Object)1)).alias("nullCount"), new Column[]{functions.min((String)columnToIndex).alias("minValue"), functions.max((String)columnToIndex).alias("maxValue"), functions.count((String)columnToIndex).alias("valueCount")});
        return HoodieJavaRDD.of(columnRangeMetadataDataset.javaRDD()).flatMap(row -> {
            int baseAggregatePosition = SparkMetadataWriterUtils.getExpressionIndexColumnNames().length;
            long nullCount = row.getLong(baseAggregatePosition);
            Comparable minValue = (Comparable)row.get(baseAggregatePosition + 1);
            Comparable maxValue = (Comparable)row.get(baseAggregatePosition + 2);
            long valueCount = row.getLong(baseAggregatePosition + 3);
            String partitionName = row.getString(0);
            String relativeFilePath = row.getString(1);
            long totalFileSize = row.getLong(2);
            long totalUncompressedSize = totalFileSize * 2L;
            HoodieColumnRangeMetadata<Comparable> rangeMetadata = HoodieColumnRangeMetadata.create(relativeFilePath, columnToIndex, minValue, maxValue, nullCount, valueCount, totalFileSize, totalUncompressedSize);
            return HoodieMetadataPayload.createColumnStatsRecords(partitionName, Collections.singletonList(rangeMetadata), false, expressionIndex.getIndexName(), MetadataPartitionType.COLUMN_STATS.getRecordType()).collect(Collectors.toList()).iterator();
        });
    }

    public static HoodieData<HoodieRecord> getExpressionIndexRecordsUsingBloomFilter(Dataset<Row> dataset, String columnToIndex, HoodieWriteConfig metadataWriteConfig, String instantTime, String indexName) {
        Dataset bloomFilterRecords = dataset.select(columnToIndex, SparkMetadataWriterUtils.getExpressionIndexColumnNames()).groupByKey((MapFunction & Serializable)row -> Pair.of(row.getString(1), row.getString(2)), Encoders.kryo(Pair.class)).flatMapGroups((FlatMapGroupsFunction & Serializable)(pair, iterator2) -> {
            String partition = pair.getLeft().toString();
            String relativeFilePath = pair.getRight().toString();
            String fileName = FSUtils.getFileName(relativeFilePath, partition);
            BloomFilter bloomFilter = HoodieFileWriterFactory.createBloomFilter(metadataWriteConfig);
            iterator2.forEachRemaining(row -> {
                byte[] key = row.getAs(columnToIndex).toString().getBytes();
                bloomFilter.add(key);
            });
            ByteBuffer bloomByteBuffer = ByteBuffer.wrap(StringUtils.getUTF8Bytes(bloomFilter.serializeToString()));
            HoodieRecord<HoodieMetadataPayload> bloomFilterRecord = HoodieMetadataPayload.createBloomFilterMetadataRecord(partition, fileName, instantTime, metadataWriteConfig.getBloomFilterType(), bloomByteBuffer, false, indexName);
            return Collections.singletonList(bloomFilterRecord).iterator();
        }, Encoders.kryo(HoodieRecord.class));
        return HoodieJavaRDD.of(bloomFilterRecords.javaRDD());
    }

    public static java.util.List<Row> readRecordsAsRows(StoragePath[] paths, SQLContext sqlContext, HoodieTableMetaClient metaClient, Schema schema, HoodieWriteConfig dataWriteConfig, boolean isBaseFile) {
        java.util.List<HoodieRecord> records = isBaseFile ? SparkMetadataWriterUtils.getBaseFileRecords(new HoodieBaseFile(paths[0].toString()), metaClient, schema) : SparkMetadataWriterUtils.getUnmergedLogFileRecords(Arrays.stream(paths).map(StoragePath::toString).collect(Collectors.toList()), metaClient, schema);
        return SparkMetadataWriterUtils.toRows(records, schema, dataWriteConfig, sqlContext, paths[0].toString());
    }

    private static java.util.List<HoodieRecord> getUnmergedLogFileRecords(java.util.List<String> logFilePaths, HoodieTableMetaClient metaClient, Schema readerSchema) {
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        HoodieUnMergedLogRecordScanner scanner = ((HoodieUnMergedLogRecordScanner.Builder)HoodieUnMergedLogRecordScanner.newBuilder().withStorage(metaClient.getStorage()).withBasePath(metaClient.getBasePath()).withLogFilePaths((java.util.List)logFilePaths)).withBufferSize(HoodieCommonConfig.MAX_DFS_STREAM_BUFFER_SIZE.defaultValue()).withLatestInstantTime(metaClient.getActiveTimeline().getCommitsTimeline().lastInstant().get().requestedTime()).withReaderSchema(readerSchema).withTableMetaClient(metaClient).withLogRecordScannerCallback(records::add).build();
        scanner.scan(false);
        return records;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static java.util.List<HoodieRecord> getBaseFileRecords(HoodieBaseFile baseFile, HoodieTableMetaClient metaClient, Schema readerSchema) {
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        HoodieRecordMerger recordMerger = HoodieRecordUtils.createRecordMerger(metaClient.getBasePath().toString(), EngineType.SPARK, Collections.emptyList(), metaClient.getTableConfig().getRecordMergeStrategyId());
        try (HoodieFileReader baseFileReader = HoodieIOFactory.getIOFactory(metaClient.getStorage()).getReaderFactory(recordMerger.getRecordType()).getFileReader(ConfigUtils.getReaderConfigs(metaClient.getStorageConf()), baseFile.getStoragePath());){
            baseFileReader.getRecordIterator(readerSchema).forEachRemaining(record -> records.add((HoodieRecord)record));
            ArrayList<HoodieRecord> arrayList = records;
            return arrayList;
        }
        catch (IOException e) {
            throw new HoodieIOException("Error reading base file " + baseFile.getFileName(), e);
        }
    }

    private static java.util.List<Row> toRows(java.util.List<HoodieRecord> records, Schema schema, HoodieWriteConfig dataWriteConfig, SQLContext sqlContext, String path) {
        StructType structType = AvroConversionUtils.convertAvroSchemaToStructType(schema);
        Function1<GenericRecord, Row> converterToRow = AvroConversionUtils.createConverterToRow(schema, structType);
        java.util.List<Row> avroRecords = records.stream().map(r -> {
            try {
                return (GenericRecord)(r.getData() instanceof GenericRecord ? r.getData() : ((HoodieRecordPayload)r.getData()).getInsertValue(schema, dataWriteConfig.getProps()).get());
            }
            catch (IOException e) {
                throw new HoodieIOException("Could not fetch record payload");
            }
        }).map(arg_0 -> converterToRow.apply(arg_0)).collect(Collectors.toList());
        return avroRecords;
    }
}

