/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.validator.SqlQueryPreCommitValidator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQuerySingleResultPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>>
extends SqlQueryPreCommitValidator<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlQuerySingleResultPreCommitValidator.class);

    public SqlQuerySingleResultPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        super(table, engineContext, config);
    }

    @Override
    protected String getQueryConfigName() {
        return HoodiePreCommitValidatorConfig.SINGLE_VALUE_SQL_QUERIES.key();
    }

    @Override
    protected void validateUsingQuery(String query, String prevTableSnapshot, String newTableSnapshot, SQLContext sqlContext) {
        String[] queryWithExpectedResult = query.split("#");
        if (queryWithExpectedResult.length != 2) {
            throw new HoodieValidationException("Invalid query format " + query);
        }
        String queryToRun = queryWithExpectedResult[0];
        String expectedResult = queryWithExpectedResult[1];
        List newRows = this.executeSqlQuery(sqlContext, queryToRun, newTableSnapshot, "new state").collectAsList();
        if (newRows.size() != 1 && ((Row)newRows.get(0)).size() != 1) {
            throw new HoodieValidationException("Invalid query result. expect single value for '" + query + "'");
        }
        Object result2 = ((Row)newRows.get(0)).apply(0);
        if (result2 == null || !expectedResult.equals(result2.toString())) {
            LOG.error("Mismatch query result. Expected: " + expectedResult + " got " + result2 + " on Query: " + query);
            throw new HoodieValidationException("Query validation failed for '" + query + "'. Expected " + expectedResult + " row(s), Found " + result2);
        }
        LOG.info("Query validation successful. Expected: " + expectedResult + " got " + result2);
    }
}

