/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.Counter;
import org.apache.hudi.common.metrics.Registry;

public class LocalRegistry
implements Registry {
    ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    private final String name;

    public LocalRegistry(String name2) {
        this.name = name2;
    }

    @Override
    public void clear() {
        this.counters.clear();
    }

    @Override
    public void increment(String name2) {
        this.getCounter(name2).increment();
    }

    @Override
    public void add(String name2, long value) {
        this.getCounter(name2).add(value);
    }

    @Override
    public void set(String name2, long value) {
        this.getCounter(name2).set(value);
    }

    @Override
    public Map<String, Long> getAllCounts(boolean prefixWithRegistryName) {
        HashMap<String, Long> countersMap = new HashMap<String, Long>();
        this.counters.forEach((k, v) -> {
            String key = prefixWithRegistryName ? this.name + "." + k : k;
            countersMap.put(key, v.getValue());
        });
        return countersMap;
    }

    private synchronized Counter getCounter(String name2) {
        if (!this.counters.containsKey(name2)) {
            this.counters.put(name2, new Counter());
        }
        return this.counters.get(name2);
    }
}

