/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.hudi.common.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieIndexDefinition
implements Serializable {
    private String indexName;
    private String indexType;
    private String indexFunction;
    private List<String> sourceFields;
    private Map<String, String> indexOptions;

    public HoodieIndexDefinition() {
    }

    public HoodieIndexDefinition(String indexName, String indexType, String indexFunction, List<String> sourceFields, Map<String, String> indexOptions) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.indexFunction = StringUtils.nonEmpty(indexFunction) ? indexFunction : "";
        this.sourceFields = sourceFields;
        this.indexOptions = indexOptions;
    }

    public String getIndexFunction() {
        return this.indexFunction;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String toString() {
        return new StringJoiner(", ", HoodieIndexDefinition.class.getSimpleName() + "[", "]").add("indexName='" + this.indexName + "'").add("indexType='" + this.indexType + "'").add("indexFunction='" + this.indexFunction + "'").add("sourceFields=" + this.sourceFields).add("indexOptions=" + this.indexOptions).toString();
    }
}

