/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.table.timeline.SkewAdjustingTimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGeneratorType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StorageConfiguration;

public class TimeGenerators {
    private static final Cache<String, TimeGenerator> TIME_GENERATOR_CACHE = Caffeine.newBuilder().maximumSize(10L).weakValues().build();

    public static TimeGenerator getTimeGenerator(HoodieTimeGeneratorConfig timeGeneratorConfig, StorageConfiguration<?> storageConf) {
        ValidationUtils.checkState(timeGeneratorConfig.contains(HoodieCommonConfig.BASE_PATH), "Option [" + HoodieCommonConfig.BASE_PATH.key() + "] is required");
        ValidationUtils.checkArgument(storageConf != null, "Hadoop configuration is required");
        return TIME_GENERATOR_CACHE.get(timeGeneratorConfig.getBasePath(), s -> {
            TimeGeneratorType type2 = timeGeneratorConfig.getTimeGeneratorType();
            if (Objects.requireNonNull(type2) == TimeGeneratorType.WAIT_TO_ADJUST_SKEW) {
                return new SkewAdjustingTimeGenerator(timeGeneratorConfig, storageConf);
            }
            throw new IllegalArgumentException("Unsupported TimeGenerator Type " + (Object)((Object)type2));
        });
    }
}

