/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.BaseHoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;

public class BaseTimelineV2
extends BaseHoodieTimeline {
    public BaseTimelineV2(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details) {
        this(instants, details, TimelineLayout.fromVersion(TimelineLayoutVersion.LAYOUT_VERSION_2));
    }

    public BaseTimelineV2(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details, TimelineLayout layout) {
        super(instants, details, layout.getTimelineFactory(), layout.getInstantComparator(), layout.getInstantGenerator());
    }

    @Deprecated
    public BaseTimelineV2() {
        super(TimelineLayout.fromVersion(TimelineLayoutVersion.LAYOUT_VERSION_2));
    }

    @Override
    public HoodieTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit", "clustering");
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    @Override
    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return TimelineLayoutVersion.LAYOUT_VERSION_2;
    }

    @Override
    public HoodieTimeline filterPendingClusteringTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("clustering") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingReplaceOrClusteringTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> (s.getAction().equals("clustering") || s.getAction().equals("replacecommit")) && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingReplaceClusteringAndCompactionTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> !s.isCompleted() && (s.getAction().equals("clustering") || s.getAction().equals("replacecommit") || s.getAction().equals("compaction"))), this.details);
    }

    @Override
    public HoodieTimeline getCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit", "clustering"));
    }

    @Override
    public HoodieTimeline getCommitAndReplaceTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "replacecommit", "clustering"));
    }

    @Override
    public Option<HoodieInstant> getLastClusteringInstant() {
        return Option.fromJavaOptional(this.getCommitsTimeline().filter(s -> s.getAction().equalsIgnoreCase("replacecommit") || s.getAction().equalsIgnoreCase("clustering")).getReverseOrderedInstants().filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i, this.instantGenerator)).findFirst());
    }

    @Override
    public Option<HoodieInstant> getFirstPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(false);
    }

    @Override
    public Option<HoodieInstant> getLastPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(true);
    }

    private Option<HoodieInstant> getLastOrFirstPendingClusterInstant(boolean isLast) {
        HoodieTimeline pendingClusteringTimeline = this.filterPendingReplaceOrClusteringTimeline();
        Stream<HoodieInstant> clusterStream = isLast ? pendingClusteringTimeline.getReverseOrderedInstants() : pendingClusteringTimeline.getInstantsAsStream();
        return Option.fromJavaOptional(clusterStream.filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i, this.instantGenerator)).findFirst());
    }

    @Override
    public boolean isPendingClusteringInstant(String instantTime) {
        return this.getOrCreatePendingClusteringInstantSet().contains(instantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrCreatePendingClusteringInstantSet() {
        if (this.pendingClusteringInstants == null) {
            BaseTimelineV2 baseTimelineV2 = this;
            synchronized (baseTimelineV2) {
                if (this.pendingClusteringInstants == null) {
                    List<HoodieInstant> pendingClusterInstants = this.getCommitsTimeline().filterPendingReplaceOrClusteringTimeline().getInstants();
                    pendingClusterInstants.stream().collect(Collectors.groupingBy(HoodieInstant::requestedTime)).forEach((timestamp, instants) -> {
                        if (instants.size() > 1) {
                            throw new IllegalStateException("Multiple instants with same timestamp: " + timestamp + " instants: " + instants);
                        }
                    });
                    this.pendingClusteringInstants = pendingClusterInstants.stream().filter((? super T instant) -> ClusteringUtils.isClusteringInstant(this, instant, this.instantGenerator)).map(HoodieInstant::requestedTime).collect(Collectors.toSet());
                }
            }
        }
        return this.pendingClusteringInstants;
    }
}

