/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.hudi.index.bloom.KeyRangeNode;

class KeyRangeLookupTree
implements Serializable {
    private KeyRangeNode root;

    KeyRangeLookupTree() {
    }

    public KeyRangeNode getRoot() {
        return this.root;
    }

    void insert(KeyRangeNode newNode) {
        this.root = this.insert(this.getRoot(), newNode);
    }

    private KeyRangeNode insert(KeyRangeNode root, KeyRangeNode newNode) {
        if (root == null) {
            root = newNode;
            return root;
        }
        if (root.compareTo(newNode) == 0) {
            root.addFiles(newNode.getFileNameList());
            return root;
        }
        if (root.compareTo(newNode) < 0) {
            if (root.getRight() == null) {
                root.setRightSubTreeMax(newNode.getMaxRecordKey());
                root.setRightSubTreeMin(newNode.getMinRecordKey());
                root.setRight(newNode);
            } else {
                root.setRightSubTreeMax(KeyRangeLookupTree.max(root.getRightSubTreeMax(), newNode.getMaxRecordKey()));
                root.setRightSubTreeMin(KeyRangeLookupTree.min(root.getRightSubTreeMin(), newNode.getMinRecordKey()));
                this.insert(root.getRight(), newNode);
            }
        } else if (root.getLeft() == null) {
            root.setLeftSubTreeMax(newNode.getMaxRecordKey());
            root.setLeftSubTreeMin(newNode.getMinRecordKey());
            root.setLeft(newNode);
        } else {
            root.setLeftSubTreeMax(KeyRangeLookupTree.max(root.getLeftSubTreeMax(), newNode.getMaxRecordKey()));
            root.setLeftSubTreeMin(KeyRangeLookupTree.min(root.getLeftSubTreeMin(), newNode.getMinRecordKey()));
            this.insert(root.getLeft(), newNode);
        }
        return root;
    }

    private static String max(String a, String b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    private static String min(String a, String b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    Set<String> getMatchingIndexFiles(String lookupKey) {
        HashSet<String> matchingFileNameSet = new HashSet<String>();
        this.getMatchingIndexFiles(this.getRoot(), lookupKey, matchingFileNameSet);
        return matchingFileNameSet;
    }

    private void getMatchingIndexFiles(KeyRangeNode root, String lookupKey, Set<String> matchingFileNameSet) {
        if (root == null) {
            return;
        }
        if (root.getMinRecordKey().compareTo(lookupKey) <= 0 && lookupKey.compareTo(root.getMaxRecordKey()) <= 0) {
            matchingFileNameSet.addAll(root.getFileNameList());
        }
        if (root.getLeftSubTreeMax() != null && root.getLeftSubTreeMin().compareTo(lookupKey) <= 0 && lookupKey.compareTo(root.getLeftSubTreeMax()) <= 0) {
            this.getMatchingIndexFiles(root.getLeft(), lookupKey, matchingFileNameSet);
        }
        if (root.getRightSubTreeMax() != null && root.getRightSubTreeMin().compareTo(lookupKey) <= 0 && lookupKey.compareTo(root.getRightSubTreeMax()) <= 0) {
            this.getMatchingIndexFiles(root.getRight(), lookupKey, matchingFileNameSet);
        }
    }
}

