/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.secondary;

import java.util.Arrays;
import org.apache.hudi.exception.HoodieIndexException;

public enum SecondaryIndexType {
    LUCENE(1);

    private final byte type;

    private SecondaryIndexType(byte type2) {
        this.type = type2;
    }

    public byte getValue() {
        return this.type;
    }

    public static SecondaryIndexType of(byte indexType) {
        return Arrays.stream(SecondaryIndexType.values()).filter(t -> t.type == indexType).findAny().orElseThrow(() -> new HoodieIndexException("Unknown hoodie index type:" + indexType));
    }

    public static SecondaryIndexType of(String indexType) {
        return Arrays.stream(SecondaryIndexType.values()).filter(t -> t.name().equals(indexType.toUpperCase())).findAny().orElseThrow(() -> new HoodieIndexException("Unknown hoodie index type:" + indexType));
    }
}

