/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class InternalSchemaMerger {
    private final InternalSchema fileSchema;
    private final InternalSchema querySchema;
    private final boolean ignoreRequiredAttribute;
    private boolean useColumnTypeFromFileSchema = true;
    private boolean useColNameFromFileSchema = true;
    private final Map<String, String> renamedFields = new HashMap<String, String>();

    public InternalSchemaMerger(InternalSchema fileSchema, InternalSchema querySchema, boolean ignoreRequiredAttribute, boolean useColumnTypeFromFileSchema, boolean useColNameFromFileSchema) {
        this.fileSchema = fileSchema;
        this.querySchema = querySchema;
        this.ignoreRequiredAttribute = ignoreRequiredAttribute;
        this.useColumnTypeFromFileSchema = useColumnTypeFromFileSchema;
        this.useColNameFromFileSchema = useColNameFromFileSchema;
    }

    public InternalSchemaMerger(InternalSchema fileSchema, InternalSchema querySchema, boolean ignoreRequiredAttribute, boolean useColumnTypeFromFileSchema) {
        this(fileSchema, querySchema, ignoreRequiredAttribute, useColumnTypeFromFileSchema, true);
    }

    public InternalSchema mergeSchema() {
        Types.RecordType record = (Types.RecordType)this.mergeType(this.querySchema.getRecord(), 0);
        return new InternalSchema(record);
    }

    public Pair<InternalSchema, Map<String, String>> mergeSchemaGetRenamed() {
        return Pair.of(this.mergeSchema(), this.renamedFields);
    }

    private Type mergeType(Type type2, int currentTypeId) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                ArrayList<Type> newTypes = new ArrayList<Type>();
                for (Types.Field f : record.fields()) {
                    Type newType = this.mergeType(f.type(), f.fieldId());
                    newTypes.add(newType);
                }
                return Types.RecordType.get(this.buildRecordType(record.fields(), newTypes));
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type2;
                Types.Field elementField = array.fields().get(0);
                Type newElementType = this.mergeType(elementField.type(), elementField.fieldId());
                return this.buildArrayType(array, newElementType);
            }
            case MAP: {
                Types.MapType map2 = (Types.MapType)type2;
                Type newValueType = this.mergeType(map2.valueType(), map2.valueId());
                return this.buildMapType(map2, newValueType);
            }
        }
        return this.buildPrimitiveType((Type.PrimitiveType)type2, currentTypeId);
    }

    private List<Types.Field> buildRecordType(List<Types.Field> oldFields, List<Type> newTypes) {
        ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
        for (int i = 0; i < newTypes.size(); ++i) {
            Type newType = newTypes.get(i);
            Types.Field oldField = oldFields.get(i);
            int fieldId = oldField.fieldId();
            String fullName = this.querySchema.findFullName(fieldId);
            if (this.fileSchema.findField(fieldId) != null) {
                if (this.fileSchema.findFullName(fieldId).equals(fullName)) {
                    newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name(), newType, oldField.doc()));
                    continue;
                }
                newFields.add(this.dealWithRename(fieldId, newType, oldField));
                continue;
            }
            if (this.fileSchema.findField(fullName = this.normalizeFullName(fullName)) != null) {
                newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name() + "suffix", oldField.type(), oldField.doc()));
                continue;
            }
            if (this.ignoreRequiredAttribute) {
                newFields.add(Types.Field.get(oldField.fieldId(), true, oldField.name(), newType, oldField.doc()));
                continue;
            }
            newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name(), newType, oldField.doc()));
        }
        return newFields;
    }

    private Types.Field dealWithRename(int fieldId, Type newType, Types.Field oldField) {
        Types.Field fieldFromFileSchema = this.fileSchema.findField(fieldId);
        String nameFromFileSchema = fieldFromFileSchema.name();
        String nameFromQuerySchema = this.querySchema.findField(fieldId).name();
        String finalFieldName = this.useColNameFromFileSchema ? nameFromFileSchema : nameFromQuerySchema;
        Type typeFromFileSchema = fieldFromFileSchema.type();
        if (!this.useColNameFromFileSchema) {
            this.renamedFields.put(nameFromQuerySchema, nameFromFileSchema);
        }
        if (newType.isNestedType()) {
            return Types.Field.get(oldField.fieldId(), oldField.isOptional(), finalFieldName, newType, oldField.doc());
        }
        return Types.Field.get(oldField.fieldId(), oldField.isOptional(), finalFieldName, this.useColumnTypeFromFileSchema ? typeFromFileSchema : newType, oldField.doc());
    }

    private String normalizeFullName(String fullName) {
        String[] nameParts = fullName.split("\\.");
        String[] normalizedNameParts = new String[nameParts.length];
        System.arraycopy(nameParts, 0, normalizedNameParts, 0, nameParts.length);
        for (int j = 0; j < nameParts.length - 1; ++j) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k <= j; ++k) {
                sb.append(nameParts[k]);
            }
            String parentName = sb.toString();
            int parentFieldIdFromQuerySchema = this.querySchema.findIdByName(parentName);
            String parentNameFromFileSchema = this.fileSchema.findFullName(parentFieldIdFromQuerySchema);
            if (parentNameFromFileSchema.isEmpty()) break;
            if (parentNameFromFileSchema.equalsIgnoreCase(parentName)) continue;
            String[] parentNameParts = parentNameFromFileSchema.split("\\.");
            System.arraycopy(parentNameParts, 0, normalizedNameParts, 0, parentNameParts.length);
        }
        return StringUtils.join(normalizedNameParts, ".");
    }

    private Type buildArrayType(Types.ArrayType array, Type newType) {
        Types.Field elementField = array.fields().get(0);
        int elementId = elementField.fieldId();
        if (elementField.type() == newType) {
            return array;
        }
        return Types.ArrayType.get(elementId, elementField.isOptional(), newType);
    }

    private Type buildMapType(Types.MapType map2, Type newValue) {
        Types.Field valueFiled = map2.fields().get(1);
        if (valueFiled.type() == newValue) {
            return map2;
        }
        return Types.MapType.get(map2.keyId(), map2.valueId(), map2.keyType(), newValue, map2.isValueOptional());
    }

    private Type buildPrimitiveType(Type.PrimitiveType typeFromQuerySchema, int currentPrimitiveTypeId) {
        Type typeFromFileSchema = this.fileSchema.findType(currentPrimitiveTypeId);
        if (typeFromFileSchema == null) {
            return typeFromQuerySchema;
        }
        return this.useColumnTypeFromFileSchema ? typeFromFileSchema : typeFromQuerySchema;
    }
}

