/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChange;

public class TableChangesHelper {
    public static List<Types.Field> applyAddChange2Fields(List<Types.Field> fields2, ArrayList<Types.Field> adds, ArrayList<TableChange.ColumnPositionChange> pchanges) {
        if (adds == null && pchanges == null) {
            return fields2;
        }
        LinkedList<Types.Field> result2 = new LinkedList<Types.Field>(fields2);
        if (adds != null && !adds.isEmpty()) {
            result2.addAll(adds);
        }
        if (pchanges != null && !pchanges.isEmpty()) {
            for (TableChange.ColumnPositionChange pchange : pchanges) {
                Types.Field srcField = result2.stream().filter(f -> f.fieldId() == pchange.getSrcId()).findFirst().get();
                Types.Field dsrField = result2.stream().filter(f -> f.fieldId() == pchange.getDsrId()).findFirst().orElse(null);
                result2.remove(srcField);
                switch (pchange.type()) {
                    case AFTER: {
                        result2.add(result2.indexOf(dsrField) + 1, srcField);
                        break;
                    }
                    case BEFORE: {
                        result2.add(result2.indexOf(dsrField), srcField);
                        break;
                    }
                    case FIRST: {
                        result2.addFirst(srcField);
                        break;
                    }
                }
            }
        }
        return result2;
    }

    public static String getParentName(String fullColName) {
        int offset = fullColName.lastIndexOf(".");
        return offset > 0 ? fullColName.substring(0, offset) : "";
    }

    public static String getLeafName(String fullColName) {
        int offset = fullColName.lastIndexOf(".");
        return offset > 0 ? fullColName.substring(offset + 1) : fullColName;
    }
}

