/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CompoundBloomFilterBase;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Hash;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompoundBloomFilter
extends CompoundBloomFilterBase
implements BloomFilter {
    private HFile.Reader reader;
    private HFileBlockIndex.BlockIndexReader index;
    private int hashCount;
    private Hash hash;
    private long[] numQueriesPerChunk;
    private long[] numPositivesPerChunk;

    public CompoundBloomFilter(DataInput meta, HFile.Reader reader) throws IOException {
        this.reader = reader;
        this.totalByteSize = meta.readLong();
        this.hashCount = meta.readInt();
        this.hashType = meta.readInt();
        this.totalKeyCount = meta.readLong();
        this.totalMaxKeys = meta.readLong();
        this.numChunks = meta.readInt();
        byte[] comparatorClassName = Bytes.readByteArray(meta);
        if (comparatorClassName.length != 0) {
            this.comparator = FixedFileTrailer.createComparator(Bytes.toString(comparatorClassName));
        }
        this.hash = Hash.getInstance(this.hashType);
        if (this.hash == null) {
            throw new IllegalArgumentException("Invalid hash type: " + this.hashType);
        }
        this.index = this.comparator == null ? new HFileBlockIndex.ByteArrayKeyBlockIndexReader(1) : new HFileBlockIndex.CellBasedKeyBlockIndexReader(this.comparator, 1);
        this.index.readRootIndex(meta, this.numChunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(byte[] key, int keyOffset, int keyLength, ByteBuff bloom) {
        boolean result2;
        int block = this.index.rootBlockContainingKey(key, keyOffset, keyLength);
        if (block < 0) {
            return false;
        }
        HFileBlock bloomBlock = this.getBloomBlock(block);
        try {
            ByteBuff bloomBuf = bloomBlock.getBufferReadOnly();
            result2 = BloomFilterUtil.contains(key, keyOffset, keyLength, bloomBuf, bloomBlock.headerSize(), bloomBlock.getUncompressedSizeWithoutHeader(), this.hash, this.hashCount);
        }
        finally {
            bloomBlock.release();
        }
        if (this.numPositivesPerChunk != null && result2) {
            int n = block;
            this.numPositivesPerChunk[n] = this.numPositivesPerChunk[n] + 1L;
        }
        return result2;
    }

    private HFileBlock getBloomBlock(int block) {
        HFileBlock bloomBlock;
        try {
            bloomBlock = this.reader.readBlock(this.index.getRootBlockOffset(block), this.index.getRootBlockDataSize(block), true, true, false, true, BlockType.BLOOM_CHUNK, null);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to load Bloom block", ex);
        }
        if (this.numQueriesPerChunk != null) {
            int n = block;
            this.numQueriesPerChunk[n] = this.numQueriesPerChunk[n] + 1L;
        }
        return bloomBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Cell keyCell, ByteBuff bloom, BloomType type2) {
        boolean result2;
        int block = this.index.rootBlockContainingKey(keyCell);
        if (block < 0) {
            return false;
        }
        HFileBlock bloomBlock = this.getBloomBlock(block);
        try {
            ByteBuff bloomBuf = bloomBlock.getBufferReadOnly();
            result2 = BloomFilterUtil.contains(keyCell, bloomBuf, bloomBlock.headerSize(), bloomBlock.getUncompressedSizeWithoutHeader(), this.hash, this.hashCount, type2);
        }
        finally {
            bloomBlock.release();
        }
        if (this.numPositivesPerChunk != null && result2) {
            int n = block;
            this.numPositivesPerChunk[n] = this.numPositivesPerChunk[n] + 1L;
        }
        return result2;
    }

    @Override
    public boolean supportsAutoLoading() {
        return true;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public void enableTestingStats() {
        this.numQueriesPerChunk = new long[this.numChunks];
        this.numPositivesPerChunk = new long[this.numChunks];
    }

    public String formatTestingStats() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numChunks; ++i) {
            sb.append("chunk #");
            sb.append(i);
            sb.append(": queries=");
            sb.append(this.numQueriesPerChunk[i]);
            sb.append(", positives=");
            sb.append(this.numPositivesPerChunk[i]);
            sb.append(", positiveRatio=");
            sb.append((double)this.numPositivesPerChunk[i] * 1.0 / (double)this.numQueriesPerChunk[i]);
            sb.append(";\n");
        }
        return sb.toString();
    }

    public long getNumQueriesForTesting(int chunk) {
        return this.numQueriesPerChunk[chunk];
    }

    public long getNumPositivesForTesting(int chunk) {
        return this.numPositivesPerChunk[chunk];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BloomFilterUtil.formatStats(this));
        sb.append("; Number of chunks: " + this.numChunks);
        sb.append("; " + (this.comparator != null ? "Comparator: " + this.comparator.getClass().getSimpleName() : "Comparator: " + Bytes.BYTES_RAWCOMPARATOR.getClass().getSimpleName()));
        return sb.toString();
    }
}

