/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hudi.org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExpiredMobFileCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredMobFileCleanerChore.class);
    private final HMaster master;
    private ExpiredMobFileCleaner cleaner;

    public ExpiredMobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-ExpiredMobFileCleanerChore", master, master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), TimeUnit.SECONDS);
        this.master = master;
        this.cleaner = new ExpiredMobFileCleaner();
        this.cleaner.setConf(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, TableDescriptor> map2 = htds.getAll();
            for (TableDescriptor htd : map2.values()) {
                for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                    if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                    LockManager.MasterLock lock = this.master.getLockManager().createMasterLock(MobUtils.getTableLockName(htd.getTableName()), LockType.SHARED, this.getClass().getSimpleName() + ": Cleaning expired mob files");
                    try {
                        lock.acquire();
                        this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                    }
                    finally {
                        lock.release();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Fail to clean the expired mob files", (Throwable)e);
        }
    }
}

