/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultOperationQuota
implements OperationQuota {
    protected final List<QuotaLimiter> limiters;
    private final long writeCapacityUnit;
    private final long readCapacityUnit;
    protected long readAvailable = 0L;
    protected long writeConsumed = 0L;
    protected long readConsumed = 0L;
    protected long writeCapacityUnitConsumed = 0L;
    protected long readCapacityUnitConsumed = 0L;
    private final long[] operationSize;
    protected long writeDiff = 0L;
    protected long readDiff = 0L;
    protected long writeCapacityUnitDiff = 0L;
    protected long readCapacityUnitDiff = 0L;

    public DefaultOperationQuota(Configuration conf, QuotaLimiter ... limiters) {
        this(conf, Arrays.asList(limiters));
    }

    public DefaultOperationQuota(Configuration conf, List<QuotaLimiter> limiters) {
        this.writeCapacityUnit = conf.getLong("hbase.quota.write.capacity.unit", 1024L);
        this.readCapacityUnit = conf.getLong("hbase.quota.read.capacity.unit", 1024L);
        this.limiters = limiters;
        int size = OperationQuota.OperationType.values().length;
        this.operationSize = new long[size];
        for (int i = 0; i < size; ++i) {
            this.operationSize[i] = 0L;
        }
    }

    @Override
    public void checkQuota(int numWrites, int numReads, int numScans) throws RpcThrottlingException {
        this.updateEstimateConsumeQuota(numWrites, numReads, numScans);
        this.readAvailable = Long.MAX_VALUE;
        for (QuotaLimiter limiter : this.limiters) {
            if (limiter.isBypass()) continue;
            limiter.checkQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed);
            this.readAvailable = Math.min(this.readAvailable, limiter.getReadAvailable());
        }
        for (QuotaLimiter limiter : this.limiters) {
            limiter.grabQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed);
        }
    }

    @Override
    public void close() {
        this.writeDiff = this.operationSize[OperationQuota.OperationType.MUTATE.ordinal()] - this.writeConsumed;
        this.readDiff = this.operationSize[OperationQuota.OperationType.GET.ordinal()] + this.operationSize[OperationQuota.OperationType.SCAN.ordinal()] - this.readConsumed;
        this.writeCapacityUnitDiff = this.calculateWriteCapacityUnitDiff(this.operationSize[OperationQuota.OperationType.MUTATE.ordinal()], this.writeConsumed);
        this.readCapacityUnitDiff = this.calculateReadCapacityUnitDiff(this.operationSize[OperationQuota.OperationType.GET.ordinal()] + this.operationSize[OperationQuota.OperationType.SCAN.ordinal()], this.readConsumed);
        for (QuotaLimiter limiter : this.limiters) {
            if (this.writeDiff != 0L) {
                limiter.consumeWrite(this.writeDiff, this.writeCapacityUnitDiff);
            }
            if (this.readDiff == 0L) continue;
            limiter.consumeRead(this.readDiff, this.readCapacityUnitDiff);
        }
    }

    @Override
    public long getReadAvailable() {
        return this.readAvailable;
    }

    @Override
    public void addGetResult(Result result2) {
        int n = OperationQuota.OperationType.GET.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(result2);
    }

    @Override
    public void addScanResult(List<Result> results) {
        int n = OperationQuota.OperationType.SCAN.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(results);
    }

    @Override
    public void addMutation(Mutation mutation) {
        int n = OperationQuota.OperationType.MUTATE.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateMutationSize(mutation);
    }

    protected void updateEstimateConsumeQuota(int numWrites, int numReads, int numScans) {
        this.writeConsumed = this.estimateConsume(OperationQuota.OperationType.MUTATE, numWrites, 100L);
        this.readConsumed = this.estimateConsume(OperationQuota.OperationType.GET, numReads, 100L);
        this.readConsumed += this.estimateConsume(OperationQuota.OperationType.SCAN, numScans, 1000L);
        this.writeCapacityUnitConsumed = this.calculateWriteCapacityUnit(this.writeConsumed);
        this.readCapacityUnitConsumed = this.calculateReadCapacityUnit(this.readConsumed);
    }

    private long estimateConsume(OperationQuota.OperationType type2, int numReqs, long avgSize) {
        if (numReqs > 0) {
            return avgSize * (long)numReqs;
        }
        return 0L;
    }

    private long calculateWriteCapacityUnit(long size) {
        return (long)Math.ceil((double)size * 1.0 / (double)this.writeCapacityUnit);
    }

    private long calculateReadCapacityUnit(long size) {
        return (long)Math.ceil((double)size * 1.0 / (double)this.readCapacityUnit);
    }

    private long calculateWriteCapacityUnitDiff(long actualSize, long estimateSize) {
        return this.calculateWriteCapacityUnit(actualSize) - this.calculateWriteCapacityUnit(estimateSize);
    }

    private long calculateReadCapacityUnitDiff(long actualSize, long estimateSize) {
        return this.calculateReadCapacityUnit(actualSize) - this.calculateReadCapacityUnit(estimateSize);
    }
}

