/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractMultiFileWriter
implements CellSink,
ShipperListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMultiFileWriter.class);
    protected WriterFactory writerFactory;
    protected StoreScanner sourceScanner;

    public void init(StoreScanner sourceScanner, WriterFactory factory) {
        this.writerFactory = factory;
        this.sourceScanner = sourceScanner;
    }

    public List<Path> commitWriters(long maxSeqId, boolean majorCompaction) throws IOException {
        return this.commitWriters(maxSeqId, majorCompaction, Collections.EMPTY_SET);
    }

    public List<Path> commitWriters(long maxSeqId, boolean majorCompaction, Collection<HStoreFile> storeFiles) throws IOException {
        this.preCommitWriters();
        Collection<StoreFileWriter> writers = this.writers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit " + writers.size() + " writers, maxSeqId=" + maxSeqId + ", majorCompaction=" + majorCompaction);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (StoreFileWriter writer : writers) {
            if (writer == null) continue;
            writer.appendMetadata(maxSeqId, majorCompaction, storeFiles);
            this.preCloseWriter(writer);
            paths.add(writer.getPath());
            writer.close();
        }
        return paths;
    }

    public List<Path> abortWriters() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (StoreFileWriter writer : this.writers()) {
            try {
                if (writer == null) continue;
                paths.add(writer.getPath());
                writer.close();
            }
            catch (Exception ex) {
                LOG.error("Failed to close the writer after an unfinished compaction.", (Throwable)ex);
            }
        }
        return paths;
    }

    protected abstract Collection<StoreFileWriter> writers();

    protected void preCommitWriters() throws IOException {
    }

    protected void preCloseWriter(StoreFileWriter writer) throws IOException {
    }

    @Override
    public void beforeShipped() throws IOException {
        Collection<StoreFileWriter> writers = this.writers();
        if (writers != null) {
            for (StoreFileWriter writer : writers) {
                if (writer == null) continue;
                writer.beforeShipped();
            }
        }
    }

    public static interface WriterFactory {
        public StoreFileWriter createWriter() throws IOException;

        default public StoreFileWriter createWriterWithStoragePolicy(String fileStoragePolicy) throws IOException {
            return this.createWriter();
        }
    }
}

