/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class Counter {
    private static final int MAX_CELLS_LENGTH = 0x100000;
    private final AtomicReference<Container> containerRef;

    public Counter() {
        this(new Cell());
    }

    public Counter(long initValue) {
        this(new Cell(initValue));
    }

    private Counter(Cell initCell) {
        this.containerRef = new AtomicReference<Container>(new Container(initCell));
    }

    private static int hash() {
        int h = System.identityHashCode(Thread.currentThread());
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h;
    }

    public void add(long delta) {
        Container container2 = this.containerRef.get();
        Cell[] cells = container2.cells;
        int mask = cells.length - 1;
        int baseIndex = Counter.hash();
        if (cells[baseIndex & mask].add(delta)) {
            return;
        }
        int index = baseIndex + 1;
        while (!cells[index & mask].add(delta)) {
            ++index;
        }
        if (index - baseIndex >= cells.length && cells.length < 0x100000 && container2.demoted.compareAndSet(false, true) && this.containerRef.get() == container2) {
            Cell[] newCells = new Cell[cells.length * 2];
            System.arraycopy(cells, 0, newCells, 0, cells.length);
            for (int i = cells.length; i < newCells.length; ++i) {
                newCells[i] = new Cell();
            }
            this.containerRef.compareAndSet(container2, new Container(newCells));
        }
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public void set(long value) {
        this.containerRef.set(new Container(new Cell(value)));
    }

    public long get() {
        long sum = 0L;
        for (Cell cell : this.containerRef.get().cells) {
            sum += cell.get();
        }
        return sum;
    }

    public String toString() {
        Cell[] cells = this.containerRef.get().cells;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        for (Cell cell : cells) {
            long value = cell.get();
            sum += value;
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        return new StringBuilder(100).append("[value=").append(sum).append(", cells=[length=").append(cells.length).append(", min=").append(min).append(", max=").append(max).append("]]").toString();
    }

    private static class Container {
        final Cell[] cells;
        final AtomicBoolean demoted = new AtomicBoolean();

        Container(Cell cell) {
            this(new Cell[]{cell});
        }

        Container(Cell[] cells) {
            this.cells = cells;
        }
    }

    private static class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        static final AtomicLongFieldUpdater<Cell> valueUpdater = AtomicLongFieldUpdater.newUpdater(Cell.class, "value");

        Cell() {
        }

        Cell(long initValue) {
            this.value = initValue;
        }

        long get() {
            return this.value;
        }

        boolean add(long delta) {
            long current = this.value;
            return valueUpdater.compareAndSet(this, current, current + delta);
        }
    }
}

