/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.http.cookie;

import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.http.cookie.CookieUtil;

public abstract class CookieEncoder {
    protected final boolean strict;

    protected CookieEncoder(boolean strict) {
        this.strict = strict;
    }

    protected void validateCookie(String name2, String value) {
        if (this.strict) {
            int pos = CookieUtil.firstInvalidCookieNameOctet(name2);
            if (pos >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + name2.charAt(pos));
            }
            CharSequence unwrappedValue = CookieUtil.unwrapValue(value);
            if (unwrappedValue == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + value);
            }
            pos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue);
            if (pos >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + unwrappedValue.charAt(pos));
            }
        }
    }
}

