/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.socks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.ReplayingDecoder;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.socks.SocksAuthScheme;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.socks.SocksCommonUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.socks.SocksInitRequest;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.socks.SocksProtocolVersion;

public class SocksInitRequestDecoder
extends ReplayingDecoder<State> {
    public SocksInitRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    out.add(SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.checkpoint(State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                List<SocksAuthScheme> authSchemes;
                int authSchemeNum = byteBuf.readByte();
                if (authSchemeNum > 0) {
                    authSchemes = new ArrayList(authSchemeNum);
                    for (int i = 0; i < authSchemeNum; ++i) {
                        authSchemes.add(SocksAuthScheme.valueOf(byteBuf.readByte()));
                    }
                } else {
                    authSchemes = Collections.emptyList();
                }
                out.add(new SocksInitRequest(authSchemes));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove(this);
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

