/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent;

import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocalRunnable;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.InternalThreadLocalMap;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public class FastThreadLocalThread
extends Thread {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FastThreadLocalThread.class);
    private final boolean cleanupFastThreadLocals;
    private InternalThreadLocalMap threadLocalMap;

    public FastThreadLocalThread() {
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(Runnable target) {
        super(FastThreadLocalRunnable.wrap(target));
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target) {
        super(group, FastThreadLocalRunnable.wrap(target));
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(String name2) {
        super(name2);
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(ThreadGroup group, String name2) {
        super(group, name2);
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(Runnable target, String name2) {
        super(FastThreadLocalRunnable.wrap(target), name2);
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name2) {
        super(group, FastThreadLocalRunnable.wrap(target), name2);
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name2, long stackSize) {
        super(group, FastThreadLocalRunnable.wrap(target), name2, stackSize);
        this.cleanupFastThreadLocals = true;
    }

    public final InternalThreadLocalMap threadLocalMap() {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to get 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        return this.threadLocalMap;
    }

    public final void setThreadLocalMap(InternalThreadLocalMap threadLocalMap) {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to set 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        this.threadLocalMap = threadLocalMap;
    }

    public boolean willCleanupFastThreadLocals() {
        return this.cleanupFastThreadLocals;
    }

    public static boolean willCleanupFastThreadLocals(Thread thread2) {
        return thread2 instanceof FastThreadLocalThread && ((FastThreadLocalThread)thread2).willCleanupFastThreadLocals();
    }
}

