/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.core;

import java.util.concurrent.Callable;
import org.apache.hudi.org.apache.htrace.core.SpanId;
import org.apache.hudi.org.apache.htrace.core.TraceScope;
import org.apache.hudi.org.apache.htrace.core.Tracer;

public class TraceCallable<V>
implements Callable<V> {
    private final Tracer tracer;
    private final Callable<V> impl;
    private final SpanId parentId;
    private final String description;

    public TraceCallable(Tracer tracer, SpanId parentId, Callable<V> impl, String description2) {
        this.tracer = tracer;
        this.impl = impl;
        this.parentId = parentId;
        this.description = description2;
    }

    @Override
    public V call() throws Exception {
        String description2 = this.description;
        if (description2 == null) {
            description2 = Thread.currentThread().getName();
        }
        try (TraceScope chunk = this.tracer.newScope(description2, this.parentId);){
            V v = this.impl.call();
            return v;
        }
    }

    public Callable<V> getImpl() {
        return this.impl;
    }
}

