/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonLocation;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.AbstractTypeResolver;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.PropertyMetadata;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.AbstractDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.CreatorProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.DeserializerFactory;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.Deserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.KeyDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.ValueInstantiator;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.ValueInstantiators;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.DateDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.JsonLocationInstantiator;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.MapDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StringDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.VisibilityChecker;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.ArrayType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionLikeType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.EnumResolver;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.NameTransformer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.TokenBuffer;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_BUFFER = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig config) {
        this._factoryConfig = config;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(additional));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(additional));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(modifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver resolver2) {
        return this.withConfig(this._factoryConfig.withAbstractTypeResolver(resolver2));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators instantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(instantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig config, JavaType type2) throws JsonMappingException {
        JavaType next;
        while ((next = this._mapAbstractType2(config, type2)) != null) {
            Class<?> nextCls;
            Class<?> prevCls = type2.getRawClass();
            if (prevCls == (nextCls = next.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + type2 + " to " + next + ": latter is not a subtype of former");
            }
            type2 = next;
        }
        return type2;
    }

    private JavaType _mapAbstractType2(DeserializationConfig config, JavaType type2) throws JsonMappingException {
        Class<?> currClass = type2.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver resolver2 : this._factoryConfig.abstractTypeResolvers()) {
                JavaType concrete = resolver2.findTypeMapping(config, type2);
                if (concrete == null || concrete.getRawClass() == currClass) continue;
                return concrete;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext ctxt, BeanDescription beanDesc) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        ValueInstantiator instantiator = null;
        AnnotatedClass ac = beanDesc.getClassInfo();
        Object instDef = ctxt.getAnnotationIntrospector().findValueInstantiator(ac);
        if (instDef != null) {
            instantiator = this._valueInstantiatorInstance(config, ac, instDef);
        }
        if (instantiator == null && (instantiator = this._findStdValueInstantiator(config, beanDesc)) == null) {
            instantiator = this._constructDefaultValueInstantiator(ctxt, beanDesc);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators insts : this._factoryConfig.valueInstantiators()) {
                instantiator = insts.findValueInstantiator(config, beanDesc, instantiator);
                if (instantiator != null) continue;
                throw new JsonMappingException("Broken registered ValueInstantiators (of type " + insts.getClass().getName() + "): returned null ValueInstantiator");
            }
        }
        if (instantiator.getIncompleteParameter() != null) {
            AnnotatedParameter nonAnnotatedParam = instantiator.getIncompleteParameter();
            AnnotatedWithParams ctor = nonAnnotatedParam.getOwner();
            throw new IllegalArgumentException("Argument #" + nonAnnotatedParam.getIndex() + " of constructor " + ctor + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
        }
        return instantiator;
    }

    private ValueInstantiator _findStdValueInstantiator(DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (beanDesc.getBeanClass() == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        return null;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext ctxt, BeanDescription beanDesc) throws JsonMappingException {
        boolean fixAccess = ctxt.canOverrideAccessModifiers();
        CreatorCollector creators = new CreatorCollector(beanDesc, fixAccess);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        DeserializationConfig config = ctxt.getConfig();
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        vchecker = intr.findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        this._addDeserializerFactoryMethods(ctxt, beanDesc, vchecker, intr, creators);
        if (beanDesc.getType().isConcrete()) {
            this._addDeserializerConstructors(ctxt, beanDesc, vchecker, intr, creators);
        }
        return creators.constructValueInstantiator(config);
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig config, Annotated annotated, Object instDef) throws JsonMappingException {
        ValueInstantiator inst;
        if (instDef == null) {
            return null;
        }
        if (instDef instanceof ValueInstantiator) {
            return (ValueInstantiator)instDef;
        }
        if (!(instDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + instDef.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        Class instClass = (Class)instDef;
        if (ClassUtil.isBogusClass(instClass)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom(instClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + instClass.getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator hi = config.getHandlerInstantiator();
        if (hi != null && (inst = hi.valueInstantiatorInstance(config, annotated, instClass)) != null) {
            return inst;
        }
        return (ValueInstantiator)ClassUtil.createInstance(instClass, config.canOverrideAccessModifiers());
    }

    protected void _addDeserializerConstructors(DeserializationContext ctxt, BeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        AnnotatedConstructor defaultCtor = beanDesc.findDefaultConstructor();
        if (defaultCtor != null && (!creators.hasDefaultCreator() || intr.hasCreatorAnnotation(defaultCtor))) {
            creators.setDefaultCreator(defaultCtor);
        }
        PropertyName[] ctorPropNames = null;
        AnnotatedConstructor propertyCtor = null;
        for (BeanPropertyDefinition propDef : beanDesc.findProperties()) {
            AnnotatedParameter param;
            AnnotatedWithParams owner;
            if (propDef.getConstructorParameter() == null || !((owner = (param = propDef.getConstructorParameter()).getOwner()) instanceof AnnotatedConstructor)) continue;
            if (propertyCtor == null) {
                propertyCtor = (AnnotatedConstructor)owner;
                ctorPropNames = new PropertyName[propertyCtor.getParameterCount()];
            }
            ctorPropNames[param.getIndex()] = propDef.getFullName();
        }
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            int argCount = ctor.getParameterCount();
            boolean isCreator = intr.hasCreatorAnnotation(ctor) || ctor == propertyCtor;
            boolean isVisible = vchecker.isCreatorVisible(ctor);
            if (argCount == 1) {
                PropertyName name2 = ctor == propertyCtor ? ctorPropNames[0] : null;
                this._handleSingleArgumentConstructor(ctxt, beanDesc, vchecker, intr, creators, ctor, isCreator, isVisible, name2);
                continue;
            }
            if (!isCreator && !isVisible) continue;
            AnnotatedParameter nonAnnotatedParam = null;
            int namedCount = 0;
            int injectCount = 0;
            CreatorProperty[] properties2 = new CreatorProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = ctor.getParameter(i);
                PropertyName name3 = null;
                if (ctor == propertyCtor) {
                    name3 = ctorPropNames[i];
                }
                if (name3 == null) {
                    name3 = this._findParamName(param, intr);
                }
                Object injectId = intr.findInjectableValueId(param);
                if (name3 != null && name3.hasSimpleName()) {
                    ++namedCount;
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, name3, i, param, injectId);
                    continue;
                }
                if (injectId != null) {
                    ++injectCount;
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, name3, i, param, injectId);
                    continue;
                }
                NameTransformer unwrapper = intr.findUnwrappingNameTransformer(param);
                if (unwrapper != null) {
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, UNWRAPPED_CREATOR_PARAM_NAME, i, param, null);
                    ++namedCount;
                    continue;
                }
                if (nonAnnotatedParam != null) continue;
                nonAnnotatedParam = param;
            }
            if (!isCreator && namedCount <= 0 && injectCount <= 0) continue;
            if (namedCount + injectCount == argCount) {
                creators.addPropertyCreator(ctor, properties2);
                continue;
            }
            if (namedCount == 0 && injectCount + 1 == argCount) {
                creators.addDelegatingCreator(ctor, properties2);
                continue;
            }
            creators.addIncompeteParameter(nonAnnotatedParam);
        }
    }

    protected boolean _handleSingleArgumentConstructor(DeserializationContext ctxt, BeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators, AnnotatedConstructor ctor, boolean isCreator, boolean isVisible, PropertyName name2) throws JsonMappingException {
        Object injectId;
        AnnotatedParameter param = ctor.getParameter(0);
        if (name2 == null) {
            name2 = this._findParamName(param, intr);
        }
        if ((injectId = intr.findInjectableValueId(param)) != null || name2 != null && name2.hasSimpleName()) {
            CreatorProperty[] properties2 = new CreatorProperty[]{this.constructCreatorProperty(ctxt, beanDesc, name2, 0, param, injectId)};
            creators.addPropertyCreator(ctor, properties2);
            return true;
        }
        Class<?> type2 = ctor.getRawParameterType(0);
        if (type2 == String.class) {
            if (isCreator || isVisible) {
                creators.addStringCreator(ctor);
            }
            return true;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            if (isCreator || isVisible) {
                creators.addIntCreator(ctor);
            }
            return true;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            if (isCreator || isVisible) {
                creators.addLongCreator(ctor);
            }
            return true;
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            if (isCreator || isVisible) {
                creators.addDoubleCreator(ctor);
            }
            return true;
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            if (isCreator || isVisible) {
                creators.addBooleanCreator(ctor);
            }
            return true;
        }
        if (isCreator) {
            creators.addDelegatingCreator(ctor, null);
            return true;
        }
        return false;
    }

    protected void _addDeserializerFactoryMethods(DeserializationContext ctxt, BeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            boolean isCreator = intr.hasCreatorAnnotation(factory);
            int argCount = factory.getParameterCount();
            if (argCount == 0) {
                if (!isCreator) continue;
                creators.setDefaultCreator(factory);
                continue;
            }
            if (argCount == 1) {
                AnnotatedParameter param = factory.getParameter(0);
                PropertyName pn = this._findParamName(param, intr);
                String name2 = pn == null ? null : pn.getSimpleName();
                Object injectId = intr.findInjectableValueId(param);
                if (injectId == null && (name2 == null || name2.length() == 0)) {
                    this._handleSingleArgumentFactory(config, beanDesc, vchecker, intr, creators, factory, isCreator);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation(factory)) continue;
            AnnotatedParameter nonAnnotatedParam = null;
            CreatorProperty[] properties2 = new CreatorProperty[argCount];
            int namedCount = 0;
            int injectCount = 0;
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = factory.getParameter(i);
                PropertyName name3 = this._findParamName(param, intr);
                Object injectId = intr.findInjectableValueId(param);
                if (name3 != null && name3.hasSimpleName()) {
                    ++namedCount;
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, name3, i, param, injectId);
                    continue;
                }
                if (injectId != null) {
                    ++injectCount;
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, name3, i, param, injectId);
                    continue;
                }
                NameTransformer unwrapper = intr.findUnwrappingNameTransformer(param);
                if (unwrapper != null) {
                    properties2[i] = this.constructCreatorProperty(ctxt, beanDesc, UNWRAPPED_CREATOR_PARAM_NAME, i, param, null);
                    ++namedCount;
                    continue;
                }
                if (nonAnnotatedParam != null) continue;
                nonAnnotatedParam = param;
            }
            if (!isCreator && namedCount <= 0 && injectCount <= 0) continue;
            if (namedCount + injectCount == argCount) {
                creators.addPropertyCreator(factory, properties2);
                continue;
            }
            if (namedCount == 0 && injectCount + 1 == argCount) {
                creators.addDelegatingCreator(factory, properties2);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + nonAnnotatedParam.getIndex() + " of factory method " + factory + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentFactory(DeserializationConfig config, BeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators, AnnotatedMethod factory, boolean isCreator) throws JsonMappingException {
        Class<?> type2 = factory.getRawParameterType(0);
        if (type2 == String.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addStringCreator(factory);
            }
            return true;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addIntCreator(factory);
            }
            return true;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addLongCreator(factory);
            }
            return true;
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addDoubleCreator(factory);
            }
            return true;
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addBooleanCreator(factory);
            }
            return true;
        }
        if (intr.hasCreatorAnnotation(factory)) {
            creators.addDelegatingCreator(factory, null);
            return true;
        }
        return false;
    }

    protected CreatorProperty constructCreatorProperty(DeserializationContext ctxt, BeanDescription beanDesc, PropertyName name2, int index, AnnotatedParameter param, Object injectableValueId) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Boolean b = intr == null ? null : intr.hasRequiredMarker(param);
        boolean req = b != null && b != false;
        String desc = intr == null ? null : intr.findPropertyDescription(param);
        Integer idx = intr == null ? null : intr.findPropertyIndex(param);
        PropertyMetadata metadata2 = PropertyMetadata.construct(req, desc, idx);
        JavaType t0 = config.getTypeFactory().constructType(param.getParameterType(), beanDesc.bindingsForBeanType());
        BeanProperty.Std property = new BeanProperty.Std(name2, t0, intr.findWrapperName(param), beanDesc.getClassAnnotations(), (AnnotatedMember)param, metadata2);
        JavaType type2 = this.resolveType(ctxt, beanDesc, t0, param);
        if (type2 != t0) {
            property = property.withType(type2);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(ctxt, param);
        TypeDeserializer typeDeser = (TypeDeserializer)(type2 = this.modifyTypeByAnnotation(ctxt, param, type2)).getTypeHandler();
        if (typeDeser == null) {
            typeDeser = this.findTypeDeserializer(config, type2);
        }
        SettableBeanProperty prop = new CreatorProperty(name2, type2, property.getWrapperName(), typeDeser, beanDesc.getClassAnnotations(), param, index, injectableValueId, metadata2);
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop);
            prop = prop.withValueDeserializer((JsonDeserializer)deser);
        }
        return prop;
    }

    protected PropertyName _findParamName(AnnotatedParameter param, AnnotationIntrospector intr) {
        if (param != null && intr != null) {
            PropertyName name2 = intr.findNameForDeserialization(param);
            if (name2 != null) {
                return name2;
            }
            String str = intr.findImplicitPropertyName(param);
            if (str != null && !str.isEmpty()) {
                return new PropertyName(str);
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext ctxt, ArrayType type2, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer deser;
        DeserializationConfig config = ctxt.getConfig();
        JavaType elemType = type2.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)elemType.getValueHandler();
        TypeDeserializer elemTypeDeser = (TypeDeserializer)elemType.getTypeHandler();
        if (elemTypeDeser == null) {
            elemTypeDeser = this.findTypeDeserializer(config, elemType);
        }
        if ((deser = this._findCustomArrayDeserializer(type2, config, beanDesc, elemTypeDeser, contentDeser)) == null) {
            if (contentDeser == null) {
                Class<?> raw = elemType.getRawClass();
                if (elemType.isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(raw);
                }
                if (raw == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            deser = new ObjectArrayDeserializer(type2, contentDeser, elemTypeDeser);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyArrayDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findArrayDeserializer(type2, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext ctxt, CollectionType type2, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer deser;
        JavaType contentType = type2.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        DeserializationConfig config = ctxt.getConfig();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType);
        }
        if ((deser = this._findCustomCollectionDeserializer(type2, config, beanDesc, contentTypeDeser, contentDeser)) == null) {
            Class<?> collectionClass = type2.getRawClass();
            if (contentDeser == null && EnumSet.class.isAssignableFrom(collectionClass)) {
                deser = new EnumSetDeserializer(contentType, null);
            }
        }
        if (deser == null) {
            if (type2.isInterface() || type2.isAbstract()) {
                CollectionType implType = this._mapAbstractCollectionType(type2, config);
                if (implType == null) {
                    if (type2.getTypeHandler() == null) {
                        throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type2);
                    }
                    deser = AbstractDeserializer.constructForNonPOJO(beanDesc);
                } else {
                    type2 = implType;
                    beanDesc = config.introspectForCreation(type2);
                }
            }
            if (deser == null) {
                ValueInstantiator inst = this.findValueInstantiator(ctxt, beanDesc);
                if (!inst.canCreateUsingDefault() && type2.getRawClass() == ArrayBlockingQueue.class) {
                    return new ArrayBlockingQueueDeserializer(type2, contentDeser, contentTypeDeser, inst, null);
                }
                deser = contentType.getRawClass() == String.class ? new StringCollectionDeserializer(type2, contentDeser, inst) : new CollectionDeserializer(type2, contentDeser, contentTypeDeser, inst);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyCollectionDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType type2, DeserializationConfig config) {
        Class<Object> collectionClass = type2.getRawClass();
        if ((collectionClass = _collectionFallbacks.get(collectionClass.getName())) == null) {
            return null;
        }
        return (CollectionType)config.constructSpecializedType(type2, collectionClass);
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionDeserializer(type2, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext ctxt, CollectionLikeType type2, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer<?> deser;
        JavaType contentType = type2.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        DeserializationConfig config = ctxt.getConfig();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType);
        }
        if ((deser = this._findCustomCollectionLikeDeserializer(type2, config, beanDesc, contentTypeDeser, contentDeser)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyCollectionLikeDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionLikeDeserializer(type2, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext ctxt, MapType type2, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer deser;
        DeserializationConfig config = ctxt.getConfig();
        JavaType keyType = type2.getKeyType();
        JavaType contentType = type2.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType);
        }
        if ((deser = this._findCustomMapDeserializer(type2, config, beanDesc, keyDes, contentTypeDeser, contentDeser)) == null) {
            Class<Object> mapClass = type2.getRawClass();
            if (EnumMap.class.isAssignableFrom(mapClass)) {
                Class<?> kt = keyType.getRawClass();
                if (kt == null || !kt.isEnum()) {
                    throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
                }
                deser = new EnumMapDeserializer(type2, null, contentDeser, contentTypeDeser);
            }
            if (deser == null) {
                if (type2.isInterface() || type2.isAbstract()) {
                    Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
                    if (fallback != null) {
                        mapClass = fallback;
                        type2 = (MapType)config.constructSpecializedType(type2, mapClass);
                        beanDesc = config.introspectForCreation(type2);
                    } else {
                        if (type2.getTypeHandler() == null) {
                            throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type2);
                        }
                        deser = AbstractDeserializer.constructForNonPOJO(beanDesc);
                    }
                }
                if (deser == null) {
                    ValueInstantiator inst = this.findValueInstantiator(ctxt, beanDesc);
                    MapDeserializer md = new MapDeserializer(type2, inst, keyDes, contentDeser, contentTypeDeser);
                    md.setIgnorableProperties(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()));
                    deser = md;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyMapDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext ctxt, MapLikeType type2, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer<?> deser;
        JavaType keyType = type2.getKeyType();
        JavaType contentType = type2.getContentType();
        DeserializationConfig config = ctxt.getConfig();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType);
        }
        if ((deser = this._findCustomMapLikeDeserializer(type2, config, beanDesc, keyDes, contentTypeDeser, contentDeser)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyMapLikeDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType type2, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapDeserializer(type2, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type2, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapLikeDeserializer(type2, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext ctxt, JavaType type2, BeanDescription beanDesc) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        Class<?> enumClass = type2.getRawClass();
        JsonDeserializer deser = this._findCustomEnumDeserializer(enumClass, config, beanDesc);
        if (deser == null) {
            for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
                Class<?> returnType;
                if (!ctxt.getAnnotationIntrospector().hasCreatorAnnotation(factory)) continue;
                int argCount = factory.getParameterCount();
                if (argCount == 1 && (returnType = factory.getRawReturnType()).isAssignableFrom(enumClass)) {
                    deser = EnumDeserializer.deserializerForCreator(config, enumClass, factory);
                    break;
                }
                throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
            }
            if (deser == null) {
                deser = new EnumDeserializer(this.constructEnumResolver(enumClass, config, beanDesc.findJsonValueMethod()));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyEnumDeserializer(config, type2, beanDesc, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findEnumDeserializer(type2, config, beanDesc);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config, JavaType nodeType, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> nodeClass = nodeType.getRawClass();
        JsonDeserializer<?> custom = this._findCustomTreeNodeDeserializer(nodeClass, config, beanDesc);
        if (custom != null) {
            return custom;
        }
        return JsonNodeDeserializer.getDeserializer(nodeClass);
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findTreeNodeDeserializer(type2, config, beanDesc);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig config, JavaType baseType) throws JsonMappingException {
        JavaType defaultType2;
        BeanDescription bean = config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType2 = this.mapAbstractType(config, baseType)) != null && defaultType2.getRawClass() != baseType.getRawClass()) {
            b = b.defaultImpl(defaultType2.getRawClass());
        }
        return b.buildTypeDeserializer(config, baseType, subtypes);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        KeyDeserializer deser = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers d;
            BeanDescription beanDesc = config.introspectClassAnnotations(type2.getRawClass());
            Iterator<KeyDeserializers> i$ = this._factoryConfig.keyDeserializers().iterator();
            while (i$.hasNext() && (deser = (d = i$.next()).findKeyDeserializer(type2, config, beanDesc)) == null) {
            }
        }
        if (deser == null) {
            if (type2.isEnumType()) {
                return this._createEnumKeyDeserializer(ctxt, type2);
            }
            deser = StdKeyDeserializers.findStringBasedKeyDeserializer(config, type2);
        }
        if (deser != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyKeyDeserializer(config, type2, deser);
            }
        }
        return deser;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        Object beanDesc = config.introspect(type2);
        JsonDeserializer<Object> des = this.findDeserializerFromAnnotation(ctxt, ((BeanDescription)beanDesc).getClassInfo());
        if (des != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(config, type2, des);
        }
        Class<?> enumClass = type2.getRawClass();
        JsonDeserializer<?> custom = this._findCustomEnumDeserializer(enumClass, config, (BeanDescription)beanDesc);
        if (custom != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(config, type2, custom);
        }
        EnumResolver<?> enumRes = this.constructEnumResolver(enumClass, config, ((BeanDescription)beanDesc).findJsonValueMethod());
        for (AnnotatedMethod factory : ((BeanDescription)beanDesc).getFactoryMethods()) {
            Class<?> returnType;
            if (!config.getAnnotationIntrospector().hasCreatorAnnotation(factory)) continue;
            int argCount = factory.getParameterCount();
            if (argCount == 1 && (returnType = factory.getRawReturnType()).isAssignableFrom(enumClass)) {
                if (factory.getGenericParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + factory + ") not suitable, must be java.lang.String");
                }
                if (config.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(factory.getMember());
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer(enumRes, factory);
            }
            throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer(enumRes);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig config, JavaType baseType, AnnotatedMember annotated) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config, annotated, baseType);
        if (b == null) {
            return this.findTypeDeserializer(config, baseType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(annotated, config, ai, baseType);
        return b.buildTypeDeserializer(config, baseType, subtypes);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig config, JavaType containerType, AnnotatedMember propertyEntity) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config, propertyEntity, containerType);
        JavaType contentType = containerType.getContentType();
        if (b == null) {
            return this.findTypeDeserializer(config, contentType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(propertyEntity, config, ai, contentType);
        return b.buildTypeDeserializer(config, contentType, subtypes);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext ctxt, JavaType type2, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> rawType = type2.getRawClass();
        if (rawType == CLASS_OBJECT) {
            return new UntypedObjectDeserializer();
        }
        if (rawType == CLASS_STRING || rawType == CLASS_CHAR_BUFFER) {
            return StringDeserializer.instance;
        }
        if (rawType == CLASS_ITERABLE) {
            TypeFactory tf = ctxt.getTypeFactory();
            JavaType elemType = type2.containedTypeCount() > 0 ? type2.containedType(0) : TypeFactory.unknownType();
            CollectionType ct = tf.constructCollectionType(Collection.class, elemType);
            return this.createCollectionDeserializer(ctxt, ct, beanDesc);
        }
        String clsName = rawType.getName();
        if (rawType.isPrimitive() || clsName.startsWith("java.")) {
            JsonDeserializer<?> deser = NumberDeserializers.find(rawType, clsName);
            if (deser == null) {
                deser = DateDeserializers.find(rawType, clsName);
            }
            if (deser != null) {
                return deser;
            }
        }
        if (rawType == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        return JdkDeserializers.find(rawType, clsName);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        return ctxt.deserializerInstance(ann, deserDef);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(DeserializationContext ctxt, Annotated a, T type2) throws JsonMappingException {
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, (JavaType)type2);
        if (subclass != null) {
            try {
                type2 = ((JavaType)type2).narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type2 + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (((JavaType)type2).isContainerType()) {
            Object cdDef;
            JsonDeserializer<Object> cd;
            JavaType contentType;
            Class<?> cc;
            Object kdDef;
            KeyDeserializer kd;
            JavaType keyType;
            Class<?> keyClass = intr.findDeserializationKeyType(a, ((JavaType)type2).getKeyType());
            if (keyClass != null) {
                if (!(type2 instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type2 + " is not a Map(-like) type");
                }
                try {
                    type2 = ((MapLikeType)type2).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type2 + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((keyType = ((JavaType)type2).getKeyType()) != null && keyType.getValueHandler() == null && (kd = ctxt.keyDeserializerInstance(a, kdDef = intr.findKeyDeserializer(a))) != null) {
                type2 = ((MapLikeType)type2).withKeyValueHandler(kd);
                keyType = ((JavaType)type2).getKeyType();
            }
            if ((cc = intr.findDeserializationContentType(a, ((JavaType)type2).getContentType())) != null) {
                try {
                    type2 = ((JavaType)type2).narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type2 + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((contentType = ((JavaType)type2).getContentType()).getValueHandler() == null && (cd = ctxt.deserializerInstance(a, cdDef = intr.findContentDeserializer(a))) != null) {
                type2 = ((JavaType)type2).withContentValueHandler(cd);
            }
        }
        return (T)type2;
    }

    protected JavaType resolveType(DeserializationContext ctxt, BeanDescription beanDesc, JavaType type2, AnnotatedMember member) throws JsonMappingException {
        TypeDeserializer valueTypeDeser;
        if (type2.isContainerType()) {
            TypeDeserializer contentTypeDeser;
            Object cdDef;
            JsonDeserializer<Object> cd;
            Object kdDef;
            KeyDeserializer kd;
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            JavaType keyType = type2.getKeyType();
            if (keyType != null && (kd = ctxt.keyDeserializerInstance(member, kdDef = intr.findKeyDeserializer(member))) != null) {
                type2 = ((MapLikeType)type2).withKeyValueHandler(kd);
                keyType = type2.getKeyType();
            }
            if ((cd = ctxt.deserializerInstance(member, cdDef = intr.findContentDeserializer(member))) != null) {
                type2 = type2.withContentValueHandler(cd);
            }
            if (member instanceof AnnotatedMember && (contentTypeDeser = this.findPropertyContentTypeDeserializer(ctxt.getConfig(), type2, member)) != null) {
                type2 = type2.withContentTypeHandler(contentTypeDeser);
            }
        }
        if ((valueTypeDeser = member instanceof AnnotatedMember ? this.findPropertyTypeDeserializer(ctxt.getConfig(), type2, member) : this.findTypeDeserializer(ctxt.getConfig(), type2)) != null) {
            type2 = type2.withTypeHandler(valueTypeDeser);
        }
        return type2;
    }

    protected EnumResolver<?> constructEnumResolver(Class<?> enumClass, DeserializationConfig config, AnnotatedMethod jsonValueMethod) {
        if (jsonValueMethod != null) {
            Method accessor = jsonValueMethod.getAnnotated();
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(accessor);
            }
            return EnumResolver.constructUnsafeUsingMethod(enumClass, accessor);
        }
        if (config.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return EnumResolver.constructUnsafeUsingToString(enumClass);
        }
        return EnumResolver.constructUnsafe(enumClass, config.getAnnotationIntrospector());
    }

    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig config, JavaType enumType) {
        if (enumType == null) {
            return null;
        }
        Object beanDesc = config.introspect(enumType);
        return ((BeanDescription)beanDesc).findJsonValueMethod();
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<ConcurrentSkipListMap> value;
            Class<ConcurrentNavigableMap> key = ConcurrentNavigableMap.class;
            Class<ConcurrentSkipListMap> mapValue = value = ConcurrentSkipListMap.class;
            _mapFallbacks.put(key.getName(), mapValue);
        }
        catch (Throwable e) {
            System.err.println("Problems with (optional) types: " + e);
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

