/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype;

import java.io.IOException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeIdResolver;

public abstract class TypeDeserializer {
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2) throws IOException;

    public static Object deserializeIfNatural(JsonParser jp, DeserializationContext ctxt, JavaType baseType) throws IOException {
        return TypeDeserializer.deserializeIfNatural(jp, ctxt, baseType.getRawClass());
    }

    public static Object deserializeIfNatural(JsonParser jp, DeserializationContext ctxt, Class<?> base2) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == null) {
            return null;
        }
        switch (t) {
            case VALUE_STRING: {
                if (!base2.isAssignableFrom(String.class)) break;
                return jp.getText();
            }
            case VALUE_NUMBER_INT: {
                if (!base2.isAssignableFrom(Integer.class)) break;
                return jp.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!base2.isAssignableFrom(Double.class)) break;
                return jp.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!base2.isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!base2.isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

