/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.io.SerializedString;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.NameTransformer;

public class UnwrappingBeanPropertyWriter
extends BeanPropertyWriter {
    protected final NameTransformer _nameTransformer;

    public UnwrappingBeanPropertyWriter(BeanPropertyWriter base2, NameTransformer unwrapper) {
        super(base2);
        this._nameTransformer = unwrapper;
    }

    private UnwrappingBeanPropertyWriter(UnwrappingBeanPropertyWriter base2, NameTransformer transformer, SerializedString name2) {
        super(base2, name2);
        this._nameTransformer = transformer;
    }

    @Override
    public UnwrappingBeanPropertyWriter rename(NameTransformer transformer) {
        String oldName = this._name.getValue();
        String newName = transformer.transform(oldName);
        transformer = NameTransformer.chainedTransformer(transformer, this._nameTransformer);
        return new UnwrappingBeanPropertyWriter(this, transformer, new SerializedString(newName));
    }

    @Override
    public boolean isUnwrapping() {
        return true;
    }

    @Override
    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map2;
        Object value = this.get(bean);
        if (value == null) {
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map2 = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map2, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, jgen, prov, ser)) {
            return;
        }
        if (!ser.isUnwrappingSerializer()) {
            jgen.writeFieldName(this._name);
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
    }

    @Override
    public void assignSerializer(JsonSerializer<Object> ser) {
        super.assignSerializer(ser);
        if (this._serializer != null) {
            NameTransformer t = this._nameTransformer;
            if (this._serializer.isUnwrappingSerializer()) {
                t = NameTransformer.chainedTransformer(t, ((UnwrappingBeanSerializer)this._serializer)._nameTransformer);
            }
            this._serializer = this._serializer.unwrappingSerializer(t);
        }
    }

    @Override
    protected void _depositSchemaProperty(ObjectNode propertiesNode, JsonNode schemaNode) {
        JsonNode props = schemaNode.get("properties");
        if (props != null) {
            Iterator<Map.Entry<String, JsonNode>> it = props.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> entry = it.next();
                String name2 = entry.getKey();
                if (this._nameTransformer != null) {
                    name2 = this._nameTransformer.transform(name2);
                }
                propertiesNode.set(name2, entry.getValue());
            }
        }
    }

    @Override
    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map2, Class<?> type2, SerializerProvider provider) throws JsonMappingException {
        JsonSerializer<Object> serializer;
        if (this._nonTrivialBaseType != null) {
            JavaType subtype = provider.constructSpecializedType(this._nonTrivialBaseType, type2);
            serializer = provider.findValueSerializer(subtype, (BeanProperty)this);
        } else {
            serializer = provider.findValueSerializer(type2, (BeanProperty)this);
        }
        NameTransformer t = this._nameTransformer;
        if (serializer.isUnwrappingSerializer()) {
            t = NameTransformer.chainedTransformer(t, ((UnwrappingBeanSerializer)serializer)._nameTransformer);
        }
        serializer = serializer.unwrappingSerializer(t);
        this._dynamicSerializers = this._dynamicSerializers.newWith(type2, serializer);
        return serializer;
    }
}

