/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hudi.org.eclipse.jetty.util.ClassVisibilityChecker;
import org.apache.hudi.org.eclipse.jetty.util.IO;
import org.apache.hudi.org.eclipse.jetty.util.TypeUtil;
import org.apache.hudi.org.eclipse.jetty.util.URIUtil;
import org.apache.hudi.org.eclipse.jetty.util.log.Log;
import org.apache.hudi.org.eclipse.jetty.util.log.Logger;
import org.apache.hudi.org.eclipse.jetty.util.resource.Resource;
import org.apache.hudi.org.eclipse.jetty.util.resource.ResourceCollection;

public class WebAppClassLoader
extends URLClassLoader
implements ClassVisibilityChecker {
    private static final Logger LOG;
    private static final ThreadLocal<Boolean> __loadServerClasses;
    private final Context _context;
    private final ClassLoader _parent;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();

    public static <T> T runWithServerClassAccess(PrivilegedExceptionAction<T> action) throws Exception {
        Boolean lsc = __loadServerClasses.get();
        try {
            __loadServerClasses.set(true);
            T t = action.run();
            return t;
        }
        finally {
            if (lsc == null) {
                __loadServerClasses.remove();
            } else {
                __loadServerClasses.set(lsc);
            }
        }
    }

    public WebAppClassLoader(Context context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, Context context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._parent = this.getParent();
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name2) {
        this._name = name2;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) throws IOException {
        if (resource instanceof ResourceCollection) {
            for (Resource r : ((ResourceCollection)resource).getResources()) {
                this.addClassPath(r);
            }
        } else {
            this.addClassPath(resource.toString());
        }
    }

    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource;
            String token = tokenizer.nextToken().trim();
            if (token.endsWith("*")) {
                if (token.length() > 1) {
                    token = token.substring(0, token.length() - 1);
                    resource = this._context.newResource(token);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Glob Path resource=" + resource, new Object[0]);
                    }
                    resource = this._context.newResource(token);
                    this.addJars(resource);
                }
                return;
            }
            resource = this._context.newResource(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path resource=" + resource, new Object[0]);
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection) {
                this.addClassPath(resource);
                continue;
            }
            File file = resource.getFile();
            if (file != null) {
                URL url2 = resource.getURI().toURL();
                this.addURL(url2);
                continue;
            }
            if (resource.isDirectory()) {
                this.addURL(resource.getURI().toURL());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check file exists and is not nested jar: " + resource, new Object[0]);
            }
            throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + resource);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        Object[] entries;
        if (lib.exists() && lib.isDirectory() && (entries = lib.list()) != null) {
            Arrays.sort(entries);
            for (Object entry : entries) {
                try {
                    String fnlc;
                    Resource resource = lib.addPath((String)entry);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("addJar - {}", resource);
                    }
                    if (!this.isFileSupported(fnlc = resource.getName().toLowerCase(Locale.ENGLISH))) continue;
                    String jar = URIUtil.encodeSpecific(resource.toString(), ",;");
                    this.addClassPath(jar);
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", ex);
                }
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        ArrayList<URL> resources;
        URL url2;
        ArrayList<URL> fromParent = new ArrayList<URL>();
        ArrayList<URL> fromWebapp = new ArrayList<URL>();
        Enumeration<URL> urls = this._parent.getResources(name2);
        while (urls != null && urls.hasMoreElements()) {
            url2 = urls.nextElement();
            if (!Boolean.TRUE.equals(__loadServerClasses.get()) && this._context.isServerResource(name2, url2)) continue;
            fromParent.add(url2);
        }
        urls = this.findResources(name2);
        while (urls != null && urls.hasMoreElements()) {
            url2 = urls.nextElement();
            if (this._context.isSystemResource(name2, url2) && !fromParent.isEmpty()) continue;
            fromWebapp.add(url2);
        }
        if (this._context.isParentLoaderPriority()) {
            fromParent.addAll(fromWebapp);
            resources = fromParent;
        } else {
            fromWebapp.addAll(fromParent);
            resources = fromWebapp;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResources {} {}", name2, resources);
        }
        return Collections.enumeration(resources);
    }

    @Override
    public URL getResource(String name2) {
        URL resource = null;
        if (this._context.isParentLoaderPriority()) {
            URL parentUrl = this._parent.getResource(name2);
            if (parentUrl != null && (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerResource(name2, parentUrl))) {
                resource = parentUrl;
            } else {
                URL webappUrl = this.findResource(name2);
                if (webappUrl != null) {
                    resource = webappUrl;
                }
            }
        } else {
            URL webappUrl = this.findResource(name2);
            if (webappUrl != null && !this._context.isSystemResource(name2, webappUrl)) {
                resource = webappUrl;
            } else {
                URL parentUrl = this._parent.getResource(name2);
                if (parentUrl != null && (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerResource(name2, parentUrl))) {
                    resource = parentUrl;
                } else if (webappUrl != null) {
                    resource = webappUrl;
                }
            }
        }
        if (resource == null && name2.startsWith("/")) {
            resource = this.getResource(name2.substring(1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResource {} {}", name2, resource);
        }
        return resource;
    }

    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            ClassNotFoundException ex = null;
            Class<?> parentClass = null;
            Class<?> webappClass = null;
            webappClass = this.findLoadedClass(name2);
            if (webappClass != null) {
                return webappClass;
            }
            if (this._context.isParentLoaderPriority()) {
                try {
                    parentClass = this._parent.loadClass(name2);
                    if (parentClass == null) {
                        throw new ClassNotFoundException("Bad ClassLoader: returned null for loadClass(" + name2 + ")");
                    }
                    if (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerClass(parentClass)) {
                        return parentClass;
                    }
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
                try {
                    webappClass = this.findClass(name2);
                    if (resolve2) {
                        this.resolveClass(webappClass);
                    }
                    return webappClass;
                }
                catch (ClassNotFoundException e) {
                    if (ex == null) {
                        ex = e;
                    } else if (e != ex) {
                        ex.addSuppressed(e);
                    }
                    throw ex;
                }
            }
            webappClass = this.loadAsResource(name2, true);
            if (webappClass != null) {
                return webappClass;
            }
            try {
                parentClass = this._parent.loadClass(name2);
                if (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerClass(parentClass)) {
                    return parentClass;
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            webappClass = this.loadAsResource(name2, false);
            if (webappClass != null) {
                return webappClass;
            }
            throw ex == null ? new ClassNotFoundException(name2) : ex;
        }
    }

    @Deprecated
    public void addClassFileTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    @Deprecated
    public boolean removeClassFileTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    protected Class<?> loadAsResource(String name2, boolean checkSystemResource) throws ClassNotFoundException {
        Class<?> webappClass = null;
        String path = TypeUtil.toClassReference(name2);
        URL webappUrl = this.findResource(path);
        if (!(webappUrl == null || checkSystemResource && this._context.isSystemResource(name2, webappUrl))) {
            webappClass = this.foundClass(name2, webappUrl);
            this.resolveClass(webappClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WAP webapp loaded {}", webappClass);
            }
        }
        return webappClass;
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name2);
        }
        String path = TypeUtil.toClassReference(name2);
        URL url2 = this.findResource(path);
        if (url2 == null) {
            throw new ClassNotFoundException(name2);
        }
        return this.foundClass(name2, url2);
    }

    protected Class<?> foundClass(String name2, URL url2) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name2);
        }
        InputStream content = null;
        try {
            content = url2.openStream();
            byte[] bytes = IO.readBytes(content);
            for (ClassFileTransformer transformer : this._transformers) {
                byte[] tmp = transformer.transform(this, name2, null, null, bytes);
                if (tmp == null) continue;
                bytes = tmp;
            }
            Class<?> clazz = this.defineClass(name2, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
        catch (IllegalClassFormatException e) {
            throw new ClassNotFoundException(name2, e);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name2, e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return String.format("%s{%s}@%x", this.getClass().getSimpleName(), this._name, this.hashCode());
    }

    @Override
    public boolean isSystemClass(Class<?> clazz) {
        return this._context.isSystemClass(clazz);
    }

    @Override
    public boolean isServerClass(Class<?> clazz) {
        return this._context.isServerClass(clazz);
    }

    static {
        WebAppClassLoader.registerAsParallelCapable();
        LOG = Log.getLogger(WebAppClassLoader.class);
        __loadServerClasses = new ThreadLocal();
    }

    public static interface Context
    extends ClassVisibilityChecker {
        public Resource newResource(String var1) throws IOException;

        public PermissionCollection getPermissions();

        public boolean isParentLoaderPriority();

        public String getExtraClasspath();

        public boolean isServerResource(String var1, URL var2);

        public boolean isSystemResource(String var1, URL var2);
    }
}

