/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.layouters;

import java.util.TreeSet;
import org.apache.hudi.org.openjdk.jol.datamodel.DataModel;
import org.apache.hudi.org.openjdk.jol.info.ClassData;
import org.apache.hudi.org.openjdk.jol.info.ClassLayout;
import org.apache.hudi.org.openjdk.jol.info.FieldData;
import org.apache.hudi.org.openjdk.jol.info.FieldLayout;
import org.apache.hudi.org.openjdk.jol.layouters.Layouter;

public class RawLayouter
implements Layouter {
    private final DataModel model;

    public RawLayouter(DataModel model) {
        this.model = model;
    }

    @Override
    public ClassLayout layout(ClassData data2) {
        TreeSet<FieldLayout> result2 = new TreeSet<FieldLayout>();
        if (data2.isArray()) {
            int base2 = this.model.arrayHeaderSize();
            int scale = this.model.sizeOf(data2.arrayComponentType());
            long instanceSize = (long)base2 + data2.arrayLength() * (long)scale;
            result2.add(new FieldLayout(FieldData.create(data2.arrayClass(), "<elements>", data2.arrayComponentType()), base2, (long)scale * data2.arrayLength()));
            return ClassLayout.create(data2, result2, this.model, instanceSize, false);
        }
        int offset = this.model.headerSize();
        for (FieldData f : data2.fields()) {
            int size = this.model.sizeOf(f.typeClass());
            result2.add(new FieldLayout(f, offset, size));
            offset += size;
        }
        if (result2.isEmpty()) {
            return ClassLayout.create(data2, result2, this.model, this.model.headerSize(), false);
        }
        FieldLayout f = (FieldLayout)result2.last();
        return ClassLayout.create(data2, result2, this.model, f.offset() + f.size(), false);
    }

    public String toString() {
        return "Raw data (" + this.model + ")";
    }
}

